/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.propagation.semianalytical.dsst.forces.ForceModelContext;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;

class DSSTTesseralContext
extends ForceModelContext {
    private static final int I = 1;
    private static final double MIN_PERIOD_IN_SECONDS = 864000.0;
    private static final double MIN_PERIOD_IN_SAT_REV = 10.0;
    private double A;
    private double chi;
    private double chi2;
    private double theta;
    private double ax2oA;
    private double ooAB;
    private double BoA;
    private double BoABpo;
    private double Co2AB;
    private double moa;
    private double roa;
    private double e2;
    private int maxEccPow = 0;
    private double n;
    private double period;
    private double ratio;
    private final List<Integer> resOrders = new ArrayList<Integer>();

    DSSTTesseralContext(AuxiliaryElements auxiliaryElements, Frame centralBodyFrame, UnnormalizedSphericalHarmonicsProvider provider, int maxFrequencyShortPeriodics, double bodyPeriod, double[] parameters) {
        super(auxiliaryElements);
        double mu = parameters[0];
        double absA = FastMath.abs((double)auxiliaryElements.getSma());
        this.n = FastMath.sqrt((double)(mu / absA)) / absA;
        double a = auxiliaryElements.getSma();
        this.period = a < 0.0 ? Double.POSITIVE_INFINITY : Math.PI * 2 * a * FastMath.sqrt((double)(a / mu));
        this.A = FastMath.sqrt((double)(mu * auxiliaryElements.getSma()));
        this.e2 = auxiliaryElements.getEcc() * auxiliaryElements.getEcc();
        Transform t = centralBodyFrame.getTransformTo(auxiliaryElements.getFrame(), auxiliaryElements.getDate());
        Vector3D xB = t.transformVector(Vector3D.PLUS_I);
        Vector3D yB = t.transformVector(Vector3D.PLUS_J);
        this.theta = FastMath.atan2((double)(-auxiliaryElements.getVectorF().dotProduct((Vector)yB) + 1.0 * auxiliaryElements.getVectorG().dotProduct((Vector)xB)), (double)(auxiliaryElements.getVectorF().dotProduct((Vector)xB) + 1.0 * auxiliaryElements.getVectorG().dotProduct((Vector)yB)));
        this.ax2oA = 2.0 * auxiliaryElements.getSma() / this.A;
        this.BoA = auxiliaryElements.getB() / this.A;
        this.ooAB = 1.0 / (this.A * auxiliaryElements.getB());
        this.Co2AB = auxiliaryElements.getC() * this.ooAB / 2.0;
        this.BoABpo = this.BoA / (1.0 + auxiliaryElements.getB());
        this.moa = mu / auxiliaryElements.getSma();
        this.roa = provider.getAe() / auxiliaryElements.getSma();
        this.chi = 1.0 / auxiliaryElements.getB();
        this.chi2 = this.chi * this.chi;
        double e = auxiliaryElements.getEcc();
        this.maxEccPow = e <= 0.005 ? 3 : (e <= 0.02 ? 4 : (e <= 0.1 ? 7 : (e <= 0.2 ? 10 : (e <= 0.3 ? 12 : (e <= 0.4 ? 15 : 20)))));
        this.ratio = this.period / bodyPeriod;
        double tolerance = 1.0 / FastMath.max((double)10.0, (double)(864000.0 / this.period));
        this.resOrders.clear();
        for (int m = 1; m <= provider.getMaxOrder(); ++m) {
            double resonance = this.ratio * (double)m;
            int jComputedRes = (int)FastMath.round((double)resonance);
            if (jComputedRes <= 0 || jComputedRes > maxFrequencyShortPeriodics || !(FastMath.abs((double)(resonance - (double)jComputedRes)) <= tolerance)) continue;
            this.resOrders.add(m);
        }
    }

    public List<Integer> getResOrders() {
        return this.resOrders;
    }

    public double getE2() {
        return this.e2;
    }

    public double getTheta() {
        return this.theta;
    }

    public double getAx2oA() {
        return this.ax2oA;
    }

    public double getChi() {
        return this.chi;
    }

    public double getChi2() {
        return this.chi2;
    }

    public double getBoA() {
        return this.BoA;
    }

    public double getOoAB() {
        return this.ooAB;
    }

    public double getCo2AB() {
        return this.Co2AB;
    }

    public double getBoABpo() {
        return this.BoABpo;
    }

    public double getMoa() {
        return this.moa;
    }

    public double getRoa() {
        return this.roa;
    }

    public int getMaxEccPow() {
        return this.maxEccPow;
    }

    public double getOrbitPeriod() {
        return this.period;
    }

    public double getMeanMotion() {
        return this.n;
    }

    public double getRatio() {
        return this.ratio;
    }
}

