/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.integration;

import java.util.List;
import java.util.Map;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.ode.FieldDenseOutputModel;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldOrbit;
import org.orekit.propagation.FieldAdditionalStateProvider;
import org.orekit.propagation.FieldBoundedPropagator;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.analytical.FieldAbstractAnalyticalPropagator;
import org.orekit.propagation.integration.FieldStateMapper;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldIntegratedEphemeris<T extends RealFieldElement<T>>
extends FieldAbstractAnalyticalPropagator<T>
implements FieldBoundedPropagator<T> {
    private static final double EXTRAPOLATION_TOLERANCE = 1.0;
    private final FieldStateMapper<T> mapper;
    private PropagationType type;
    private final FieldAbsoluteDate<T> startDate;
    private final FieldAbsoluteDate<T> minDate;
    private final FieldAbsoluteDate<T> maxDate;
    private FieldDenseOutputModel<T> model;
    private final Map<String, T[]> unmanaged;

    public FieldIntegratedEphemeris(FieldAbsoluteDate<T> startDate, FieldAbsoluteDate<T> minDate, FieldAbsoluteDate<T> maxDate, FieldStateMapper<T> mapper, PropagationType type, FieldDenseOutputModel<T> model, Map<String, T[]> unmanaged, List<FieldAdditionalStateProvider<T>> providers, String[] equations) {
        super(startDate.getField(), mapper.getAttitudeProvider());
        this.startDate = startDate;
        this.minDate = minDate;
        this.maxDate = maxDate;
        this.mapper = mapper;
        this.type = type;
        this.model = model;
        this.unmanaged = unmanaged;
        for (FieldAdditionalStateProvider<T> provider : providers) {
            this.addAdditionalStateProvider(provider);
        }
        for (int i = 0; i < equations.length; ++i) {
            this.addAdditionalStateProvider(new LocalProvider(equations[i], i));
        }
    }

    private FieldODEStateAndDerivative<T> getInterpolatedState(FieldAbsoluteDate<T> date) {
        if (date.compareTo((FieldAbsoluteDate<T>)this.minDate.shiftedBy(-1.0)) < 0 || date.compareTo((FieldAbsoluteDate<T>)this.maxDate.shiftedBy(1.0)) > 0) {
            throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE, date, this.minDate, this.maxDate);
        }
        return this.model.getInterpolatedState(date.durationFrom(this.startDate));
    }

    @Override
    protected FieldSpacecraftState<T> basicPropagate(FieldAbsoluteDate<T> date) {
        FieldODEStateAndDerivative<T> os = this.getInterpolatedState(date);
        FieldSpacecraftState state = this.mapper.mapArrayToState(this.mapper.mapDoubleToDate(os.getTime(), date), os.getPrimaryState(), os.getPrimaryDerivative(), this.type);
        for (Map.Entry<String, T[]> initial : this.unmanaged.entrySet()) {
            state = state.addAdditionalState(initial.getKey(), (RealFieldElement[])initial.getValue());
        }
        return state;
    }

    @Override
    protected FieldOrbit<T> propagateOrbit(FieldAbsoluteDate<T> date) {
        return this.basicPropagate(date).getOrbit();
    }

    @Override
    protected T getMass(FieldAbsoluteDate<T> date) {
        return this.basicPropagate(date).getMass();
    }

    @Override
    public TimeStampedFieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> date, Frame frame) {
        return this.propagate(date).getPVCoordinates(frame);
    }

    @Override
    public FieldAbsoluteDate<T> getMinDate() {
        return this.minDate;
    }

    @Override
    public FieldAbsoluteDate<T> getMaxDate() {
        return this.maxDate;
    }

    @Override
    public Frame getFrame() {
        return this.mapper.getFrame();
    }

    @Override
    public void resetInitialState(FieldSpacecraftState<T> state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected void resetIntermediateState(FieldSpacecraftState<T> state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    public FieldSpacecraftState<T> getInitialState() {
        return this.updateAdditionalStates(this.basicPropagate(this.getMinDate()));
    }

    private class LocalProvider
    implements FieldAdditionalStateProvider<T> {
        private final String name;
        private final int index;

        LocalProvider(String name, int index) {
            this.name = name;
            this.index = index;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public T[] getAdditionalState(FieldSpacecraftState<T> state) {
            return FieldIntegratedEphemeris.this.getInterpolatedState(state.getDate()).getSecondaryState(this.index + 1);
        }
    }
}

