/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.util.HashMap;
import java.util.Map;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.UnivariateDerivative1;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.TimeStampedAngularCoordinates;

public enum AEMAttitudeType {
    QUATERNION("QUATERNION"){

        @Override
        public double[] getAttitudeData(TimeStampedAngularCoordinates coordinates, boolean isFirst, RotationOrder order) {
            int[] nArray;
            double[] data = new double[4];
            if (isFirst) {
                int[] nArray2 = new int[4];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray = nArray2;
                nArray2[3] = 3;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = 3;
                nArray3[1] = 0;
                nArray3[2] = 1;
                nArray = nArray3;
                nArray3[3] = 2;
            }
            int[] quaternionIndex = nArray;
            Rotation rotation = coordinates.getRotation();
            data[quaternionIndex[0]] = rotation.getQ0();
            data[quaternionIndex[1]] = rotation.getQ1();
            data[quaternionIndex[2]] = rotation.getQ2();
            data[quaternionIndex[3]] = rotation.getQ3();
            return data;
        }

        @Override
        public TimeStampedAngularCoordinates getAngularCoordinates(AbsoluteDate date, double[] data, boolean isFirst, RotationOrder order) {
            int[] nArray;
            if (isFirst) {
                int[] nArray2 = new int[4];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray = nArray2;
                nArray2[3] = 3;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = 3;
                nArray3[1] = 0;
                nArray3[2] = 1;
                nArray = nArray3;
                nArray3[3] = 2;
            }
            int[] quaternionIndex = nArray;
            Rotation rotation = new Rotation(data[quaternionIndex[0]], data[quaternionIndex[1]], data[quaternionIndex[2]], data[quaternionIndex[3]], false);
            return new TimeStampedAngularCoordinates(date, rotation, Vector3D.ZERO, Vector3D.ZERO);
        }

        @Override
        public AngularDerivativesFilter getAngularDerivativesFilter() {
            return AngularDerivativesFilter.USE_R;
        }
    }
    ,
    QUATERNION_DERIVATIVE("QUATERNION DERIVATIVE"){

        @Override
        public double[] getAttitudeData(TimeStampedAngularCoordinates coordinates, boolean isFirst, RotationOrder order) {
            int[] nArray;
            double[] data = new double[8];
            FieldRotation<UnivariateDerivative1> fieldRotation = coordinates.toUnivariateDerivative1Rotation();
            double q0 = ((UnivariateDerivative1)fieldRotation.getQ0()).getValue();
            double q1 = ((UnivariateDerivative1)fieldRotation.getQ1()).getValue();
            double q2 = ((UnivariateDerivative1)fieldRotation.getQ2()).getValue();
            double q3 = ((UnivariateDerivative1)fieldRotation.getQ3()).getValue();
            double q0Dot = ((UnivariateDerivative1)fieldRotation.getQ0()).getFirstDerivative();
            double q1Dot = ((UnivariateDerivative1)fieldRotation.getQ1()).getFirstDerivative();
            double q2Dot = ((UnivariateDerivative1)fieldRotation.getQ2()).getFirstDerivative();
            double q3Dot = ((UnivariateDerivative1)fieldRotation.getQ3()).getFirstDerivative();
            if (isFirst) {
                int[] nArray2 = new int[8];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray2[3] = 3;
                nArray2[4] = 4;
                nArray2[5] = 5;
                nArray2[6] = 6;
                nArray = nArray2;
                nArray2[7] = 7;
            } else {
                int[] nArray3 = new int[8];
                nArray3[0] = 3;
                nArray3[1] = 0;
                nArray3[2] = 1;
                nArray3[3] = 2;
                nArray3[4] = 7;
                nArray3[5] = 4;
                nArray3[6] = 5;
                nArray = nArray3;
                nArray3[7] = 6;
            }
            int[] quaternionIndex = nArray;
            data[quaternionIndex[0]] = q0;
            data[quaternionIndex[1]] = q1;
            data[quaternionIndex[2]] = q2;
            data[quaternionIndex[3]] = q3;
            data[quaternionIndex[4]] = q0Dot;
            data[quaternionIndex[5]] = q1Dot;
            data[quaternionIndex[6]] = q2Dot;
            data[quaternionIndex[7]] = q3Dot;
            return data;
        }

        @Override
        public TimeStampedAngularCoordinates getAngularCoordinates(AbsoluteDate date, double[] data, boolean isFirst, RotationOrder order) {
            int[] nArray;
            if (isFirst) {
                int[] nArray2 = new int[8];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray2[3] = 3;
                nArray2[4] = 4;
                nArray2[5] = 5;
                nArray2[6] = 6;
                nArray = nArray2;
                nArray2[7] = 7;
            } else {
                int[] nArray3 = new int[8];
                nArray3[0] = 3;
                nArray3[1] = 0;
                nArray3[2] = 1;
                nArray3[3] = 2;
                nArray3[4] = 7;
                nArray3[5] = 4;
                nArray3[6] = 5;
                nArray = nArray3;
                nArray3[7] = 6;
            }
            int[] quaternionIndex = nArray;
            DSFactory factory = new DSFactory(1, 1);
            DerivativeStructure q0DS = factory.build(new double[]{data[quaternionIndex[0]], data[quaternionIndex[4]]});
            DerivativeStructure q1DS = factory.build(new double[]{data[quaternionIndex[1]], data[quaternionIndex[5]]});
            DerivativeStructure q2DS = factory.build(new double[]{data[quaternionIndex[2]], data[quaternionIndex[6]]});
            DerivativeStructure q3DS = factory.build(new double[]{data[quaternionIndex[3]], data[quaternionIndex[7]]});
            FieldRotation fieldRotation = new FieldRotation((RealFieldElement)q0DS, (RealFieldElement)q1DS, (RealFieldElement)q2DS, (RealFieldElement)q3DS, false);
            return new TimeStampedAngularCoordinates(date, (FieldRotation<DerivativeStructure>)fieldRotation);
        }

        @Override
        public AngularDerivativesFilter getAngularDerivativesFilter() {
            return AngularDerivativesFilter.USE_RR;
        }
    }
    ,
    QUATERNION_RATE("QUATERNION RATE"){

        @Override
        public double[] getAttitudeData(TimeStampedAngularCoordinates coordinates, boolean isFirst, RotationOrder order) {
            int[] nArray;
            double[] data = new double[7];
            if (isFirst) {
                int[] nArray2 = new int[4];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray = nArray2;
                nArray2[3] = 3;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = 3;
                nArray3[1] = 0;
                nArray3[2] = 1;
                nArray = nArray3;
                nArray3[3] = 2;
            }
            int[] quaternionIndex = nArray;
            Rotation rotation = coordinates.getRotation();
            Vector3D rotationRate = coordinates.getRotationRate();
            data[quaternionIndex[0]] = rotation.getQ0();
            data[quaternionIndex[1]] = rotation.getQ1();
            data[quaternionIndex[2]] = rotation.getQ2();
            data[quaternionIndex[3]] = rotation.getQ3();
            data[4] = FastMath.toDegrees((double)rotationRate.getX());
            data[5] = FastMath.toDegrees((double)rotationRate.getY());
            data[6] = FastMath.toDegrees((double)rotationRate.getZ());
            return data;
        }

        @Override
        public TimeStampedAngularCoordinates getAngularCoordinates(AbsoluteDate date, double[] data, boolean isFirst, RotationOrder order) {
            int[] nArray;
            if (isFirst) {
                int[] nArray2 = new int[4];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray = nArray2;
                nArray2[3] = 3;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = 3;
                nArray3[1] = 0;
                nArray3[2] = 1;
                nArray = nArray3;
                nArray3[3] = 2;
            }
            int[] quaternionIndex = nArray;
            double q0 = data[quaternionIndex[0]];
            double q1 = data[quaternionIndex[1]];
            double q2 = data[quaternionIndex[2]];
            double q3 = data[quaternionIndex[3]];
            double xRate = FastMath.toRadians((double)data[4]);
            double yRate = FastMath.toRadians((double)data[5]);
            double zRate = FastMath.toRadians((double)data[6]);
            Rotation rotation = new Rotation(q0, q1, q2, q3, false);
            Vector3D rotationRate = new Vector3D(xRate, yRate, zRate);
            return new TimeStampedAngularCoordinates(date, rotation, rotationRate, Vector3D.ZERO);
        }

        @Override
        public AngularDerivativesFilter getAngularDerivativesFilter() {
            return AngularDerivativesFilter.USE_RR;
        }
    }
    ,
    EULER_ANGLE("EULER ANGLE"){

        @Override
        public double[] getAttitudeData(TimeStampedAngularCoordinates coordinates, boolean isFirst, RotationOrder order) {
            double[] data = new double[3];
            Rotation rotation = coordinates.getRotation();
            double[] angles = rotation.getAngles(order, RotationConvention.FRAME_TRANSFORM);
            data[0] = FastMath.toDegrees((double)angles[0]);
            data[1] = FastMath.toDegrees((double)angles[1]);
            data[2] = FastMath.toDegrees((double)angles[2]);
            return data;
        }

        @Override
        public TimeStampedAngularCoordinates getAngularCoordinates(AbsoluteDate date, double[] data, boolean isFirst, RotationOrder order) {
            double alpha1 = FastMath.toRadians((double)data[0]);
            double alpha2 = FastMath.toRadians((double)data[1]);
            double alpha3 = FastMath.toRadians((double)data[2]);
            Rotation rotation = new Rotation(order, RotationConvention.FRAME_TRANSFORM, alpha1, alpha2, alpha3);
            return new TimeStampedAngularCoordinates(date, rotation, Vector3D.ZERO, Vector3D.ZERO);
        }

        @Override
        public AngularDerivativesFilter getAngularDerivativesFilter() {
            return AngularDerivativesFilter.USE_R;
        }
    }
    ,
    EULER_ANGLE_RATE("EULER ANGLE RATE"){

        @Override
        public double[] getAttitudeData(TimeStampedAngularCoordinates coordinates, boolean isFirst, RotationOrder order) {
            double[] data = new double[6];
            Rotation rotation = coordinates.getRotation();
            Vector3D rotationRate = coordinates.getRotationRate();
            double[] angles = rotation.getAngles(order, RotationConvention.FRAME_TRANSFORM);
            data[0] = FastMath.toDegrees((double)angles[0]);
            data[1] = FastMath.toDegrees((double)angles[1]);
            data[2] = FastMath.toDegrees((double)angles[2]);
            data[3] = FastMath.toDegrees((double)rotationRate.getX());
            data[4] = FastMath.toDegrees((double)rotationRate.getY());
            data[5] = FastMath.toDegrees((double)rotationRate.getZ());
            return data;
        }

        @Override
        public TimeStampedAngularCoordinates getAngularCoordinates(AbsoluteDate date, double[] data, boolean isFirst, RotationOrder order) {
            double alpha1 = FastMath.toRadians((double)data[0]);
            double alpha2 = FastMath.toRadians((double)data[1]);
            double alpha3 = FastMath.toRadians((double)data[2]);
            double xRate = FastMath.toRadians((double)data[3]);
            double yRate = FastMath.toRadians((double)data[4]);
            double zRate = FastMath.toRadians((double)data[5]);
            Rotation rotation = new Rotation(order, RotationConvention.FRAME_TRANSFORM, alpha1, alpha2, alpha3);
            Vector3D rotationRate = new Vector3D(xRate, yRate, zRate);
            return new TimeStampedAngularCoordinates(date, rotation, rotationRate, Vector3D.ZERO);
        }

        @Override
        public AngularDerivativesFilter getAngularDerivativesFilter() {
            return AngularDerivativesFilter.USE_RR;
        }
    }
    ,
    SPIN("SPIN"){

        @Override
        public double[] getAttitudeData(TimeStampedAngularCoordinates coordinates, boolean isFirst, RotationOrder order) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_AEM_ATTITUDE_TYPE_NOT_IMPLEMENTED, this.getName());
        }

        @Override
        public TimeStampedAngularCoordinates getAngularCoordinates(AbsoluteDate date, double[] data, boolean isFirst, RotationOrder order) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_AEM_ATTITUDE_TYPE_NOT_IMPLEMENTED, this.getName());
        }

        @Override
        public AngularDerivativesFilter getAngularDerivativesFilter() {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_AEM_ATTITUDE_TYPE_NOT_IMPLEMENTED, this.getName());
        }
    }
    ,
    SPIN_NUTATION("SPIN NUTATION"){

        @Override
        public double[] getAttitudeData(TimeStampedAngularCoordinates coordinates, boolean isFirst, RotationOrder order) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_AEM_ATTITUDE_TYPE_NOT_IMPLEMENTED, this.getName());
        }

        @Override
        public TimeStampedAngularCoordinates getAngularCoordinates(AbsoluteDate date, double[] data, boolean isFirst, RotationOrder order) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_AEM_ATTITUDE_TYPE_NOT_IMPLEMENTED, this.getName());
        }

        @Override
        public AngularDerivativesFilter getAngularDerivativesFilter() {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_AEM_ATTITUDE_TYPE_NOT_IMPLEMENTED, this.getName());
        }
    };

    private static final Map<String, AEMAttitudeType> CODES_MAP;
    private final String name;

    private AEMAttitudeType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static AEMAttitudeType getAttitudeType(String name) {
        AEMAttitudeType type = CODES_MAP.get(name);
        if (type == null) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_AEM_NULL_ATTITUDE_TYPE, name);
        }
        return type;
    }

    public abstract double[] getAttitudeData(TimeStampedAngularCoordinates var1, boolean var2, RotationOrder var3);

    public abstract TimeStampedAngularCoordinates getAngularCoordinates(AbsoluteDate var1, double[] var2, boolean var3, RotationOrder var4);

    public abstract AngularDerivativesFilter getAngularDerivativesFilter();

    static {
        CODES_MAP = new HashMap<String, AEMAttitudeType>();
        for (AEMAttitudeType type : AEMAttitudeType.values()) {
            CODES_MAP.put(type.getName(), type);
        }
    }
}

