/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.errors;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.OpenIntToDoubleHashMap;
import org.hipparchus.util.Pair;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.frames.Predefined;
import org.orekit.frames.Transform;
import org.orekit.rugged.api.AlgorithmId;
import org.orekit.rugged.api.Rugged;
import org.orekit.rugged.api.RuggedBuilder;
import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedInternalError;
import org.orekit.rugged.errors.RuggedMessages;
import org.orekit.rugged.linesensor.LineDatation;
import org.orekit.rugged.linesensor.LineSensor;
import org.orekit.rugged.linesensor.SensorMeanPlaneCrossing;
import org.orekit.rugged.linesensor.SensorPixel;
import org.orekit.rugged.los.TimeDependentLOS;
import org.orekit.rugged.raster.TileUpdater;
import org.orekit.rugged.raster.UpdatableTile;
import org.orekit.rugged.refraction.MultiLayerModel;
import org.orekit.rugged.utils.DerivativeGenerator;
import org.orekit.rugged.utils.ExtendedEllipsoid;
import org.orekit.rugged.utils.SpacecraftToObservedBody;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.utils.ParameterDriver;

public class DumpReplayer {
    private static final String COMMENT_START = "#";
    private static final String LATITUDE = "latitude";
    private static final String LONGITUDE = "longitude";
    private static final String ELEVATION = "elevation";
    private static final String AE = "ae";
    private static final String F = "f";
    private static final String FRAME = "frame";
    private static final String DATE = "date";
    private static final String POSITION = "position";
    private static final String LOS = "los";
    private static final String LIGHT_TIME = "lightTime";
    private static final String ABERRATION = "aberration";
    private static final String REFRACTION = "refraction";
    private static final String MIN_DATE = "minDate";
    private static final String MAX_DATE = "maxDate";
    private static final String T_STEP = "tStep";
    private static final String TOLERANCE = "tolerance";
    private static final String INERTIAL_FRAME = "inertialFrame";
    private static final String INDEX = "index";
    private static final String BODY = "body";
    private static final String R = "r";
    private static final String OMEGA = "\u03a9";
    private static final String OMEGA_DOT = "\u03a9Dot";
    private static final String SPACECRAFT = "spacecraft";
    private static final String P = "p";
    private static final String V = "v";
    private static final String A = "a";
    private static final String LAT_MIN = "latMin";
    private static final String LAT_STEP = "latStep";
    private static final String LAT_ROWS = "latRows";
    private static final String LON_MIN = "lonMin";
    private static final String LON_STEP = "lonStep";
    private static final String LON_COLS = "lonCols";
    private static final String LAT_INDEX = "latIndex";
    private static final String LON_INDEX = "lonIndex";
    private static final String SENSOR_NAME = "sensorName";
    private static final String MIN_LINE = "minLine";
    private static final String MAX_LINE = "maxLine";
    private static final String LINE_NUMBER = "lineNumber";
    private static final String NB_PIXELS = "nbPixels";
    private static final String PIXEL_NUMBER = "pixelNumber";
    private static final String MAX_EVAL = "maxEval";
    private static final String ACCURACY = "accuracy";
    private static final String NORMAL = "normal";
    private static final String RATE = "rate";
    private static final String CACHED_RESULTS = "cachedResults";
    private static final String TARGET = "target";
    private static final String TARGET_DIRECTION = "targetDirection";
    private static final String NULL_RESULT = "NULL";
    private static final Pattern SEPARATOR = Pattern.compile("\\s+");
    private static final Pattern PATTERN = Pattern.compile(" ");
    private double constantElevation;
    private AlgorithmId algorithmId;
    private OneAxisEllipsoid ellipsoid;
    private final List<ParsedTile> tiles = new ArrayList<ParsedTile>();
    private final List<ParsedSensor> sensors = new ArrayList<ParsedSensor>();
    private AbsoluteDate minDate;
    private AbsoluteDate maxDate;
    private double tStep;
    private double tolerance;
    private Frame inertialFrame;
    private NavigableMap<Integer, Transform> bodyToInertial;
    private NavigableMap<Integer, Transform> scToInertial;
    private boolean lightTimeCorrection;
    private boolean aberrationOfLightCorrection;
    private boolean atmosphericRefraction;
    private final List<DumpedCall> calls = new ArrayList<DumpedCall>();

    public void parse(File file) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            int l = 0;
            String line = reader.readLine();
            while (line != null) {
                LineParser.parse(++l, file, line, this);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException ioe) {
            throw new RuggedException(ioe, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, ioe.getLocalizedMessage());
        }
    }

    public Rugged createRugged() {
        try {
            RuggedBuilder builder = new RuggedBuilder();
            if (this.algorithmId == null) {
                this.algorithmId = AlgorithmId.IGNORE_DEM_USE_ELLIPSOID;
            }
            builder.setAlgorithm(this.algorithmId);
            if (this.algorithmId == AlgorithmId.CONSTANT_ELEVATION_OVER_ELLIPSOID) {
                builder.setConstantElevation(this.constantElevation);
            } else if (this.algorithmId != AlgorithmId.IGNORE_DEM_USE_ELLIPSOID) {
                builder.setDigitalElevationModel(new TileUpdater(){

                    @Override
                    public void updateTile(double latitude, double longitude, UpdatableTile tile) {
                        for (ParsedTile parsedTile : DumpReplayer.this.tiles) {
                            if (!parsedTile.isInterpolable(latitude, longitude)) continue;
                            parsedTile.updateTile(tile);
                            return;
                        }
                        throw new RuggedException(RuggedMessages.NO_DEM_DATA, FastMath.toDegrees((double)latitude), FastMath.toDegrees((double)longitude));
                    }
                }, 8);
            }
            builder.setEllipsoid(this.ellipsoid);
            builder.setLightTimeCorrection(this.lightTimeCorrection);
            builder.setAberrationOfLightCorrection(this.aberrationOfLightCorrection);
            if (this.atmosphericRefraction) {
                ExtendedEllipsoid extendedEllipsoid = builder.getEllipsoid();
                MultiLayerModel atmosphericModel = new MultiLayerModel(extendedEllipsoid);
                builder.setRefractionCorrection(atmosphericModel);
            }
            int n = (int)FastMath.ceil((double)(this.maxDate.durationFrom(this.minDate) / this.tStep));
            ArrayList<Transform> b2iList = new ArrayList<Transform>(n);
            ArrayList<Transform> s2iList = new ArrayList<Transform>(n);
            for (int i = 0; i < n; ++i) {
                if (this.bodyToInertial.containsKey(i)) {
                    b2iList.add((Transform)this.bodyToInertial.get(i));
                    s2iList.add((Transform)this.scToInertial.get(i));
                    continue;
                }
                Map.Entry<Integer, Transform> lower = this.bodyToInertial.lowerEntry(i);
                Map.Entry<Integer, Transform> higher = this.bodyToInertial.higherEntry(i);
                int closest = lower == null ? higher.getKey() : (higher == null ? lower.getKey() : (i - lower.getKey() <= higher.getKey() - i ? lower.getKey().intValue() : higher.getKey().intValue()));
                b2iList.add(((Transform)this.bodyToInertial.get(closest)).shiftedBy((double)(i - closest) * this.tStep));
                s2iList.add(((Transform)this.scToInertial.get(closest)).shiftedBy((double)(i - closest) * this.tStep));
            }
            SpacecraftToObservedBody scToBody = new SpacecraftToObservedBody(this.inertialFrame, this.ellipsoid.getBodyFrame(), this.minDate, this.maxDate, this.tStep, this.tolerance, b2iList, s2iList);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            new ObjectOutputStream(bos).writeObject(scToBody);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            builder.setTrajectoryAndTimeSpan(bis);
            ArrayList<SensorMeanPlaneCrossing> planeCrossings = new ArrayList<SensorMeanPlaneCrossing>();
            for (ParsedSensor parsedSensor : this.sensors) {
                LineSensor sensor = new LineSensor(parsedSensor.name, parsedSensor, parsedSensor.position, parsedSensor);
                if (parsedSensor.meanPlane != null) {
                    planeCrossings.add(new SensorMeanPlaneCrossing(sensor, scToBody, parsedSensor.meanPlane.minLine, parsedSensor.meanPlane.maxLine, this.lightTimeCorrection, this.aberrationOfLightCorrection, parsedSensor.meanPlane.maxEval, parsedSensor.meanPlane.accuracy, parsedSensor.meanPlane.normal, Arrays.stream(parsedSensor.meanPlane.cachedResults)));
                }
                builder.addLineSensor(sensor);
            }
            Rugged rugged = builder.build();
            Method setPlaneCrossing = Rugged.class.getDeclaredMethod("setPlaneCrossing", SensorMeanPlaneCrossing.class);
            setPlaneCrossing.setAccessible(true);
            for (SensorMeanPlaneCrossing planeCrossing : planeCrossings) {
                setPlaneCrossing.invoke((Object)rugged, planeCrossing);
            }
            return rugged;
        }
        catch (IOException ioe) {
            throw new RuggedException(ioe, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, ioe.getLocalizedMessage());
        }
        catch (SecurityException e) {
            throw new RuggedInternalError(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuggedInternalError(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuggedInternalError(e);
        }
        catch (IllegalAccessException e) {
            throw new RuggedInternalError(e);
        }
        catch (InvocationTargetException e) {
            throw new RuggedInternalError(e);
        }
    }

    private ParsedSensor getSensor(String name) {
        for (ParsedSensor sensor : this.sensors) {
            if (!sensor.name.equals(name)) continue;
            return sensor;
        }
        ParsedSensor sensor = new ParsedSensor(name);
        this.sensors.add(sensor);
        return sensor;
    }

    public Result[] execute(Rugged rugged) {
        Result[] results = new Result[this.calls.size()];
        for (int i = 0; i < this.calls.size(); ++i) {
            results[i] = new Result(this.calls.get(i).expected, this.calls.get(i).execute(rugged));
        }
        return results;
    }

    private static abstract class DumpedCall {
        private Object expected;

        private DumpedCall() {
        }

        public abstract Object execute(Rugged var1);
    }

    private static class ParsedMeanPlane {
        private final int minLine;
        private final int maxLine;
        private final int maxEval;
        private final double accuracy;
        private final Vector3D normal;
        private final SensorMeanPlaneCrossing.CrossingResult[] cachedResults;

        ParsedMeanPlane(int minLine, int maxLine, int maxEval, double accuracy, Vector3D normal, SensorMeanPlaneCrossing.CrossingResult[] cachedResults) {
            this.minLine = minLine;
            this.maxLine = maxLine;
            this.maxEval = maxEval;
            this.accuracy = accuracy;
            this.normal = normal;
            this.cachedResults = (SensorMeanPlaneCrossing.CrossingResult[])cachedResults.clone();
        }
    }

    private static class ParsedSensor
    implements LineDatation,
    TimeDependentLOS {
        private final String name;
        private int nbPixels;
        private Vector3D position;
        private ParsedMeanPlane meanPlane;
        private final Map<Integer, List<Pair<AbsoluteDate, Vector3D>>> losMap;
        private final List<Pair<Double, AbsoluteDate>> datation;
        private final List<Pair<Double, Double>> rates;

        ParsedSensor(String name) {
            this.name = name;
            this.losMap = new HashMap<Integer, List<Pair<AbsoluteDate, Vector3D>>>();
            this.datation = new ArrayList<Pair<Double, AbsoluteDate>>();
            this.rates = new ArrayList<Pair<Double, Double>>();
        }

        public void setMeanPlane(ParsedMeanPlane meanPlane) {
            this.meanPlane = meanPlane;
        }

        public void setPosition(Vector3D position) {
            this.position = position;
        }

        public void setNbPixels(int nbPixels) {
            this.nbPixels = nbPixels;
        }

        @Override
        public int getNbPixels() {
            return this.nbPixels;
        }

        public void setLOS(AbsoluteDate date, int pixelNumber, Vector3D los) {
            int index;
            List<Pair<AbsoluteDate, Vector3D>> list = this.losMap.get(pixelNumber);
            if (list == null) {
                list = new ArrayList<Pair<AbsoluteDate, Vector3D>>();
                this.losMap.put(pixelNumber, list);
            }
            for (index = 0; index < list.size() && ((AbsoluteDate)list.get(index).getFirst()).compareTo(date) <= 0; ++index) {
            }
            list.add(index, (Pair<AbsoluteDate, Vector3D>)new Pair((Object)date, (Object)los));
        }

        @Override
        public Vector3D getLOS(int index, AbsoluteDate date) {
            int sup;
            List<Pair<AbsoluteDate, Vector3D>> list = this.losMap.get(index);
            if (list == null) {
                throw new RuggedInternalError(null);
            }
            if (list.size() < 2) {
                return (Vector3D)list.get(0).getSecond();
            }
            for (sup = 0; sup < list.size() - 1 && ((AbsoluteDate)list.get(sup).getFirst()).compareTo(date) < 0; ++sup) {
            }
            int inf = sup == 0 ? sup++ : sup - 1;
            AbsoluteDate dInf = (AbsoluteDate)list.get(inf).getFirst();
            Vector3D lInf = (Vector3D)list.get(inf).getSecond();
            AbsoluteDate dSup = (AbsoluteDate)list.get(sup).getFirst();
            Vector3D lSup = (Vector3D)list.get(sup).getSecond();
            double alpha = date.durationFrom(dInf) / dSup.durationFrom(dInf);
            return new Vector3D(alpha, lSup, 1.0 - alpha, lInf);
        }

        @Override
        public <T extends Derivative<T>> FieldVector3D<T> getLOSDerivatives(int index, AbsoluteDate date, DerivativeGenerator<T> generator) {
            Vector3D los = this.getLOS(index, date);
            return new FieldVector3D(generator.constant(los.getX()), generator.constant(los.getY()), generator.constant(los.getZ()));
        }

        public void setDatation(double lineNumber, AbsoluteDate date) {
            int index;
            for (index = 0; index < this.datation.size() && ((AbsoluteDate)this.datation.get(index).getSecond()).compareTo(date) <= 0; ++index) {
            }
            this.datation.add(index, (Pair<Double, AbsoluteDate>)new Pair((Object)lineNumber, (Object)date));
        }

        @Override
        public AbsoluteDate getDate(double lineNumber) {
            int sup;
            if (this.datation.size() < 2) {
                return (AbsoluteDate)this.datation.get(0).getSecond();
            }
            for (sup = 0; sup < this.datation.size() - 1 && !((Double)this.datation.get(sup).getFirst() >= lineNumber); ++sup) {
            }
            int inf = sup == 0 ? sup++ : sup - 1;
            double lInf = (Double)this.datation.get(inf).getFirst();
            AbsoluteDate dInf = (AbsoluteDate)this.datation.get(inf).getSecond();
            double lSup = (Double)this.datation.get(sup).getFirst();
            AbsoluteDate dSup = (AbsoluteDate)this.datation.get(sup).getSecond();
            double alpha = (lineNumber - lInf) / (lSup - lInf);
            return dInf.shiftedBy(alpha * dSup.durationFrom(dInf));
        }

        @Override
        public double getLine(AbsoluteDate date) {
            int sup;
            if (this.datation.size() < 2) {
                return (Double)this.datation.get(0).getFirst();
            }
            for (sup = 0; sup < this.datation.size() - 1 && ((AbsoluteDate)this.datation.get(sup).getSecond()).compareTo(date) < 0; ++sup) {
            }
            int inf = sup == 0 ? sup++ : sup - 1;
            double lInf = (Double)this.datation.get(inf).getFirst();
            AbsoluteDate dInf = (AbsoluteDate)this.datation.get(inf).getSecond();
            double lSup = (Double)this.datation.get(sup).getFirst();
            AbsoluteDate dSup = (AbsoluteDate)this.datation.get(sup).getSecond();
            double alpha = date.durationFrom(dInf) / dSup.durationFrom(dInf);
            return alpha * lSup + (1.0 - alpha) * lInf;
        }

        public void setRate(double lineNumber, double rate) {
            int index;
            for (index = 0; index < this.rates.size() && !((Double)this.rates.get(index).getFirst() > lineNumber); ++index) {
            }
            this.rates.add(index, (Pair<Double, Double>)new Pair((Object)lineNumber, (Object)rate));
        }

        @Override
        public double getRate(double lineNumber) {
            int sup;
            if (this.rates.size() < 2) {
                return (Double)this.rates.get(0).getSecond();
            }
            for (sup = 0; sup < this.rates.size() - 1 && !((Double)this.rates.get(sup).getFirst() >= lineNumber); ++sup) {
            }
            int inf = sup == 0 ? sup++ : sup - 1;
            double lInf = (Double)this.rates.get(inf).getFirst();
            double rInf = (Double)this.rates.get(inf).getSecond();
            double lSup = (Double)this.rates.get(sup).getFirst();
            double rSup = (Double)this.rates.get(sup).getSecond();
            double alpha = (lineNumber - lInf) / (lSup - lInf);
            return alpha * rSup + (1.0 - alpha) * rInf;
        }

        @Override
        public Stream<ParameterDriver> getParametersDrivers() {
            return Stream.empty();
        }
    }

    private static class ParsedTile {
        private final String name;
        private final double minLatitude;
        private final double latitudeStep;
        private int latitudeRows;
        private final double minLongitude;
        private final double longitudeStep;
        private int longitudeColumns;
        private final OpenIntToDoubleHashMap elevations;

        ParsedTile(String name, double minLatitude, double latitudeStep, int latitudeRows, double minLongitude, double longitudeStep, int longitudeColumns) {
            this.name = name;
            this.minLatitude = minLatitude;
            this.latitudeStep = latitudeStep;
            this.minLongitude = minLongitude;
            this.longitudeStep = longitudeStep;
            this.latitudeRows = latitudeRows;
            this.longitudeColumns = longitudeColumns;
            this.elevations = new OpenIntToDoubleHashMap();
        }

        public boolean isInterpolable(double latitude, double longitude) {
            int latitudeIndex = (int)FastMath.floor((double)((latitude - this.minLatitude) / this.latitudeStep));
            int longitudeIndex = (int)FastMath.floor((double)((longitude - this.minLongitude) / this.longitudeStep));
            return latitudeIndex >= 0 && latitudeIndex <= this.latitudeRows - 2 && longitudeIndex >= 0 && longitudeIndex <= this.longitudeColumns - 2;
        }

        public void updateTile(UpdatableTile tile) {
            tile.setGeometry(this.minLatitude, this.minLongitude, this.latitudeStep, this.longitudeStep, this.latitudeRows, this.longitudeColumns);
            OpenIntToDoubleHashMap.Iterator iterator = this.elevations.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                int index = iterator.key();
                int latitudeIndex = index / this.longitudeColumns;
                int longitudeIndex = index % this.longitudeColumns;
                double elevation = iterator.value();
                tile.setElevation(latitudeIndex, longitudeIndex, elevation);
            }
        }
    }

    private static enum LineParser {
        ALGORITHM{

            @Override
            public void parse(int l, File file, String line, String[] fields, DumpReplayer global) {
                try {
                    if (fields.length < 1) {
                        throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                    }
                    global.algorithmId = AlgorithmId.valueOf(fields[0]);
                    if (global.algorithmId == AlgorithmId.CONSTANT_ELEVATION_OVER_ELLIPSOID) {
                        if (fields.length < 3 || !fields[1].equals(DumpReplayer.ELEVATION)) {
                            throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                        }
                        global.constantElevation = Double.parseDouble(fields[2]);
                    }
                }
                catch (IllegalArgumentException iae) {
                    throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                }
            }
        }
        ,
        ELLIPSOID{

            @Override
            public void parse(int l, File file, String line, String[] fields, DumpReplayer global) {
                Frame bodyFrame;
                if (!(fields.length >= 6 && fields[0].equals(DumpReplayer.AE) && fields[2].equals(DumpReplayer.F) && fields[4].equals(DumpReplayer.FRAME))) {
                    throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                }
                double ae = Double.parseDouble(fields[1]);
                double f = Double.parseDouble(fields[3]);
                try {
                    bodyFrame = FramesFactory.getFrame((Predefined)Predefined.valueOf((String)fields[5]));
                }
                catch (IllegalArgumentException iae) {
                    throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                }
                global.ellipsoid = new OneAxisEllipsoid(ae, f, bodyFrame);
            }
        }
        ,
        DIRECT_LOCATION{

            @Override
            public void parse(int l, File file, String line, String[] fields, DumpReplayer global) {
                if (!(fields.length >= 16 && fields[0].equals(DumpReplayer.DATE) && fields[2].equals(DumpReplayer.POSITION) && fields[6].equals(DumpReplayer.LOS) && fields[10].equals(DumpReplayer.LIGHT_TIME) && fields[12].equals(DumpReplayer.ABERRATION) && fields[14].equals(DumpReplayer.REFRACTION))) {
                    throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                }
                final AbsoluteDate date = new AbsoluteDate(fields[1], (TimeScale)TimeScalesFactory.getUTC());
                final Vector3D position = new Vector3D(Double.parseDouble(fields[3]), Double.parseDouble(fields[4]), Double.parseDouble(fields[5]));
                final Vector3D los = new Vector3D(Double.parseDouble(fields[7]), Double.parseDouble(fields[8]), Double.parseDouble(fields[9]));
                if (global.calls.isEmpty()) {
                    global.lightTimeCorrection = Boolean.parseBoolean(fields[11]);
                    global.aberrationOfLightCorrection = Boolean.parseBoolean(fields[13]);
                    global.atmosphericRefraction = Boolean.parseBoolean(fields[15]);
                } else {
                    if (global.lightTimeCorrection != Boolean.parseBoolean(fields[11])) {
                        throw new RuggedException(RuggedMessages.LIGHT_TIME_CORRECTION_REDEFINED, l, file.getAbsolutePath(), line);
                    }
                    if (global.aberrationOfLightCorrection != Boolean.parseBoolean(fields[13])) {
                        throw new RuggedException(RuggedMessages.ABERRATION_OF_LIGHT_CORRECTION_REDEFINED, l, file.getAbsolutePath(), line);
                    }
                    if (global.atmosphericRefraction != Boolean.parseBoolean(fields[15])) {
                        throw new RuggedException(RuggedMessages.ATMOSPHERIC_REFRACTION_REDEFINED, l, file.getAbsolutePath(), line);
                    }
                }
                global.calls.add(new DumpedCall(){

                    @Override
                    public Object execute(Rugged rugged) {
                        return rugged.directLocation(date, position, los);
                    }
                });
            }
        }
        ,
        DIRECT_LOCATION_RESULT{

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void parse(int l, File file, String line, String[] fields, DumpReplayer global) {
                if (fields.length == 1) {
                    if (!fields[0].equals(DumpReplayer.NULL_RESULT)) throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                    Object gp = null;
                    DumpedCall last = (DumpedCall)global.calls.get(global.calls.size() - 1);
                    last.expected = gp;
                    return;
                } else {
                    if (!(fields.length >= 6 && fields[0].equals(DumpReplayer.LATITUDE) && fields[2].equals(DumpReplayer.LONGITUDE) && fields[4].equals(DumpReplayer.ELEVATION))) {
                        throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                    }
                    GeodeticPoint gp = new GeodeticPoint(Double.parseDouble(fields[1]), Double.parseDouble(fields[3]), Double.parseDouble(fields[5]));
                    DumpedCall last = (DumpedCall)global.calls.get(global.calls.size() - 1);
                    last.expected = gp;
                }
            }
        }
        ,
        SPAN{

            @Override
            public void parse(int l, File file, String line, String[] fields, DumpReplayer global) {
                if (!(fields.length >= 10 && fields[0].equals(DumpReplayer.MIN_DATE) && fields[2].equals(DumpReplayer.MAX_DATE) && fields[4].equals(DumpReplayer.T_STEP) && fields[6].equals(DumpReplayer.TOLERANCE) && fields[8].equals(DumpReplayer.INERTIAL_FRAME))) {
                    throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                }
                global.minDate = new AbsoluteDate(fields[1], (TimeScale)TimeScalesFactory.getUTC());
                global.maxDate = new AbsoluteDate(fields[3], (TimeScale)TimeScalesFactory.getUTC());
                global.tStep = Double.parseDouble(fields[5]);
                global.tolerance = Double.parseDouble(fields[7]);
                global.bodyToInertial = new TreeMap();
                global.scToInertial = new TreeMap();
                try {
                    global.inertialFrame = FramesFactory.getFrame((Predefined)Predefined.valueOf((String)fields[9]));
                }
                catch (IllegalArgumentException iae) {
                    throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                }
            }
        }
        ,
        TRANSFORM{

            @Override
            public void parse(int l, File file, String line, String[] fields, DumpReplayer global) {
                if (!(fields.length >= 42 && fields[0].equals(DumpReplayer.INDEX) && fields[2].equals(DumpReplayer.BODY) && fields[3].equals(DumpReplayer.R) && fields[8].equals(DumpReplayer.OMEGA) && fields[12].equals(DumpReplayer.OMEGA_DOT) && fields[16].equals(DumpReplayer.SPACECRAFT) && fields[17].equals(DumpReplayer.P) && fields[21].equals(DumpReplayer.V) && fields[25].equals(DumpReplayer.A) && fields[29].equals(DumpReplayer.R) && fields[34].equals(DumpReplayer.OMEGA) && fields[38].equals(DumpReplayer.OMEGA_DOT))) {
                    throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                }
                int i = Integer.parseInt(fields[1]);
                AbsoluteDate date = global.minDate.shiftedBy((double)i * global.tStep);
                global.bodyToInertial.put(i, new Transform(date, new Rotation(Double.parseDouble(fields[4]), Double.parseDouble(fields[5]), Double.parseDouble(fields[6]), Double.parseDouble(fields[7]), false), new Vector3D(Double.parseDouble(fields[9]), Double.parseDouble(fields[10]), Double.parseDouble(fields[11])), new Vector3D(Double.parseDouble(fields[13]), Double.parseDouble(fields[14]), Double.parseDouble(fields[15]))));
                global.scToInertial.put(i, new Transform(date, new Transform(date, new Vector3D(Double.parseDouble(fields[18]), Double.parseDouble(fields[19]), Double.parseDouble(fields[20])), new Vector3D(Double.parseDouble(fields[22]), Double.parseDouble(fields[23]), Double.parseDouble(fields[24])), new Vector3D(Double.parseDouble(fields[26]), Double.parseDouble(fields[27]), Double.parseDouble(fields[28]))), new Transform(date, new Rotation(Double.parseDouble(fields[30]), Double.parseDouble(fields[31]), Double.parseDouble(fields[32]), Double.parseDouble(fields[33]), false), new Vector3D(Double.parseDouble(fields[35]), Double.parseDouble(fields[36]), Double.parseDouble(fields[37])), new Vector3D(Double.parseDouble(fields[39]), Double.parseDouble(fields[40]), Double.parseDouble(fields[41])))));
            }
        }
        ,
        DEM_TILE{

            @Override
            public void parse(int l, File file, String line, String[] fields, DumpReplayer global) {
                if (!(fields.length >= 13 && fields[1].equals(DumpReplayer.LAT_MIN) && fields[3].equals(DumpReplayer.LAT_STEP) && fields[5].equals(DumpReplayer.LAT_ROWS) && fields[7].equals(DumpReplayer.LON_MIN) && fields[9].equals(DumpReplayer.LON_STEP) && fields[11].equals(DumpReplayer.LON_COLS))) {
                    throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                }
                String name = fields[0];
                double minLatitude = Double.parseDouble(fields[2]);
                double latitudeStep = Double.parseDouble(fields[4]);
                int latitudeRows = Integer.parseInt(fields[6]);
                double minLongitude = Double.parseDouble(fields[8]);
                double longitudeStep = Double.parseDouble(fields[10]);
                int longitudeColumns = Integer.parseInt(fields[12]);
                for (ParsedTile tile : global.tiles) {
                    if (!tile.name.equals(name)) continue;
                    throw new RuggedException(RuggedMessages.TILE_ALREADY_DEFINED, name, l, file.getAbsolutePath(), line);
                }
                global.tiles.add(new ParsedTile(name, minLatitude, latitudeStep, latitudeRows, minLongitude, longitudeStep, longitudeColumns));
            }
        }
        ,
        DEM_CELL{

            @Override
            public void parse(int l, File file, String line, String[] fields, DumpReplayer global) {
                if (!(fields.length >= 7 && fields[1].equals(DumpReplayer.LAT_INDEX) && fields[3].equals(DumpReplayer.LON_INDEX) && fields[5].equals(DumpReplayer.ELEVATION))) {
                    throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                }
                String name = fields[0];
                int latIndex = Integer.parseInt(fields[2]);
                int lonIndex = Integer.parseInt(fields[4]);
                double elevation = Double.parseDouble(fields[6]);
                for (ParsedTile tile : global.tiles) {
                    if (!tile.name.equals(name)) continue;
                    int index = latIndex * tile.longitudeColumns + lonIndex;
                    tile.elevations.put(index, elevation);
                    return;
                }
                throw new RuggedException(RuggedMessages.UNKNOWN_TILE, name, l, file.getAbsolutePath(), line);
            }
        }
        ,
        INVERSE_LOCATION{

            @Override
            public void parse(int l, File file, String line, String[] fields, DumpReplayer global) {
                if (!(fields.length >= 18 && fields[0].equals(DumpReplayer.SENSOR_NAME) && fields[2].equals(DumpReplayer.LATITUDE) && fields[4].equals(DumpReplayer.LONGITUDE) && fields[6].equals(DumpReplayer.ELEVATION) && fields[8].equals(DumpReplayer.MIN_LINE) && fields[10].equals(DumpReplayer.MAX_LINE) && fields[12].equals(DumpReplayer.LIGHT_TIME) && fields[14].equals(DumpReplayer.ABERRATION) && fields[16].equals(DumpReplayer.REFRACTION))) {
                    throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                }
                final String sensorName = fields[1];
                final GeodeticPoint point = new GeodeticPoint(Double.parseDouble(fields[3]), Double.parseDouble(fields[5]), Double.parseDouble(fields[7]));
                final int minLine = Integer.parseInt(fields[9]);
                final int maxLine = Integer.parseInt(fields[11]);
                if (global.calls.isEmpty()) {
                    global.lightTimeCorrection = Boolean.parseBoolean(fields[13]);
                    global.aberrationOfLightCorrection = Boolean.parseBoolean(fields[15]);
                    global.atmosphericRefraction = Boolean.parseBoolean(fields[17]);
                } else {
                    if (global.lightTimeCorrection != Boolean.parseBoolean(fields[13])) {
                        throw new RuggedException(RuggedMessages.LIGHT_TIME_CORRECTION_REDEFINED, l, file.getAbsolutePath(), line);
                    }
                    if (global.aberrationOfLightCorrection != Boolean.parseBoolean(fields[15])) {
                        throw new RuggedException(RuggedMessages.ABERRATION_OF_LIGHT_CORRECTION_REDEFINED, l, file.getAbsolutePath(), line);
                    }
                    if (global.atmosphericRefraction != Boolean.parseBoolean(fields[17])) {
                        throw new RuggedException(RuggedMessages.ATMOSPHERIC_REFRACTION_REDEFINED, l, file.getAbsolutePath(), line);
                    }
                }
                global.calls.add(new DumpedCall(){

                    @Override
                    public Object execute(Rugged rugged) {
                        return rugged.inverseLocation(sensorName, point, minLine, maxLine);
                    }
                });
            }
        }
        ,
        INVERSE_LOCATION_RESULT{

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void parse(int l, File file, String line, String[] fields, DumpReplayer global) {
                if (fields.length == 1) {
                    if (!fields[0].equals(DumpReplayer.NULL_RESULT)) throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                    Object sp = null;
                    DumpedCall last = (DumpedCall)global.calls.get(global.calls.size() - 1);
                    last.expected = sp;
                    return;
                } else {
                    if (fields.length < 4 || !fields[0].equals(DumpReplayer.LINE_NUMBER) || !fields[2].equals(DumpReplayer.PIXEL_NUMBER)) {
                        throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                    }
                    SensorPixel sp = new SensorPixel(Double.parseDouble(fields[1]), Double.parseDouble(fields[3]));
                    DumpedCall last = (DumpedCall)global.calls.get(global.calls.size() - 1);
                    last.expected = sp;
                }
            }
        }
        ,
        SENSOR{

            @Override
            public void parse(int l, File file, String line, String[] fields, DumpReplayer global) {
                if (!(fields.length >= 8 && fields[0].equals(DumpReplayer.SENSOR_NAME) && fields[2].equals(DumpReplayer.NB_PIXELS) && fields[4].equals(DumpReplayer.POSITION))) {
                    throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                }
                ParsedSensor sensor = global.getSensor(fields[1]);
                sensor.setNbPixels(Integer.parseInt(fields[3]));
                sensor.setPosition(new Vector3D(Double.parseDouble(fields[5]), Double.parseDouble(fields[6]), Double.parseDouble(fields[7])));
            }
        }
        ,
        SENSOR_MEAN_PLANE{

            @Override
            public void parse(int l, File file, String line, String[] fields, DumpReplayer global) {
                if (!(fields.length >= 16 && fields[0].equals(DumpReplayer.SENSOR_NAME) && fields[2].equals(DumpReplayer.MIN_LINE) && fields[4].equals(DumpReplayer.MAX_LINE) && fields[6].equals(DumpReplayer.MAX_EVAL) && fields[8].equals(DumpReplayer.ACCURACY) && fields[10].equals(DumpReplayer.NORMAL) && fields[14].equals(DumpReplayer.CACHED_RESULTS))) {
                    throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                }
                String sensorName = fields[1];
                int minLine = Integer.parseInt(fields[3]);
                int maxLine = Integer.parseInt(fields[5]);
                int maxEval = Integer.parseInt(fields[7]);
                double accuracy = Double.parseDouble(fields[9]);
                Vector3D normal = new Vector3D(Double.parseDouble(fields[11]), Double.parseDouble(fields[12]), Double.parseDouble(fields[13]));
                int n = Integer.parseInt(fields[15]);
                SensorMeanPlaneCrossing.CrossingResult[] cachedResults = new SensorMeanPlaneCrossing.CrossingResult[n];
                int base = 16;
                for (int i = 0; i < n; ++i) {
                    if (!(fields.length >= base + 15 && fields[base].equals(DumpReplayer.LINE_NUMBER) && fields[base + 2].equals(DumpReplayer.DATE) && fields[base + 4].equals(DumpReplayer.TARGET) && fields[base + 8].equals(DumpReplayer.TARGET_DIRECTION))) {
                        throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                    }
                    double ln = Double.parseDouble(fields[base + 1]);
                    AbsoluteDate date = new AbsoluteDate(fields[base + 3], (TimeScale)TimeScalesFactory.getUTC());
                    Vector3D target = new Vector3D(Double.parseDouble(fields[base + 5]), Double.parseDouble(fields[base + 6]), Double.parseDouble(fields[base + 7]));
                    Vector3D targetDirection = new Vector3D(Double.parseDouble(fields[base + 9]), Double.parseDouble(fields[base + 10]), Double.parseDouble(fields[base + 11]));
                    Vector3D targetDirectionDerivative = new Vector3D(Double.parseDouble(fields[base + 12]), Double.parseDouble(fields[base + 13]), Double.parseDouble(fields[base + 14]));
                    cachedResults[i] = new SensorMeanPlaneCrossing.CrossingResult(date, ln, target, targetDirection, targetDirectionDerivative);
                    base += 15;
                }
                global.getSensor(sensorName).setMeanPlane(new ParsedMeanPlane(minLine, maxLine, maxEval, accuracy, normal, cachedResults));
            }
        }
        ,
        SENSOR_LOS{

            @Override
            public void parse(int l, File file, String line, String[] fields, DumpReplayer global) {
                if (!(fields.length >= 10 && fields[0].equals(DumpReplayer.SENSOR_NAME) && fields[2].equals(DumpReplayer.DATE) && fields[4].equals(DumpReplayer.PIXEL_NUMBER) && fields[6].equals(DumpReplayer.LOS))) {
                    throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                }
                String sensorName = fields[1];
                AbsoluteDate date = new AbsoluteDate(fields[3], (TimeScale)TimeScalesFactory.getUTC());
                int pixelNumber = Integer.parseInt(fields[5]);
                Vector3D los = new Vector3D(Double.parseDouble(fields[7]), Double.parseDouble(fields[8]), Double.parseDouble(fields[9]));
                global.getSensor(sensorName).setLOS(date, pixelNumber, los);
            }
        }
        ,
        SENSOR_DATATION{

            @Override
            public void parse(int l, File file, String line, String[] fields, DumpReplayer global) {
                if (!(fields.length >= 6 && fields[0].equals(DumpReplayer.SENSOR_NAME) && fields[2].equals(DumpReplayer.LINE_NUMBER) && fields[4].equals(DumpReplayer.DATE))) {
                    throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                }
                String sensorName = fields[1];
                double lineNumber = Double.parseDouble(fields[3]);
                AbsoluteDate date = new AbsoluteDate(fields[5], (TimeScale)TimeScalesFactory.getUTC());
                global.getSensor(sensorName).setDatation(lineNumber, date);
            }
        }
        ,
        SENSOR_RATE{

            @Override
            public void parse(int l, File file, String line, String[] fields, DumpReplayer global) {
                if (!(fields.length >= 6 && fields[0].equals(DumpReplayer.SENSOR_NAME) && fields[2].equals(DumpReplayer.LINE_NUMBER) && fields[4].equals(DumpReplayer.RATE))) {
                    throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                }
                String sensorName = fields[1];
                double lineNumber = Double.parseDouble(fields[3]);
                double rate = Double.parseDouble(fields[5]);
                global.getSensor(sensorName).setRate(lineNumber, rate);
            }
        };


        public static void parse(int l, File file, String line, DumpReplayer global) {
            String trimmed = line.trim();
            if (trimmed.length() == 0 || trimmed.startsWith(DumpReplayer.COMMENT_START)) {
                return;
            }
            int colon = line.indexOf(58);
            if (colon > 0) {
                String parsedKey = PATTERN.matcher(line.substring(0, colon).trim()).replaceAll("_").toUpperCase();
                try {
                    LineParser parser = LineParser.valueOf(parsedKey);
                    String[] fields = colon + 1 >= line.length() ? new String[]{} : SEPARATOR.split(line.substring(colon + 1).trim());
                    parser.parse(l, file, line, fields, global);
                }
                catch (IllegalArgumentException iae) {
                    throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
                }
            } else {
                throw new RuggedException(RuggedMessages.CANNOT_PARSE_LINE, l, file, line);
            }
        }

        public abstract void parse(int var1, File var2, String var3, String[] var4, DumpReplayer var5);
    }

    public static class Result {
        private final Object expected;
        private final Object replayed;

        private Result(Object expected, Object replayed) {
            this.expected = expected;
            this.replayed = replayed;
        }

        public Object getExpected() {
            return this.expected;
        }

        public Object getReplayed() {
            return this.replayed;
        }
    }
}

