/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.attitudes.InertialProvider;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.Range;
import org.orekit.estimation.measurements.modifiers.IonosphericGradientConverter;
import org.orekit.frames.TopocentricFrame;
import org.orekit.models.earth.ionosphere.IonosphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.Differentiation;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterFunction;

public class RangeIonosphericDelayModifier
implements EstimationModifier<Range> {
    private final IonosphericModel ionoModel;
    private final double frequency;

    public RangeIonosphericDelayModifier(IonosphericModel model, double freq) {
        this.ionoModel = model;
        this.frequency = freq;
    }

    private double rangeErrorIonosphericModel(GroundStation station, SpacecraftState state) {
        TopocentricFrame baseFrame = station.getBaseFrame();
        double delay = this.ionoModel.pathDelay(state, baseFrame, this.frequency, this.ionoModel.getParameters());
        return delay;
    }

    private <T extends RealFieldElement<T>> T rangeErrorIonosphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        TopocentricFrame baseFrame = station.getBaseFrame();
        RealFieldElement delay = this.ionoModel.pathDelay(state, baseFrame, this.frequency, (RealFieldElement[])parameters);
        return (T)delay;
    }

    private double[][] rangeErrorJacobianState(double[] derivatives) {
        double[][] finiteDifferencesJacobian = new double[1][6];
        System.arraycopy(derivatives, 0, finiteDifferencesJacobian[0], 0, 6);
        return finiteDifferencesJacobian;
    }

    private double rangeErrorParameterDerivative(final GroundStation station, ParameterDriver driver, final SpacecraftState state, double delay) {
        ParameterFunction rangeError = new ParameterFunction(){

            @Override
            public double value(ParameterDriver parameterDriver) {
                return RangeIonosphericDelayModifier.this.rangeErrorIonosphericModel(station, state);
            }
        };
        ParameterFunction rangeErrorDerivative = Differentiation.differentiate(rangeError, 3, 10.0 * driver.getScale());
        return rangeErrorDerivative.value(driver);
    }

    private double[] rangeErrorParameterDerivative(double[] derivatives, int freeStateParameters) {
        int dim = derivatives.length - freeStateParameters;
        double[] rangeError = new double[dim];
        for (int i = 0; i < dim; ++i) {
            rangeError[i] = derivatives[freeStateParameters + i];
        }
        return rangeError;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.ionoModel.getParametersDrivers();
    }

    @Override
    public void modify(EstimatedMeasurement<Range> estimated) {
        double parameterDerivative;
        Range measurement = estimated.getObservedMeasurement();
        GroundStation station = measurement.getStation();
        SpacecraftState state = estimated.getStates()[0];
        double[] oldValue = estimated.getEstimatedValue();
        IonosphericGradientConverter converter = new IonosphericGradientConverter(state, 6, new InertialProvider(state.getFrame()));
        FieldSpacecraftState<Gradient> gState = converter.getState(this.ionoModel);
        Gradient[] gParameters = converter.getParameters(gState, this.ionoModel);
        Gradient gDelay = (Gradient)this.rangeErrorIonosphericModel(station, gState, (RealFieldElement[])gParameters);
        double[] derivatives = gDelay.getGradient();
        double[][] djac = this.rangeErrorJacobianState(derivatives);
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int irow = 0; irow < stateDerivatives.length; ++irow) {
            for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
                double[] dArray = stateDerivatives[irow];
                int n = jcol;
                dArray[n] = dArray[n] + djac[irow][jcol];
            }
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        int index = 0;
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            double[] dDelaydP = this.rangeErrorParameterDerivative(derivatives, converter.getFreeStateParameters());
            estimated.setParameterDerivatives(driver, parameterDerivative += dDelaydP[index]);
            ++index;
        }
        for (ParameterDriver driver : Arrays.asList(station.getClockOffsetDriver(), station.getEastOffsetDriver(), station.getNorthOffsetDriver(), station.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += this.rangeErrorParameterDerivative(station, driver, state, gDelay.getValue()));
        }
        double[] newValue = (double[])oldValue.clone();
        newValue[0] = newValue[0] + gDelay.getValue();
        estimated.setEstimatedValue(newValue);
    }
}

