/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.gnss.Phase;
import org.orekit.frames.Transform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OnBoardAntennaPhaseModifier
implements EstimationModifier<Phase> {
    private final Vector3D antennaPhaseCenter;

    public OnBoardAntennaPhaseModifier(Vector3D antennaPhaseCenter) {
        this.antennaPhaseCenter = antennaPhaseCenter;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<Phase> estimated) {
        TimeStampedPVCoordinates[] participants = estimated.getParticipants();
        AbsoluteDate emissionDate = participants[0].getDate();
        Vector3D pReception = participants[1].getPosition();
        SpacecraftState refState = estimated.getStates()[0];
        SpacecraftState emissionState = refState.shiftedBy(emissionDate.durationFrom(refState.getDate()));
        Transform spacecraftToInert = emissionState.toTransform().getInverse();
        Vector3D pSpacecraft = spacecraftToInert.transformPosition(Vector3D.ZERO);
        double rangeUsingSpacecraftCenter = Vector3D.distance((Vector3D)pSpacecraft, (Vector3D)pReception);
        Vector3D pAPC = spacecraftToInert.transformPosition(this.antennaPhaseCenter);
        double rangeUsingAntennaPhaseCenter = Vector3D.distance((Vector3D)pAPC, (Vector3D)pReception);
        double[] value = estimated.getEstimatedValue();
        value[0] = value[0] + (rangeUsingAntennaPhaseCenter - rangeUsingSpacecraftCenter) / estimated.getObservedMeasurement().getWavelength();
        estimated.setEstimatedValue(value);
    }
}

