/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class AbstractMeasurement<T extends ObservedMeasurement<T>>
implements ObservedMeasurement<T> {
    private final List<ParameterDriver> supportedParameters = new ArrayList<ParameterDriver>();
    private final List<ObservableSatellite> satellites;
    private final AbsoluteDate date;
    private final double[] observed;
    private final double[] sigma;
    private final double[] baseWeight;
    private final List<EstimationModifier<T>> modifiers;
    private boolean enabled;

    protected AbstractMeasurement(AbsoluteDate date, double observed, double sigma, double baseWeight, List<ObservableSatellite> satellites) {
        this.date = date;
        this.observed = new double[]{observed};
        this.sigma = new double[]{sigma};
        this.baseWeight = new double[]{baseWeight};
        this.satellites = satellites;
        this.modifiers = new ArrayList<EstimationModifier<T>>();
        this.setEnabled(true);
    }

    protected AbstractMeasurement(AbsoluteDate date, double[] observed, double[] sigma, double[] baseWeight, List<ObservableSatellite> satellites) {
        this.date = date;
        this.observed = (double[])observed.clone();
        this.sigma = (double[])sigma.clone();
        this.baseWeight = (double[])baseWeight.clone();
        this.satellites = satellites;
        this.modifiers = new ArrayList<EstimationModifier<T>>();
        this.setEnabled(true);
    }

    protected void addParameterDriver(ParameterDriver driver) {
        this.supportedParameters.add(driver);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.unmodifiableList(this.supportedParameters);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getDimension() {
        return this.observed.length;
    }

    @Override
    public double[] getTheoreticalStandardDeviation() {
        return (double[])this.sigma.clone();
    }

    @Override
    public double[] getBaseWeight() {
        return (double[])this.baseWeight.clone();
    }

    @Override
    public List<ObservableSatellite> getSatellites() {
        return this.satellites;
    }

    protected abstract EstimatedMeasurement<T> theoreticalEvaluation(int var1, int var2, SpacecraftState[] var3);

    @Override
    public EstimatedMeasurement<T> estimate(int iteration, int evaluation, SpacecraftState[] states) {
        EstimatedMeasurement<T> estimation = this.theoreticalEvaluation(iteration, evaluation, states);
        for (EstimationModifier<T> modifier : this.modifiers) {
            modifier.modify(estimation);
        }
        return estimation;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    @Override
    public double[] getObservedValue() {
        return (double[])this.observed.clone();
    }

    @Override
    public void addModifier(EstimationModifier<T> modifier) {
        this.supportedParameters.addAll(modifier.getParametersDrivers());
        this.modifiers.add(modifier);
    }

    @Override
    public List<EstimationModifier<T>> getModifiers() {
        return Collections.unmodifiableList(this.modifiers);
    }

    public static double signalTimeOfFlight(TimeStampedPVCoordinates adjustableEmitterPV, Vector3D receiverPosition, AbsoluteDate signalArrivalDate) {
        double delta;
        double offset;
        double delay = offset = signalArrivalDate.durationFrom(adjustableEmitterPV.getDate());
        double cReciprocal = 3.3356409519815204E-9;
        int count = 0;
        do {
            double previous = delay;
            Vector3D transitP = adjustableEmitterPV.shiftedBy(offset - delay).getPosition();
            delay = receiverPosition.distance((Point)transitP) * 3.3356409519815204E-9;
            delta = FastMath.abs((double)(delay - previous));
        } while (count++ < 10 && delta >= 2.0 * FastMath.ulp((double)delay));
        return delay;
    }

    public static <T extends RealFieldElement<T>> T signalTimeOfFlight(TimeStampedFieldPVCoordinates<T> adjustableEmitterPV, FieldVector3D<T> receiverPosition, FieldAbsoluteDate<T> signalArrivalDate) {
        double delta;
        T offset;
        Object delay = offset = signalArrivalDate.durationFrom(adjustableEmitterPV.getDate());
        double cReciprocal = 3.3356409519815204E-9;
        int count = 0;
        do {
            double previous = delay.getReal();
            FieldVector3D transitP = adjustableEmitterPV.shiftedBy((RealFieldElement)((RealFieldElement)delay.negate()).add(offset)).getPosition();
            delay = (RealFieldElement)receiverPosition.distance(transitP).multiply(3.3356409519815204E-9);
            delta = FastMath.abs((double)(delay.getReal() - previous));
        } while (count++ < 10 && delta >= 2.0 * FastMath.ulp((double)delay.getReal()));
        return delay;
    }

    @Deprecated
    public static TimeStampedFieldPVCoordinates<DerivativeStructure> getCoordinates(SpacecraftState state, int firstDerivative, DSFactory factory) {
        Vector3D p = state.getPVCoordinates().getPosition();
        FieldVector3D pDS = new FieldVector3D((RealFieldElement)factory.variable(firstDerivative + 0, p.getX()), (RealFieldElement)factory.variable(firstDerivative + 1, p.getY()), (RealFieldElement)factory.variable(firstDerivative + 2, p.getZ()));
        Vector3D v = state.getPVCoordinates().getVelocity();
        FieldVector3D vDS = new FieldVector3D((RealFieldElement)factory.variable(firstDerivative + 3, v.getX()), (RealFieldElement)factory.variable(firstDerivative + 4, v.getY()), (RealFieldElement)factory.variable(firstDerivative + 5, v.getZ()));
        Vector3D a = state.getPVCoordinates().getAcceleration();
        FieldVector3D aDS = new FieldVector3D((RealFieldElement)factory.constant(a.getX()), (RealFieldElement)factory.constant(a.getY()), (RealFieldElement)factory.constant(a.getZ()));
        return new TimeStampedFieldPVCoordinates<DerivativeStructure>(state.getDate(), pDS, vDS, aDS);
    }

    public static TimeStampedFieldPVCoordinates<Gradient> getCoordinates(SpacecraftState state, int firstDerivative, int freeParameters) {
        Vector3D p = state.getPVCoordinates().getPosition();
        FieldVector3D pDS = new FieldVector3D((RealFieldElement)Gradient.variable((int)freeParameters, (int)(firstDerivative + 0), (double)p.getX()), (RealFieldElement)Gradient.variable((int)freeParameters, (int)(firstDerivative + 1), (double)p.getY()), (RealFieldElement)Gradient.variable((int)freeParameters, (int)(firstDerivative + 2), (double)p.getZ()));
        Vector3D v = state.getPVCoordinates().getVelocity();
        FieldVector3D vDS = new FieldVector3D((RealFieldElement)Gradient.variable((int)freeParameters, (int)(firstDerivative + 3), (double)v.getX()), (RealFieldElement)Gradient.variable((int)freeParameters, (int)(firstDerivative + 4), (double)v.getY()), (RealFieldElement)Gradient.variable((int)freeParameters, (int)(firstDerivative + 5), (double)v.getZ()));
        Vector3D a = state.getPVCoordinates().getAcceleration();
        FieldVector3D aDS = new FieldVector3D((RealFieldElement)Gradient.constant((int)freeParameters, (double)a.getX()), (RealFieldElement)Gradient.constant((int)freeParameters, (double)a.getY()), (RealFieldElement)Gradient.constant((int)freeParameters, (double)a.getZ()));
        return new TimeStampedFieldPVCoordinates<Gradient>(state.getDate(), pDS, vDS, aDS);
    }
}

