/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.LazyLoadedEop;
import org.orekit.time.AbstractTimeScales;
import org.orekit.time.BDTScale;
import org.orekit.time.GLONASSScale;
import org.orekit.time.GMSTScale;
import org.orekit.time.GPSScale;
import org.orekit.time.GalileoScale;
import org.orekit.time.IRNSSScale;
import org.orekit.time.QZSSScale;
import org.orekit.time.TAIScale;
import org.orekit.time.TAIUTCDatFilesLoader;
import org.orekit.time.TCBScale;
import org.orekit.time.TCGScale;
import org.orekit.time.TDBScale;
import org.orekit.time.TTScale;
import org.orekit.time.UT1Scale;
import org.orekit.time.UTCScale;
import org.orekit.time.UTCTAIHistoryFilesLoader;
import org.orekit.time.UTCTAIOffsetsLoader;
import org.orekit.utils.IERSConventions;

public class LazyLoadedTimeScales
extends AbstractTimeScales {
    private final LazyLoadedEop lazyLoadedEop;
    private final List<UTCTAIOffsetsLoader> loaders = new ArrayList<UTCTAIOffsetsLoader>();
    private UTCScale utc = null;
    private TAIScale tai = null;
    private TTScale tt = null;
    private GalileoScale gst = null;
    private GLONASSScale glonass = null;
    private QZSSScale qzss = null;
    private GPSScale gps = null;
    private TCGScale tcg = null;
    private TDBScale tdb = null;
    private TCBScale tcb = null;
    private IRNSSScale irnss = null;
    private BDTScale bds = null;

    public LazyLoadedTimeScales(LazyLoadedEop lazyLoadedEop) {
        this.lazyLoadedEop = lazyLoadedEop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUTCTAIOffsetsLoader(UTCTAIOffsetsLoader loader) {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            this.loaders.add(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefaultUTCTAIOffsetsLoaders() {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            DataProvidersManager dataProvidersManager = this.lazyLoadedEop.getDataProvidersManager();
            this.addUTCTAIOffsetsLoader(new TAIUTCDatFilesLoader("^tai-utc\\.dat$", dataProvidersManager));
            this.addUTCTAIOffsetsLoader(new UTCTAIHistoryFilesLoader(dataProvidersManager));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUTCTAIOffsetsLoaders() {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            this.loaders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TAIScale getTAI() {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            if (this.tai == null) {
                this.tai = new TAIScale();
            }
            return this.tai;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UTCScale getUTC() {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            if (this.utc == null) {
                UTCTAIOffsetsLoader loader;
                List<Object> entries = Collections.emptyList();
                if (this.loaders.isEmpty()) {
                    this.addDefaultUTCTAIOffsetsLoaders();
                }
                Iterator<UTCTAIOffsetsLoader> iterator = this.loaders.iterator();
                while (iterator.hasNext() && (entries = (loader = iterator.next()).loadOffsets()).isEmpty()) {
                }
                if (entries.isEmpty()) {
                    throw new OrekitException((Localizable)OrekitMessages.NO_IERS_UTC_TAI_HISTORY_DATA_LOADED, new Object[0]);
                }
                this.utc = new UTCScale(this.getTAI(), entries);
            }
            return this.utc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UT1Scale getUT1(IERSConventions conventions, boolean simpleEOP) {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            return super.getUT1(conventions, simpleEOP);
        }
    }

    @Override
    protected EOPHistory getEopHistory(IERSConventions conventions, boolean simpleEOP) {
        return this.lazyLoadedEop.getEOPHistory(conventions, simpleEOP, this);
    }

    @Override
    public UT1Scale getUT1(EOPHistory history) {
        return super.getUT1(history);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TTScale getTT() {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            if (this.tt == null) {
                this.tt = new TTScale();
            }
            return this.tt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GalileoScale getGST() {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            if (this.gst == null) {
                this.gst = new GalileoScale();
            }
            return this.gst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLONASSScale getGLONASS() {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            if (this.glonass == null) {
                this.glonass = new GLONASSScale(this.getUTC());
            }
            return this.glonass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QZSSScale getQZSS() {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            if (this.qzss == null) {
                this.qzss = new QZSSScale();
            }
            return this.qzss;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GPSScale getGPS() {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            if (this.gps == null) {
                this.gps = new GPSScale();
            }
            return this.gps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCGScale getTCG() {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            if (this.tcg == null) {
                this.tcg = new TCGScale(this.getTT(), this.getTAI());
            }
            return this.tcg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TDBScale getTDB() {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            if (this.tdb == null) {
                this.tdb = new TDBScale(this.getTT(), this.getJ2000Epoch());
            }
            return this.tdb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCBScale getTCB() {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            if (this.tcb == null) {
                this.tcb = new TCBScale(this.getTDB(), this.getTAI());
            }
            return this.tcb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GMSTScale getGMST(IERSConventions conventions, boolean simpleEOP) {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            return super.getGMST(conventions, simpleEOP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRNSSScale getIRNSS() {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            if (this.irnss == null) {
                this.irnss = new IRNSSScale();
            }
            return this.irnss;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BDTScale getBDT() {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            if (this.bds == null) {
                this.bds = new BDTScale();
            }
            return this.bds;
        }
    }
}

