/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.interpolation.PiecewiseBicubicSplineInterpolatingFunction;
import org.hipparchus.analysis.interpolation.PiecewiseBicubicSplineInterpolator;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.InterpolationTableLoader;
import org.orekit.utils.ParameterDriver;

public class FixedTroposphericDelay
implements DiscreteTroposphericModel {
    private static FixedTroposphericDelay defaultModel;
    private final double[] xArr;
    private final double[] yArr;
    private final double[][] fArr;
    private PiecewiseBicubicSplineInterpolatingFunction delayFunction;

    public FixedTroposphericDelay(double[] xArr, double[] yArr, double[][] fArr) {
        this.xArr = (double[])xArr.clone();
        this.yArr = (double[])yArr.clone();
        this.fArr = (double[][])fArr.clone();
        this.delayFunction = new PiecewiseBicubicSplineInterpolator().interpolate(xArr, yArr, fArr);
    }

    @DefaultDataContext
    public FixedTroposphericDelay(String supportedName) {
        this(supportedName, DataContext.getDefault().getDataProvidersManager());
    }

    public FixedTroposphericDelay(String supportedName, DataProvidersManager dataProvidersManager) {
        InterpolationTableLoader loader = new InterpolationTableLoader();
        dataProvidersManager.feed(supportedName, loader);
        if (!loader.stillAcceptsData()) {
            this.xArr = loader.getAbscissaGrid();
            this.yArr = loader.getOrdinateGrid();
            for (int i = 0; i < this.yArr.length; ++i) {
                this.yArr[i] = FastMath.toRadians((double)this.yArr[i]);
            }
        } else {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_RESOURCE, supportedName);
        }
        this.fArr = loader.getValuesSamples();
        this.delayFunction = new PiecewiseBicubicSplineInterpolator().interpolate(this.xArr, this.yArr, this.fArr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultDataContext
    public static FixedTroposphericDelay getDefaultModel() {
        Class<FixedTroposphericDelay> clazz = FixedTroposphericDelay.class;
        synchronized (FixedTroposphericDelay.class) {
            if (defaultModel == null) {
                defaultModel = new FixedTroposphericDelay("^tropospheric-delay\\.txt$");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultModel;
        }
    }

    @Override
    public double pathDelay(double elevation, double height, double[] parameters, AbsoluteDate date) {
        double h = FastMath.min((double)FastMath.max((double)0.0, (double)height), (double)5000.0);
        double ele = FastMath.min((double)Math.PI, (double)FastMath.max((double)0.0, (double)elevation));
        double e = ele > 1.5707963267948966 ? Math.PI - ele : ele;
        return this.delayFunction.value(h, e);
    }

    @Override
    public <T extends RealFieldElement<T>> T pathDelay(T elevation, T height, T[] parameters, FieldAbsoluteDate<T> date) {
        RealFieldElement zero = (RealFieldElement)height.getField().getZero();
        RealFieldElement h = FastMath.min((RealFieldElement)FastMath.max((RealFieldElement)zero, height), (RealFieldElement)((RealFieldElement)zero.add(5000.0)));
        RealFieldElement ele = FastMath.min((RealFieldElement)((RealFieldElement)zero.add(Math.PI)), (RealFieldElement)FastMath.max((RealFieldElement)zero, elevation));
        RealFieldElement e = ele.getReal() > 1.5707963267948966 ? (RealFieldElement)((RealFieldElement)ele.negate()).add(Math.PI) : ele;
        return (T)this.delayFunction.value(h, e);
    }

    @Override
    public double[] computeZenithDelay(double height, double[] parameters, AbsoluteDate date) {
        return new double[]{this.pathDelay(1.5707963267948966, height, parameters, date), 0.0};
    }

    @Override
    public <T extends RealFieldElement<T>> T[] computeZenithDelay(T height, T[] parameters, FieldAbsoluteDate<T> date) {
        Field field = height.getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement[] delay = (RealFieldElement[])MathArrays.buildArray((Field)field, (int)2);
        delay[0] = this.pathDelay((RealFieldElement)zero.add(1.5707963267948966), (RealFieldElement)height, (RealFieldElement[])parameters, date);
        delay[1] = zero;
        return delay;
    }

    @Override
    public double[] mappingFactors(double elevation, double height, double[] parameters, AbsoluteDate date) {
        return new double[]{1.0, 1.0};
    }

    @Override
    public <T extends RealFieldElement<T>> T[] mappingFactors(T elevation, T height, T[] parameters, FieldAbsoluteDate<T> date) {
        Field<T> field = date.getField();
        RealFieldElement one = (RealFieldElement)field.getOne();
        RealFieldElement[] factors = (RealFieldElement[])MathArrays.buildArray(field, (int)2);
        factors[0] = one;
        factors[1] = one;
        return factors;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }
}

