/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.atmosphere;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.models.earth.atmosphere.Atmosphere;
import org.orekit.models.earth.atmosphere.DTM2000InputParameters;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.PVCoordinatesProvider;

public class DTM2000
implements Atmosphere {
    public static final int HYDROGEN = 1;
    public static final int HELIUM = 2;
    public static final int ATOMIC_OXYGEN = 3;
    public static final int MOLECULAR_NITROGEN = 4;
    public static final int MOLECULAR_OXYGEN = 5;
    public static final int ATOMIC_NITROGEN = 6;
    private static final long serialVersionUID = 20170705L;
    private static final int NLATM = 96;
    private static final double[] ALEFA = new double[]{0.0, -0.4, -0.38, 0.0, 0.0, 0.0, 0.0};
    private static final double[] MA = new double[]{0.0, 1.0, 4.0, 16.0, 28.0, 32.0, 14.0};
    private static final double[] VMA = new double[]{0.0, 1.6606E-24, 6.6423E-24, 2.6569E-23, 4.64958E-23, 5.31381E-23, 2.32479E-23};
    private static final double RE = 6356.77;
    private static final double ZLB0 = 120.0;
    private static final double CPMG = 0.19081;
    private static final double SPMG = 0.98163;
    private static final double XLMG = -1.2392;
    private static final double GSURF = 980.665;
    private static final double RGAS = 831.4;
    private static final double ROT = 0.017214206;
    private static final double ROT2 = 0.034428412;
    private static final String DTM2000 = "/assets/org/orekit/dtm_2000.txt";
    private static double[] tt = null;
    private static double[] h = null;
    private static double[] he = null;
    private static double[] o = null;
    private static double[] az2 = null;
    private static double[] o2 = null;
    private static double[] az = null;
    private static double[] t0 = null;
    private static double[] tp = null;
    private PVCoordinatesProvider sun;
    private DTM2000InputParameters inputParams;
    private BodyShape earth;
    private final TimeScale utc;

    @DefaultDataContext
    public DTM2000(DTM2000InputParameters parameters, PVCoordinatesProvider sun, BodyShape earth) {
        this(parameters, sun, earth, DataContext.getDefault().getTimeScales().getUTC());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DTM2000(DTM2000InputParameters parameters, PVCoordinatesProvider sun, BodyShape earth, TimeScale utc) {
        Class<DTM2000> clazz = DTM2000.class;
        synchronized (DTM2000.class) {
            if (tt == null) {
                org.orekit.models.earth.atmosphere.DTM2000.readcoefficients();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.earth = earth;
            this.sun = sun;
            this.inputParams = parameters;
            this.utc = utc;
            return;
        }
    }

    @Override
    public Frame getFrame() {
        return this.earth.getBodyFrame();
    }

    public double getDensity(int day, double alti, double lon, double lat, double hl, double f, double fbar, double akp3, double akp24) {
        double threshold = 120000.0;
        if (alti < 120000.0) {
            throw new OrekitException((Localizable)OrekitMessages.ALTITUDE_BELOW_ALLOWED_THRESHOLD, alti, 120000.0);
        }
        Computation result = new Computation(day, alti / 1000.0, lon, lat, hl, new double[]{0.0, f, 0.0}, new double[]{0.0, fbar, 0.0}, new double[]{0.0, akp3, 0.0, akp24, 0.0});
        return result.ro * 1000.0;
    }

    public <T extends RealFieldElement<T>> T getDensity(int day, T alti, T lon, T lat, T hl, double f, double fbar, double akp3, double akp24) {
        double threshold = 120000.0;
        if (alti.getReal() < 120000.0) {
            throw new OrekitException((Localizable)OrekitMessages.ALTITUDE_BELOW_ALLOWED_THRESHOLD, alti, 120000.0);
        }
        FieldComputation<RealFieldElement> result = new FieldComputation<RealFieldElement>(day, (RealFieldElement)alti.divide(1000.0), lon, lat, hl, new double[]{0.0, f, 0.0}, new double[]{0.0, fbar, 0.0}, new double[]{0.0, akp3, 0.0, akp24, 0.0});
        return (T)((RealFieldElement)((FieldComputation)result).ro.multiply(1000));
    }

    private static void readcoefficients() {
        int size = 97;
        tt = new double[97];
        h = new double[97];
        he = new double[97];
        o = new double[97];
        az2 = new double[97];
        o2 = new double[97];
        az = new double[97];
        t0 = new double[97];
        tp = new double[97];
        try (InputStream in = org.orekit.models.earth.atmosphere.DTM2000.checkNull(DTM2000.class.getResourceAsStream(DTM2000));
             BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            r.readLine();
            r.readLine();
            String line = r.readLine();
            while (line != null) {
                int num = Integer.parseInt(line.substring(0, 4).replace(' ', '0'));
                line = line.substring(4);
                org.orekit.models.earth.atmosphere.DTM2000.tt[num] = Double.parseDouble(line.substring(0, 13).replace(' ', '0'));
                line = line.substring(22);
                org.orekit.models.earth.atmosphere.DTM2000.h[num] = Double.parseDouble(line.substring(0, 13).replace(' ', '0'));
                line = line.substring(22);
                org.orekit.models.earth.atmosphere.DTM2000.he[num] = Double.parseDouble(line.substring(0, 13).replace(' ', '0'));
                line = line.substring(22);
                org.orekit.models.earth.atmosphere.DTM2000.o[num] = Double.parseDouble(line.substring(0, 13).replace(' ', '0'));
                line = line.substring(22);
                org.orekit.models.earth.atmosphere.DTM2000.az2[num] = Double.parseDouble(line.substring(0, 13).replace(' ', '0'));
                line = line.substring(22);
                org.orekit.models.earth.atmosphere.DTM2000.o2[num] = Double.parseDouble(line.substring(0, 13).replace(' ', '0'));
                line = line.substring(22);
                org.orekit.models.earth.atmosphere.DTM2000.az[num] = Double.parseDouble(line.substring(0, 13).replace(' ', '0'));
                line = line.substring(22);
                org.orekit.models.earth.atmosphere.DTM2000.t0[num] = Double.parseDouble(line.substring(0, 13).replace(' ', '0'));
                line = line.substring(22);
                org.orekit.models.earth.atmosphere.DTM2000.tp[num] = Double.parseDouble(line.substring(0, 13).replace(' ', '0'));
                line = r.readLine();
            }
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    @Override
    public double getDensity(AbsoluteDate date, Vector3D position, Frame frame) {
        if (date.compareTo(this.inputParams.getMaxDate()) > 0 || date.compareTo(this.inputParams.getMinDate()) < 0) {
            throw new OrekitException((Localizable)OrekitMessages.NO_SOLAR_ACTIVITY_AT_DATE, date, this.inputParams.getMinDate(), this.inputParams.getMaxDate());
        }
        int day = date.getComponents(this.utc).getDate().getDayOfYear();
        Frame ecef = this.earth.getBodyFrame();
        Vector3D pEcef = frame.getTransformTo(ecef, date).transformPosition(position);
        GeodeticPoint inBody = this.earth.transform(pEcef, ecef, date);
        double alti = inBody.getAltitude();
        double lon = inBody.getLongitude();
        double lat = inBody.getLatitude();
        Vector3D sunPos = this.sun.getPVCoordinates(date, ecef).getPosition();
        double hl = Math.PI + FastMath.atan2((double)(sunPos.getX() * pEcef.getY() - sunPos.getY() * pEcef.getX()), (double)(sunPos.getX() * pEcef.getX() + sunPos.getY() * pEcef.getY()));
        return this.getDensity(day, alti, lon, lat, hl, this.inputParams.getInstantFlux(date), this.inputParams.getMeanFlux(date), this.inputParams.getThreeHourlyKP(date), this.inputParams.get24HoursKp(date));
    }

    @Override
    public <T extends RealFieldElement<T>> T getDensity(FieldAbsoluteDate<T> date, FieldVector3D<T> position, Frame frame) {
        AbsoluteDate dateD = date.toAbsoluteDate();
        if (dateD.compareTo(this.inputParams.getMaxDate()) > 0 || dateD.compareTo(this.inputParams.getMinDate()) < 0) {
            throw new OrekitException((Localizable)OrekitMessages.NO_SOLAR_ACTIVITY_AT_DATE, dateD, this.inputParams.getMinDate(), this.inputParams.getMaxDate());
        }
        int day = date.getComponents(this.utc).getDate().getDayOfYear();
        Frame ecef = this.earth.getBodyFrame();
        FieldVector3D<T> pEcef = frame.getTransformTo(ecef, date).transformPosition(position);
        FieldGeodeticPoint<T> inBody = this.earth.transform(pEcef, ecef, date);
        T alti = inBody.getAltitude();
        T lon = inBody.getLongitude();
        T lat = inBody.getLatitude();
        Vector3D sunPos = this.sun.getPVCoordinates(dateD, ecef).getPosition();
        RealFieldElement y = (RealFieldElement)((RealFieldElement)pEcef.getY().multiply(sunPos.getX())).subtract(pEcef.getX().multiply(sunPos.getY()));
        RealFieldElement x = (RealFieldElement)((RealFieldElement)pEcef.getX().multiply(sunPos.getX())).add(pEcef.getY().multiply(sunPos.getY()));
        RealFieldElement hl = (RealFieldElement)((RealFieldElement)y.atan2((Object)x)).add(Math.PI);
        return (T)this.getDensity(day, alti, lon, lat, (T)hl, this.inputParams.getInstantFlux(dateD), this.inputParams.getMeanFlux(dateD), this.inputParams.getThreeHourlyKP(dateD), this.inputParams.get24HoursKp(dateD));
    }

    private static InputStream checkNull(InputStream stream) {
        if (stream == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_RESOURCE, DTM2000);
        }
        return stream;
    }

    private static class FieldComputation<T extends RealFieldElement<T>> {
        private int day;
        private double[] f = new double[3];
        private double[] fbar = new double[3];
        private double[] akp = new double[5];
        private final T clfl;
        private final T slfl;
        private final T ro;
        private final T p10;
        private final T p20;
        private final T p30;
        private final T p40;
        private final T p50;
        private final T p60;
        private final T p11;
        private final T p21;
        private final T p31;
        private final T p41;
        private final T p51;
        private final T p22;
        private final T p32;
        private final T p42;
        private final T p52;
        private final T p62;
        private final T p33;
        private final T p10mg;
        private final T p20mg;
        private final T p40mg;
        private final T hl0;
        private final T ch;
        private final T sh;
        private final T c2h;
        private final T s2h;
        private final T c3h;
        private final T s3h;

        FieldComputation(int day, T altiKM, T lon, T lat, T hl, double[] f, double[] far, double[] akp) {
            this.day = day;
            this.f = f;
            this.fbar = far;
            this.akp = akp;
            RealFieldElement c = (RealFieldElement)lat.sin();
            RealFieldElement c2 = (RealFieldElement)c.multiply((Object)c);
            RealFieldElement c4 = (RealFieldElement)c2.multiply((Object)c2);
            RealFieldElement s = (RealFieldElement)lat.cos();
            RealFieldElement s2 = (RealFieldElement)s.multiply((Object)s);
            this.p10 = c;
            this.p20 = (RealFieldElement)((RealFieldElement)c2.multiply(1.5)).subtract(0.5);
            this.p30 = (RealFieldElement)c.multiply(((RealFieldElement)c2.multiply(2.5)).subtract(1.5));
            this.p40 = (RealFieldElement)((RealFieldElement)((RealFieldElement)c4.multiply(4.375)).subtract(c2.multiply(3.75))).add(0.375);
            this.p50 = (RealFieldElement)c.multiply(((RealFieldElement)((RealFieldElement)c4.multiply(7.875)).subtract(c2.multiply(8.75))).add(1.875));
            this.p60 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(5.5)).multiply(this.p50)).subtract(this.p40.multiply(2.5))).divide(3.0);
            this.p11 = s;
            this.p21 = (RealFieldElement)((RealFieldElement)c.multiply(3.0)).multiply((Object)s);
            this.p31 = (RealFieldElement)s.multiply(((RealFieldElement)c2.multiply(7.5)).subtract(1.5));
            this.p41 = (RealFieldElement)((RealFieldElement)c.multiply((Object)s)).multiply(((RealFieldElement)c2.multiply(17.5)).subtract(7.5));
            this.p51 = (RealFieldElement)s.multiply(((RealFieldElement)((RealFieldElement)c4.multiply(39.375)).subtract(c2.multiply(26.25))).add(1.875));
            this.p22 = (RealFieldElement)s2.multiply(3.0);
            this.p32 = (RealFieldElement)((RealFieldElement)c.multiply(15.0)).multiply((Object)s2);
            this.p42 = (RealFieldElement)s2.multiply(((RealFieldElement)c2.multiply(52.5)).subtract(7.5));
            this.p52 = (RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(3.0)).multiply(this.p42)).subtract(this.p32.multiply(2.0));
            this.p62 = (RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(2.75)).multiply(this.p52)).subtract(this.p42.multiply(1.75));
            this.p33 = (RealFieldElement)((RealFieldElement)s.multiply(15.0)).multiply((Object)s2);
            RealFieldElement clmlmg = (RealFieldElement)((RealFieldElement)lon.subtract(-1.2392)).cos();
            RealFieldElement cmg = (RealFieldElement)((RealFieldElement)((RealFieldElement)s.multiply(0.19081)).multiply((Object)clmlmg)).add(c.multiply(0.98163));
            RealFieldElement cmg2 = (RealFieldElement)cmg.multiply((Object)cmg);
            RealFieldElement cmg4 = (RealFieldElement)cmg2.multiply((Object)cmg2);
            this.p10mg = cmg;
            this.p20mg = (RealFieldElement)((RealFieldElement)cmg2.multiply(1.5)).subtract(0.5);
            this.p40mg = (RealFieldElement)((RealFieldElement)((RealFieldElement)cmg4.multiply(4.375)).subtract(cmg2.multiply(3.75))).add(0.375);
            this.clfl = (RealFieldElement)lon.cos();
            this.slfl = (RealFieldElement)lon.sin();
            this.hl0 = hl;
            this.ch = (RealFieldElement)this.hl0.cos();
            this.sh = (RealFieldElement)this.hl0.sin();
            this.c2h = (RealFieldElement)((RealFieldElement)this.ch.multiply(this.ch)).subtract(this.sh.multiply(this.sh));
            this.s2h = (RealFieldElement)((RealFieldElement)this.ch.multiply(this.sh)).multiply(2);
            this.c3h = (RealFieldElement)((RealFieldElement)this.c2h.multiply(this.ch)).subtract(this.s2h.multiply(this.sh));
            this.s3h = (RealFieldElement)((RealFieldElement)this.s2h.multiply(this.ch)).add(this.c2h.multiply(this.sh));
            double zlb = 120.0;
            RealFieldElement[] dtt = (RealFieldElement[])MathArrays.buildArray((Field)altiKM.getField(), (int)tt.length);
            RealFieldElement[] dh = (RealFieldElement[])MathArrays.buildArray((Field)altiKM.getField(), (int)tt.length);
            RealFieldElement[] dhe = (RealFieldElement[])MathArrays.buildArray((Field)altiKM.getField(), (int)tt.length);
            RealFieldElement[] dox = (RealFieldElement[])MathArrays.buildArray((Field)altiKM.getField(), (int)tt.length);
            RealFieldElement[] daz2 = (RealFieldElement[])MathArrays.buildArray((Field)altiKM.getField(), (int)tt.length);
            RealFieldElement[] do2 = (RealFieldElement[])MathArrays.buildArray((Field)altiKM.getField(), (int)tt.length);
            RealFieldElement[] daz = (RealFieldElement[])MathArrays.buildArray((Field)altiKM.getField(), (int)tt.length);
            RealFieldElement[] dt0 = (RealFieldElement[])MathArrays.buildArray((Field)altiKM.getField(), (int)tt.length);
            RealFieldElement[] dtp = (RealFieldElement[])MathArrays.buildArray((Field)altiKM.getField(), (int)tt.length);
            int kleq = 1;
            RealFieldElement gdelt = this.gFunction(tt, dtt, 1, kleq);
            dtt[1] = (RealFieldElement)gdelt.add(1.0);
            RealFieldElement tinf = (RealFieldElement)dtt[1].multiply(tt[1]);
            kleq = 0;
            if (day < 59 || day > 284) {
                kleq = -1;
            }
            if (day > 99 && day < 244) {
                kleq = 1;
            }
            RealFieldElement gdelt0 = this.gFunction(t0, dt0, 0, kleq);
            dt0[1] = (RealFieldElement)((RealFieldElement)gdelt0.add(t0[1])).divide(t0[1]);
            RealFieldElement t120 = (RealFieldElement)gdelt0.add(t0[1]);
            RealFieldElement gdeltp = this.gFunction(tp, dtp, 0, kleq);
            dtp[1] = (RealFieldElement)((RealFieldElement)gdeltp.add(tp[1])).divide(tp[1]);
            RealFieldElement tp120 = (RealFieldElement)gdeltp.add(tp[1]);
            RealFieldElement sigma = (RealFieldElement)tp120.divide(tinf.subtract((Object)t120));
            RealFieldElement dzeta = (RealFieldElement)((RealFieldElement)((RealFieldElement)altiKM.add(6356.77)).reciprocal()).multiply(6476.77);
            RealFieldElement zeta = (RealFieldElement)((RealFieldElement)altiKM.subtract(120.0)).multiply((Object)dzeta);
            RealFieldElement sigzeta = (RealFieldElement)sigma.multiply((Object)zeta);
            RealFieldElement expsz = (RealFieldElement)((RealFieldElement)sigzeta.negate()).exp();
            RealFieldElement tz = (RealFieldElement)tinf.subtract(((RealFieldElement)tinf.subtract((Object)t120)).multiply((Object)expsz));
            RealFieldElement[] dbase = (RealFieldElement[])MathArrays.buildArray((Field)altiKM.getField(), (int)7);
            kleq = 1;
            RealFieldElement gdelh = this.gFunction(h, dh, 0, kleq);
            dh[1] = (RealFieldElement)gdelh.exp();
            dbase[1] = (RealFieldElement)dh[1].multiply(h[1]);
            RealFieldElement gdelhe = this.gFunction(he, dhe, 0, kleq);
            dhe[1] = (RealFieldElement)gdelhe.exp();
            dbase[2] = (RealFieldElement)dhe[1].multiply(he[1]);
            RealFieldElement gdelo = this.gFunction(o, dox, 1, kleq);
            dox[1] = (RealFieldElement)gdelo.exp();
            dbase[3] = (RealFieldElement)dox[1].multiply(o[1]);
            RealFieldElement gdelaz2 = this.gFunction(az2, daz2, 1, kleq);
            daz2[1] = (RealFieldElement)gdelaz2.exp();
            dbase[4] = (RealFieldElement)daz2[1].multiply(az2[1]);
            RealFieldElement gdelo2 = this.gFunction(o2, do2, 1, kleq);
            do2[1] = (RealFieldElement)gdelo2.exp();
            dbase[5] = (RealFieldElement)do2[1].multiply(o2[1]);
            RealFieldElement gdelaz = this.gFunction(az, daz, 1, kleq);
            daz[1] = (RealFieldElement)gdelaz.exp();
            dbase[6] = (RealFieldElement)daz[1].multiply(az[1]);
            double zlbre = 1.0188775116922588;
            RealFieldElement glb = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)sigma.multiply(831.4)).multiply((Object)tinf)).reciprocal()).multiply(944.6626010205721);
            RealFieldElement t120tz = (RealFieldElement)t120.divide((Object)tz);
            RealFieldElement tmpro = (RealFieldElement)altiKM.getField().getZero();
            for (int i = 1; i <= 6; ++i) {
                RealFieldElement gamma = (RealFieldElement)glb.multiply(MA[i]);
                RealFieldElement upapg = (RealFieldElement)gamma.add(1.0 + ALEFA[i]);
                RealFieldElement fzI = (RealFieldElement)((RealFieldElement)t120tz.pow((Object)upapg)).multiply(((RealFieldElement)((RealFieldElement)sigzeta.negate()).multiply((Object)gamma)).exp());
                RealFieldElement ccI = (RealFieldElement)dbase[i].multiply((Object)fzI);
                tmpro = (RealFieldElement)tmpro.add(ccI.multiply(VMA[i]));
            }
            this.ro = tmpro;
        }

        private T gFunction(double[] a, T[] da, int ff0, int kle_eq) {
            RealFieldElement zero = (RealFieldElement)da[0].getField().getZero();
            double[] fmfb = new double[3];
            double[] fbm150 = new double[3];
            da[2] = this.p20;
            da[3] = this.p40;
            da[74] = this.p10;
            double a74 = a[74];
            double a77 = a[77];
            double a78 = a[78];
            if (kle_eq == -1) {
                a74 = -a74;
                a77 = -a77;
                a78 = -a78;
            }
            if (kle_eq == 0) {
                a74 = this.semestrialCorrection(a74);
                a77 = this.semestrialCorrection(a77);
                a78 = this.semestrialCorrection(a78);
            }
            da[77] = this.p30;
            da[78] = this.p50;
            da[79] = this.p60;
            fmfb[1] = this.f[1] - this.fbar[1];
            fmfb[2] = this.f[2] - this.fbar[2];
            fbm150[1] = this.fbar[1] - 150.0;
            fbm150[2] = this.fbar[2];
            da[4] = (RealFieldElement)zero.add(fmfb[1]);
            da[6] = (RealFieldElement)zero.add(fbm150[1]);
            da[4] = (RealFieldElement)da[4].add(a[70] * fmfb[2]);
            da[6] = (RealFieldElement)da[6].add(a[71] * fbm150[2]);
            da[70] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)da[4].multiply(a[5])).multiply(2)).add(this.p10.multiply(a[82]))).add(this.p20.multiply(a[83]))).add(this.p30.multiply(a[84]))).add(a[4])).multiply(fmfb[2]);
            da[71] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)da[6].multiply(a[69])).multiply(2)).add(this.p10.multiply(a[85]))).add(this.p20.multiply(a[86]))).add(this.p30.multiply(a[87]))).add(a[6])).multiply(fbm150[2]);
            da[5] = (RealFieldElement)da[4].multiply(da[4]);
            da[69] = (RealFieldElement)da[6].multiply(da[6]);
            da[82] = (RealFieldElement)da[4].multiply(this.p10);
            da[83] = (RealFieldElement)da[4].multiply(this.p20);
            da[84] = (RealFieldElement)da[4].multiply(this.p30);
            da[85] = (RealFieldElement)da[6].multiply(this.p20);
            da[86] = (RealFieldElement)da[6].multiply(this.p30);
            da[87] = (RealFieldElement)da[6].multiply(this.p40);
            int ikp = 62;
            int ikpm = 67;
            RealFieldElement c2fi = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.p10mg.multiply(this.p10mg)).negate()).add(1.0);
            RealFieldElement dkp = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c2fi.multiply(a[63])).add(a[62])).multiply(this.akp[2])).add(this.akp[1]);
            RealFieldElement dakp = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.p20mg.multiply(a[8])).add(this.p40mg.multiply(a[68]))).add(((RealFieldElement)((RealFieldElement)this.p20mg.multiply(a[61])).add(((RealFieldElement)((RealFieldElement)dkp.multiply((Object)dkp)).multiply(2.0 * a[75])).add(a[60]))).multiply(dkp.multiply(2)))).add(a[7]);
            da[62] = (RealFieldElement)dakp.multiply(this.akp[2]);
            da[63] = (RealFieldElement)da[62].multiply((Object)c2fi);
            double dkpm = this.akp[3] + a[67] * this.akp[4];
            RealFieldElement dakpm = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.p20mg.multiply(a[65])).add(this.p40mg.multiply(a[72]))).add(((RealFieldElement)((RealFieldElement)this.p20mg.multiply(a[73])).add(a[66] + a[76] * 2.0 * dkpm * dkpm)).multiply(2.0 * dkpm))).add(a[64]);
            da[67] = (RealFieldElement)dakpm.multiply(this.akp[4]);
            da[7] = dkp;
            da[8] = (RealFieldElement)this.p20mg.multiply((Object)dkp);
            da[68] = (RealFieldElement)this.p40mg.multiply((Object)dkp);
            da[60] = (RealFieldElement)dkp.multiply((Object)dkp);
            da[61] = (RealFieldElement)this.p20mg.multiply(da[60]);
            da[75] = (RealFieldElement)da[60].multiply(da[60]);
            da[64] = (RealFieldElement)zero.add(dkpm);
            da[65] = (RealFieldElement)this.p20mg.multiply(dkpm);
            da[72] = (RealFieldElement)this.p40mg.multiply(dkpm);
            da[66] = (RealFieldElement)zero.add(dkpm * dkpm);
            da[73] = (RealFieldElement)this.p20mg.multiply(da[66]);
            da[76] = (RealFieldElement)da[66].multiply(da[66]);
            RealFieldElement f0 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)da[4].multiply(a[4])).add(da[5].multiply(a[5]))).add(da[6].multiply(a[6]))).add(da[69].multiply(a[69]))).add(da[82].multiply(a[82]))).add(da[83].multiply(a[83]))).add(da[84].multiply(a[84]))).add(da[85].multiply(a[85]))).add(da[86].multiply(a[86]))).add(da[87].multiply(a[87]));
            RealFieldElement f1f = (RealFieldElement)((RealFieldElement)f0.multiply(ff0)).add(1.0);
            f0 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)f0.add(da[2].multiply(a[2]))).add(da[3].multiply(a[3]))).add(da[7].multiply(a[7]))).add(da[8].multiply(a[8]))).add(da[60].multiply(a[60]))).add(da[61].multiply(a[61]))).add(da[68].multiply(a[68]))).add(da[64].multiply(a[64]))).add(da[65].multiply(a[65]))).add(da[66].multiply(a[66]))).add(da[72].multiply(a[72]))).add(da[73].multiply(a[73]))).add(da[74].multiply(a74))).add(da[75].multiply(a[75]))).add(da[76].multiply(a[76]))).add(da[77].multiply(a77))).add(da[78].multiply(a78))).add(da[79].multiply(a[79]));
            da[9] = (RealFieldElement)zero.add(FastMath.cos((double)(0.017214206 * ((double)this.day - a[11]))));
            da[10] = (RealFieldElement)this.p20.multiply(da[9]);
            da[12] = (RealFieldElement)zero.add(FastMath.cos((double)(0.034428412 * ((double)this.day - a[14]))));
            da[13] = (RealFieldElement)this.p20.multiply(da[12]);
            double coste = FastMath.cos((double)(0.017214206 * ((double)this.day - a[18])));
            da[15] = (RealFieldElement)this.p10.multiply(coste);
            da[16] = (RealFieldElement)this.p30.multiply(coste);
            da[17] = (RealFieldElement)this.p50.multiply(coste);
            double cos2te = FastMath.cos((double)(0.034428412 * ((double)this.day - a[20])));
            da[19] = (RealFieldElement)this.p10.multiply(cos2te);
            da[39] = (RealFieldElement)this.p30.multiply(cos2te);
            da[59] = (RealFieldElement)this.p50.multiply(cos2te);
            da[21] = (RealFieldElement)this.p11.multiply(this.ch);
            da[22] = (RealFieldElement)this.p31.multiply(this.ch);
            da[23] = (RealFieldElement)this.p51.multiply(this.ch);
            da[24] = (RealFieldElement)da[21].multiply(coste);
            da[25] = (RealFieldElement)((RealFieldElement)this.p21.multiply(this.ch)).multiply(coste);
            da[26] = (RealFieldElement)this.p11.multiply(this.sh);
            da[27] = (RealFieldElement)this.p31.multiply(this.sh);
            da[28] = (RealFieldElement)this.p51.multiply(this.sh);
            da[29] = (RealFieldElement)da[26].multiply(coste);
            da[30] = (RealFieldElement)((RealFieldElement)this.p21.multiply(this.sh)).multiply(coste);
            da[31] = (RealFieldElement)this.p22.multiply(this.c2h);
            da[37] = (RealFieldElement)this.p42.multiply(this.c2h);
            da[32] = (RealFieldElement)((RealFieldElement)this.p32.multiply(this.c2h)).multiply(coste);
            da[33] = (RealFieldElement)this.p22.multiply(this.s2h);
            da[38] = (RealFieldElement)this.p42.multiply(this.s2h);
            da[34] = (RealFieldElement)((RealFieldElement)this.p32.multiply(this.s2h)).multiply(coste);
            da[88] = (RealFieldElement)this.p32.multiply(this.c2h);
            da[89] = (RealFieldElement)this.p32.multiply(this.s2h);
            da[90] = (RealFieldElement)this.p52.multiply(this.c2h);
            da[91] = (RealFieldElement)this.p52.multiply(this.s2h);
            double a88 = a[88];
            double a89 = a[89];
            double a90 = a[90];
            double a91 = a[91];
            if (kle_eq == -1) {
                a88 = -a88;
                a89 = -a89;
                a90 = -a90;
                a91 = -a91;
            }
            if (kle_eq == 0) {
                a88 = this.semestrialCorrection(a88);
                a89 = this.semestrialCorrection(a89);
                a90 = this.semestrialCorrection(a90);
                a91 = this.semestrialCorrection(a91);
            }
            da[92] = (RealFieldElement)this.p62.multiply(this.c2h);
            da[93] = (RealFieldElement)this.p62.multiply(this.s2h);
            da[35] = (RealFieldElement)this.p33.multiply(this.c3h);
            da[36] = (RealFieldElement)this.p33.multiply(this.s3h);
            RealFieldElement fp = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)da[9].multiply(a[9])).add(da[10].multiply(a[10]))).add(da[12].multiply(a[12]))).add(da[13].multiply(a[13]))).add(da[15].multiply(a[15]))).add(da[16].multiply(a[16]))).add(da[17].multiply(a[17]))).add(da[19].multiply(a[19]))).add(da[21].multiply(a[21]))).add(da[22].multiply(a[22]))).add(da[23].multiply(a[23]))).add(da[24].multiply(a[24]))).add(da[25].multiply(a[25]))).add(da[26].multiply(a[26]))).add(da[27].multiply(a[27]))).add(da[28].multiply(a[28]))).add(da[29].multiply(a[29]))).add(da[30].multiply(a[30]))).add(da[31].multiply(a[31]))).add(da[32].multiply(a[32]))).add(da[33].multiply(a[33]))).add(da[34].multiply(a[34]))).add(da[35].multiply(a[35]))).add(da[36].multiply(a[36]))).add(da[37].multiply(a[37]))).add(da[38].multiply(a[38]))).add(da[39].multiply(a[39]))).add(da[59].multiply(a[59]))).add(da[88].multiply(a88))).add(da[89].multiply(a89))).add(da[90].multiply(a90))).add(da[91].multiply(a91))).add(da[92].multiply(a[92]))).add(da[93].multiply(a[93]));
            da[40] = (RealFieldElement)((RealFieldElement)this.p10.multiply(coste)).multiply((Object)dkp);
            da[41] = (RealFieldElement)((RealFieldElement)this.p30.multiply(coste)).multiply((Object)dkp);
            da[42] = (RealFieldElement)((RealFieldElement)this.p50.multiply(coste)).multiply((Object)dkp);
            da[43] = (RealFieldElement)((RealFieldElement)this.p11.multiply(this.ch)).multiply((Object)dkp);
            da[44] = (RealFieldElement)((RealFieldElement)this.p31.multiply(this.ch)).multiply((Object)dkp);
            da[45] = (RealFieldElement)((RealFieldElement)this.p51.multiply(this.ch)).multiply((Object)dkp);
            da[46] = (RealFieldElement)((RealFieldElement)this.p11.multiply(this.sh)).multiply((Object)dkp);
            da[47] = (RealFieldElement)((RealFieldElement)this.p31.multiply(this.sh)).multiply((Object)dkp);
            da[48] = (RealFieldElement)((RealFieldElement)this.p51.multiply(this.sh)).multiply((Object)dkp);
            fp = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)fp.add(da[40].multiply(a[40]))).add(da[41].multiply(a[41]))).add(da[42].multiply(a[42]))).add(da[43].multiply(a[43]))).add(da[44].multiply(a[44]))).add(da[45].multiply(a[45]))).add(da[46].multiply(a[46]))).add(da[47].multiply(a[47]))).add(da[48].multiply(a[48]));
            dakp = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.p10.multiply(a[40])).add(this.p30.multiply(a[41]))).add(this.p50.multiply(a[42]))).multiply(coste)).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)this.p11.multiply(a[40])).add(this.p31.multiply(a[44]))).add(this.p51.multiply(a[45]))).multiply(this.ch))).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)this.p11.multiply(a[46])).add(this.p31.multiply(a[47]))).add(this.p51.multiply(a[48]))).multiply(this.sh));
            da[62] = (RealFieldElement)da[62].add(dakp.multiply(this.akp[2]));
            da[63] = (RealFieldElement)da[62].add(((RealFieldElement)dakp.multiply((Object)c2fi)).multiply(this.akp[2]));
            da[49] = (RealFieldElement)this.p11.multiply(this.clfl);
            da[50] = (RealFieldElement)this.p21.multiply(this.clfl);
            da[51] = (RealFieldElement)this.p31.multiply(this.clfl);
            da[52] = (RealFieldElement)this.p41.multiply(this.clfl);
            da[53] = (RealFieldElement)this.p51.multiply(this.clfl);
            da[54] = (RealFieldElement)this.p11.multiply(this.slfl);
            da[55] = (RealFieldElement)this.p21.multiply(this.slfl);
            da[56] = (RealFieldElement)this.p31.multiply(this.slfl);
            da[57] = (RealFieldElement)this.p41.multiply(this.slfl);
            da[58] = (RealFieldElement)this.p51.multiply(this.slfl);
            fp = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)fp.add(da[49].multiply(a[49]))).add(da[50].multiply(a[50]))).add(da[51].multiply(a[51]))).add(da[52].multiply(a[52]))).add(da[53].multiply(a[53]))).add(da[54].multiply(a[54]))).add(da[55].multiply(a[55]))).add(da[56].multiply(a[56]))).add(da[57].multiply(a[57]))).add(da[58].multiply(a[58]));
            return (T)((RealFieldElement)f0.add(fp.multiply((Object)f1f)));
        }

        private double semestrialCorrection(double param) {
            double result;
            int debeq_pr = 59;
            int debeq_au = 244;
            if (this.day >= 100) {
                double xmult = (double)(this.day - 244) / 40.0;
                result = param - 2.0 * param * xmult;
            } else {
                double xmult = (double)(this.day - 59) / 40.0;
                result = 2.0 * param * xmult - param;
            }
            return result;
        }
    }

    private static class Computation {
        private final int day;
        private final double[] f;
        private final double[] fbar;
        private final double[] akp;
        private final double clfl;
        private final double slfl;
        private final double ro;
        private final double p10;
        private final double p20;
        private final double p30;
        private final double p40;
        private final double p50;
        private final double p60;
        private final double p11;
        private final double p21;
        private final double p31;
        private final double p41;
        private final double p51;
        private final double p22;
        private final double p32;
        private final double p42;
        private final double p52;
        private final double p62;
        private final double p33;
        private final double p10mg;
        private final double p20mg;
        private final double p40mg;
        private final double hl0;
        private final double ch;
        private final double sh;
        private final double c2h;
        private final double s2h;
        private final double c3h;
        private final double s3h;

        Computation(int day, double altiKM, double lon, double lat, double hl, double[] f, double[] fbar, double[] akp) {
            this.day = day;
            this.f = f;
            this.fbar = fbar;
            this.akp = akp;
            double c = FastMath.sin((double)lat);
            double c2 = c * c;
            double c4 = c2 * c2;
            double s = FastMath.cos((double)lat);
            double s2 = s * s;
            this.p10 = c;
            this.p20 = 1.5 * c2 - 0.5;
            this.p30 = c * (2.5 * c2 - 1.5);
            this.p40 = 4.375 * c4 - 3.75 * c2 + 0.375;
            this.p50 = c * (7.875 * c4 - 8.75 * c2 + 1.875);
            this.p60 = (5.5 * c * this.p50 - 2.5 * this.p40) / 3.0;
            this.p11 = s;
            this.p21 = 3.0 * c * s;
            this.p31 = s * (7.5 * c2 - 1.5);
            this.p41 = c * s * (17.5 * c2 - 7.5);
            this.p51 = s * (39.375 * c4 - 26.25 * c2 + 1.875);
            this.p22 = 3.0 * s2;
            this.p32 = 15.0 * c * s2;
            this.p42 = s2 * (52.5 * c2 - 7.5);
            this.p52 = 3.0 * c * this.p42 - 2.0 * this.p32;
            this.p62 = 2.75 * c * this.p52 - 1.75 * this.p42;
            this.p33 = 15.0 * s * s2;
            double clmlmg = FastMath.cos((double)(lon - -1.2392));
            double cmg = s * 0.19081 * clmlmg + c * 0.98163;
            double cmg2 = cmg * cmg;
            double cmg4 = cmg2 * cmg2;
            this.p10mg = cmg;
            this.p20mg = 1.5 * cmg2 - 0.5;
            this.p40mg = 4.375 * cmg4 - 3.75 * cmg2 + 0.375;
            this.clfl = FastMath.cos((double)lon);
            this.slfl = FastMath.sin((double)lon);
            this.hl0 = hl;
            this.ch = FastMath.cos((double)this.hl0);
            this.sh = FastMath.sin((double)this.hl0);
            this.c2h = this.ch * this.ch - this.sh * this.sh;
            this.s2h = 2.0 * this.ch * this.sh;
            this.c3h = this.c2h * this.ch - this.s2h * this.sh;
            this.s3h = this.s2h * this.ch + this.c2h * this.sh;
            double zlb = 120.0;
            double[] dtt = new double[tt.length];
            double[] dh = new double[tt.length];
            double[] dhe = new double[tt.length];
            double[] dox = new double[tt.length];
            double[] daz2 = new double[tt.length];
            double[] do2 = new double[tt.length];
            double[] daz = new double[tt.length];
            double[] dt0 = new double[tt.length];
            double[] dtp = new double[tt.length];
            Arrays.fill(dtt, Double.NaN);
            Arrays.fill(dh, Double.NaN);
            Arrays.fill(dhe, Double.NaN);
            Arrays.fill(dox, Double.NaN);
            Arrays.fill(daz2, Double.NaN);
            Arrays.fill(do2, Double.NaN);
            Arrays.fill(daz, Double.NaN);
            Arrays.fill(dt0, Double.NaN);
            Arrays.fill(dtp, Double.NaN);
            int kleq = 1;
            double gdelt = this.gFunction(tt, dtt, 1, kleq);
            dtt[1] = 1.0 + gdelt;
            double tinf = tt[1] * dtt[1];
            kleq = 0;
            if (day < 59 || day > 284) {
                kleq = -1;
            }
            if (day > 99 && day < 244) {
                kleq = 1;
            }
            double gdelt0 = this.gFunction(t0, dt0, 0, kleq);
            dt0[1] = (t0[1] + gdelt0) / t0[1];
            double t120 = t0[1] + gdelt0;
            double gdeltp = this.gFunction(tp, dtp, 0, kleq);
            dtp[1] = (tp[1] + gdeltp) / tp[1];
            double tp120 = tp[1] + gdeltp;
            double sigma = tp120 / (tinf - t120);
            double dzeta = 6476.77 / (6356.77 + altiKM);
            double zeta = (altiKM - 120.0) * dzeta;
            double sigzeta = sigma * zeta;
            double expsz = FastMath.exp((double)(-sigzeta));
            double tz = tinf - (tinf - t120) * expsz;
            double[] dbase = new double[7];
            kleq = 1;
            double gdelh = this.gFunction(h, dh, 0, kleq);
            dh[1] = FastMath.exp((double)gdelh);
            dbase[1] = h[1] * dh[1];
            double gdelhe = this.gFunction(he, dhe, 0, kleq);
            dhe[1] = FastMath.exp((double)gdelhe);
            dbase[2] = he[1] * dhe[1];
            double gdelo = this.gFunction(o, dox, 1, kleq);
            dox[1] = FastMath.exp((double)gdelo);
            dbase[3] = o[1] * dox[1];
            double gdelaz2 = this.gFunction(az2, daz2, 1, kleq);
            daz2[1] = FastMath.exp((double)gdelaz2);
            dbase[4] = az2[1] * daz2[1];
            double gdelo2 = this.gFunction(o2, do2, 1, kleq);
            do2[1] = FastMath.exp((double)gdelo2);
            dbase[5] = o2[1] * do2[1];
            double gdelaz = this.gFunction(az, daz, 1, kleq);
            daz[1] = FastMath.exp((double)gdelaz);
            dbase[6] = az[1] * daz[1];
            double zlbre = 1.0188775116922588;
            double glb = 944.6626010205721 / (sigma * 831.4 * tinf);
            double t120tz = t120 / tz;
            double tmpro = 0.0;
            for (int i = 1; i <= 6; ++i) {
                double gamma = MA[i] * glb;
                double upapg = 1.0 + ALEFA[i] + gamma;
                double fzI = FastMath.pow((double)t120tz, (double)upapg) * FastMath.exp((double)(-sigzeta * gamma));
                double ccI = dbase[i] * fzI;
                tmpro += ccI * VMA[i];
            }
            this.ro = tmpro;
        }

        private double gFunction(double[] a, double[] da, int ff0, int kle_eq) {
            double[] fmfb = new double[3];
            double[] fbm150 = new double[3];
            da[2] = this.p20;
            da[3] = this.p40;
            da[74] = this.p10;
            double a74 = a[74];
            double a77 = a[77];
            double a78 = a[78];
            if (kle_eq == -1) {
                a74 = -a74;
                a77 = -a77;
                a78 = -a78;
            }
            if (kle_eq == 0) {
                a74 = this.semestrialCorrection(a74);
                a77 = this.semestrialCorrection(a77);
                a78 = this.semestrialCorrection(a78);
            }
            da[77] = this.p30;
            da[78] = this.p50;
            da[79] = this.p60;
            fmfb[1] = this.f[1] - this.fbar[1];
            fmfb[2] = this.f[2] - this.fbar[2];
            fbm150[1] = this.fbar[1] - 150.0;
            fbm150[2] = this.fbar[2];
            da[4] = fmfb[1];
            da[6] = fbm150[1];
            da[4] = da[4] + a[70] * fmfb[2];
            da[6] = da[6] + a[71] * fbm150[2];
            da[70] = fmfb[2] * (a[4] + 2.0 * a[5] * da[4] + a[82] * this.p10 + a[83] * this.p20 + a[84] * this.p30);
            da[71] = fbm150[2] * (a[6] + 2.0 * a[69] * da[6] + a[85] * this.p10 + a[86] * this.p20 + a[87] * this.p30);
            da[5] = da[4] * da[4];
            da[69] = da[6] * da[6];
            da[82] = da[4] * this.p10;
            da[83] = da[4] * this.p20;
            da[84] = da[4] * this.p30;
            da[85] = da[6] * this.p20;
            da[86] = da[6] * this.p30;
            da[87] = da[6] * this.p40;
            int ikp = 62;
            int ikpm = 67;
            double c2fi = 1.0 - this.p10mg * this.p10mg;
            double dkp = this.akp[1] + (a[62] + c2fi * a[63]) * this.akp[2];
            double dakp = a[7] + a[8] * this.p20mg + a[68] * this.p40mg + 2.0 * dkp * (a[60] + a[61] * this.p20mg + a[75] * 2.0 * dkp * dkp);
            da[62] = dakp * this.akp[2];
            da[63] = da[62] * c2fi;
            double dkpm = this.akp[3] + a[67] * this.akp[4];
            double dakpm = a[64] + a[65] * this.p20mg + a[72] * this.p40mg + 2.0 * dkpm * (a[66] + a[73] * this.p20mg + a[76] * 2.0 * dkpm * dkpm);
            da[67] = dakpm * this.akp[4];
            da[7] = dkp;
            da[8] = this.p20mg * dkp;
            da[68] = this.p40mg * dkp;
            da[60] = dkp * dkp;
            da[61] = this.p20mg * da[60];
            da[75] = da[60] * da[60];
            da[64] = dkpm;
            da[65] = this.p20mg * dkpm;
            da[72] = this.p40mg * dkpm;
            da[66] = dkpm * dkpm;
            da[73] = this.p20mg * da[66];
            da[76] = da[66] * da[66];
            double f0 = a[4] * da[4] + a[5] * da[5] + a[6] * da[6] + a[69] * da[69] + a[82] * da[82] + a[83] * da[83] + a[84] * da[84] + a[85] * da[85] + a[86] * da[86] + a[87] * da[87];
            double f1f = 1.0 + f0 * (double)ff0;
            f0 = f0 + a[2] * da[2] + a[3] * da[3] + a74 * da[74] + a77 * da[77] + a[7] * da[7] + a[8] * da[8] + a[60] * da[60] + a[61] * da[61] + a[68] * da[68] + a[64] * da[64] + a[65] * da[65] + a[66] * da[66] + a[72] * da[72] + a[73] * da[73] + a[75] * da[75] + a[76] * da[76] + a78 * da[78] + a[79] * da[79];
            da[9] = FastMath.cos((double)(0.017214206 * ((double)this.day - a[11])));
            da[10] = this.p20 * da[9];
            da[12] = FastMath.cos((double)(0.034428412 * ((double)this.day - a[14])));
            da[13] = this.p20 * da[12];
            double coste = FastMath.cos((double)(0.017214206 * ((double)this.day - a[18])));
            da[15] = this.p10 * coste;
            da[16] = this.p30 * coste;
            da[17] = this.p50 * coste;
            double cos2te = FastMath.cos((double)(0.034428412 * ((double)this.day - a[20])));
            da[19] = this.p10 * cos2te;
            da[39] = this.p30 * cos2te;
            da[59] = this.p50 * cos2te;
            da[21] = this.p11 * this.ch;
            da[22] = this.p31 * this.ch;
            da[23] = this.p51 * this.ch;
            da[24] = da[21] * coste;
            da[25] = this.p21 * this.ch * coste;
            da[26] = this.p11 * this.sh;
            da[27] = this.p31 * this.sh;
            da[28] = this.p51 * this.sh;
            da[29] = da[26] * coste;
            da[30] = this.p21 * this.sh * coste;
            da[31] = this.p22 * this.c2h;
            da[37] = this.p42 * this.c2h;
            da[32] = this.p32 * this.c2h * coste;
            da[33] = this.p22 * this.s2h;
            da[38] = this.p42 * this.s2h;
            da[34] = this.p32 * this.s2h * coste;
            da[88] = this.p32 * this.c2h;
            da[89] = this.p32 * this.s2h;
            da[90] = this.p52 * this.c2h;
            da[91] = this.p52 * this.s2h;
            double a88 = a[88];
            double a89 = a[89];
            double a90 = a[90];
            double a91 = a[91];
            if (kle_eq == -1) {
                a88 = -a88;
                a89 = -a89;
                a90 = -a90;
                a91 = -a91;
            }
            if (kle_eq == 0) {
                a88 = this.semestrialCorrection(a88);
                a89 = this.semestrialCorrection(a89);
                a90 = this.semestrialCorrection(a90);
                a91 = this.semestrialCorrection(a91);
            }
            da[92] = this.p62 * this.c2h;
            da[93] = this.p62 * this.s2h;
            da[35] = this.p33 * this.c3h;
            da[36] = this.p33 * this.s3h;
            double fp = a[9] * da[9] + a[10] * da[10] + a[12] * da[12] + a[13] * da[13] + a[15] * da[15] + a[16] * da[16] + a[17] * da[17] + a[19] * da[19] + a[21] * da[21] + a[22] * da[22] + a[23] * da[23] + a[24] * da[24] + a[25] * da[25] + a[26] * da[26] + a[27] * da[27] + a[28] * da[28] + a[29] * da[29] + a[30] * da[30] + a[31] * da[31] + a[32] * da[32] + a[33] * da[33] + a[34] * da[34] + a[35] * da[35] + a[36] * da[36] + a[37] * da[37] + a[38] * da[38] + a[39] * da[39] + a[59] * da[59] + a88 * da[88] + a89 * da[89] + a90 * da[90] + a91 * da[91] + a[92] * da[92] + a[93] * da[93];
            da[40] = this.p10 * coste * dkp;
            da[41] = this.p30 * coste * dkp;
            da[42] = this.p50 * coste * dkp;
            da[43] = this.p11 * this.ch * dkp;
            da[44] = this.p31 * this.ch * dkp;
            da[45] = this.p51 * this.ch * dkp;
            da[46] = this.p11 * this.sh * dkp;
            da[47] = this.p31 * this.sh * dkp;
            da[48] = this.p51 * this.sh * dkp;
            fp += a[40] * da[40] + a[41] * da[41] + a[42] * da[42] + a[43] * da[43] + a[44] * da[44] + a[45] * da[45] + a[46] * da[46] + a[47] * da[47] + a[48] * da[48];
            dakp = (a[40] * this.p10 + a[41] * this.p30 + a[42] * this.p50) * coste + (a[43] * this.p11 + a[44] * this.p31 + a[45] * this.p51) * this.ch + (a[46] * this.p11 + a[47] * this.p31 + a[48] * this.p51) * this.sh;
            da[62] = da[62] + dakp * this.akp[2];
            da[63] = da[62] + dakp * c2fi * this.akp[2];
            da[49] = this.p11 * this.clfl;
            da[50] = this.p21 * this.clfl;
            da[51] = this.p31 * this.clfl;
            da[52] = this.p41 * this.clfl;
            da[53] = this.p51 * this.clfl;
            da[54] = this.p11 * this.slfl;
            da[55] = this.p21 * this.slfl;
            da[56] = this.p31 * this.slfl;
            da[57] = this.p41 * this.slfl;
            da[58] = this.p51 * this.slfl;
            return f0 + (fp += a[49] * da[49] + a[50] * da[50] + a[51] * da[51] + a[52] * da[52] + a[53] * da[53] + a[54] * da[54] + a[55] * da[55] + a[56] * da[56] + a[57] * da[57] + a[58] * da[58]) * f1f;
        }

        private double semestrialCorrection(double param) {
            double result;
            int debeq_pr = 59;
            int debeq_au = 244;
            if (this.day >= 100) {
                double xmult = (double)(this.day - 244) / 40.0;
                result = param - 2.0 * param * xmult;
            } else {
                double xmult = (double)(this.day - 59) / 40.0;
                result = 2.0 * param * xmult - param;
            }
            return result;
        }
    }
}

