/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.bodies.CelestialBody;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

class TwoBodiesBaryTransformProvider
implements TransformProvider {
    private static final long serialVersionUID = 20190726L;
    private final Frame frame;
    private final CelestialBody primaryBody;
    private final CelestialBody secondaryBody;

    TwoBodiesBaryTransformProvider(CelestialBody primaryBody, CelestialBody secondaryBody) {
        this.primaryBody = primaryBody;
        this.secondaryBody = secondaryBody;
        this.frame = primaryBody.getInertiallyOrientedFrame();
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        TimeStampedPVCoordinates pv21 = this.secondaryBody.getPVCoordinates(date, this.frame);
        double massRatio = this.secondaryBody.getGM() / (this.primaryBody.getGM() + this.secondaryBody.getGM());
        Vector3D translation = pv21.getPosition().scalarMultiply(massRatio).negate();
        return new Transform(date, translation);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        TimeStampedFieldPVCoordinates<T> pv21 = this.secondaryBody.getPVCoordinates(date, this.frame);
        double massRatio = this.secondaryBody.getGM() / (this.primaryBody.getGM() + this.secondaryBody.getGM());
        FieldVector3D translation = pv21.getPosition().scalarMultiply(massRatio).negate();
        return new FieldTransform<T>(date, translation);
    }
}

