/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.general;

import java.util.stream.Stream;
import org.hipparchus.exception.Localizable;
import org.orekit.attitudes.InertialProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.general.EphemerisFile;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ImmutableTimeStampedCache;
import org.orekit.utils.TimeStampedPVCoordinates;

class EphemerisSegmentPropagator
extends AbstractAnalyticalPropagator
implements BoundedPropagator {
    private final ImmutableTimeStampedCache<TimeStampedPVCoordinates> cache;
    private final EphemerisFile.EphemerisSegment ephemeris;
    private final Frame inertialFrame;
    private final Frame ephemerisFrame;

    EphemerisSegmentPropagator(EphemerisFile.EphemerisSegment ephemeris) {
        super(new InertialProvider(ephemeris.getInertialFrame()));
        this.cache = new ImmutableTimeStampedCache<TimeStampedPVCoordinates>(ephemeris.getInterpolationSamples(), ephemeris.getCoordinates());
        this.ephemeris = ephemeris;
        this.ephemerisFrame = ephemeris.getFrame();
        this.inertialFrame = ephemeris.getInertialFrame();
        TimeStampedPVCoordinates ic = this.cache.getEarliest();
        TimeStampedPVCoordinates icInertial = this.ephemerisFrame.getTransformTo(this.inertialFrame, ic.getDate()).transformPVCoordinates(ic);
        super.resetInitialState(new SpacecraftState((Orbit)new CartesianOrbit(icInertial, this.inertialFrame, ephemeris.getMu()), this.getAttitudeProvider().getAttitude(icInertial.toTaylorProvider(this.inertialFrame), ic.getDate(), this.inertialFrame), 1000.0));
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
        Stream<TimeStampedPVCoordinates> neighbors = this.cache.getNeighbors(date);
        TimeStampedPVCoordinates point = TimeStampedPVCoordinates.interpolate(date, this.ephemeris.getAvailableDerivatives(), neighbors);
        return this.ephemerisFrame.getTransformTo(frame, date).transformPVCoordinates(point);
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        TimeStampedPVCoordinates pv = this.getPVCoordinates(date, this.inertialFrame);
        return new CartesianOrbit(pv, this.inertialFrame, this.ephemeris.getMu());
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.ephemeris.getStart();
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.ephemeris.getStop();
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return 1000.0;
    }

    @Override
    public SpacecraftState getInitialState() {
        return this.basicPropagate(this.getMinDate());
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }
}

