/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import org.hipparchus.RealFieldElement;
import org.orekit.bodies.CelestialBody;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

public class CcsdsModifiedFrame
extends Frame {
    private static final long serialVersionUID = 20170619L;
    private final String refFrame;
    private final String centerName;

    CcsdsModifiedFrame(Frame frame, String refFrame, CelestialBody body, String centerName) {
        super(frame, new OriginTransformProvider(body, frame), body.getName() + "/" + frame.getName(), frame.isPseudoInertial());
        this.refFrame = refFrame;
        this.centerName = centerName;
    }

    public String getRefFrame() {
        return this.refFrame;
    }

    public String getCenterName() {
        return this.centerName;
    }

    private static class OriginTransformProvider
    implements TransformProvider {
        private static final long serialVersionUID = 20170619L;
        private final CelestialBody body;
        private final Frame frame;

        OriginTransformProvider(CelestialBody body, Frame frame) {
            this.body = body;
            this.frame = frame;
        }

        @Override
        public Transform getTransform(AbsoluteDate date) {
            return new Transform(date, this.body.getPVCoordinates(date, this.frame).negate());
        }

        @Override
        public <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
            return new FieldTransform<T>(date, this.body.getPVCoordinates(date, this.frame).negate());
        }
    }
}

