/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.AEMFile;
import org.orekit.files.ccsds.Keyword;
import org.orekit.files.ccsds.StreamingAemWriter;
import org.orekit.time.TimeScale;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class AEMWriter {
    private final String originator;
    private final String spaceObjectId;
    private final String spaceObjectName;

    public AEMWriter() {
        this("OREKIT", null, null);
    }

    public AEMWriter(String originator, String spaceObjectId, String spaceObjectName) {
        this.originator = originator;
        this.spaceObjectId = spaceObjectId;
        this.spaceObjectName = spaceObjectName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(Appendable writer, AEMFile aemFile) throws IOException {
        String idToProcess;
        if (writer == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NULL_ARGUMENT, "writer");
        }
        if (aemFile == null) {
            return;
        }
        if (this.spaceObjectId != null) {
            if (!aemFile.getSatellites().containsKey(this.spaceObjectId)) throw new OrekitIllegalArgumentException(OrekitMessages.VALUE_NOT_FOUND, this.spaceObjectId, "ephemerisFile");
            idToProcess = this.spaceObjectId;
        } else {
            if (aemFile.getSatellites().keySet().size() != 1) throw new OrekitIllegalArgumentException(OrekitMessages.EPHEMERIS_FILE_NO_MULTI_SUPPORT, new Object[0]);
            idToProcess = aemFile.getSatellites().keySet().iterator().next();
        }
        AEMFile.AemSatelliteEphemeris satEphem = aemFile.getSatellites().get(idToProcess);
        List<AEMFile.AttitudeEphemeridesBlock> segments = satEphem.getSegments();
        if (segments.isEmpty()) {
            return;
        }
        AEMFile.AttitudeEphemeridesBlock firstSegment = segments.get(0);
        String objectName = this.spaceObjectName == null ? idToProcess : this.spaceObjectName;
        TimeScale timeScale = firstSegment.getTimeScale();
        LinkedHashMap<Keyword, String> metadata = new LinkedHashMap<Keyword, String>();
        metadata.put(Keyword.TIME_SYSTEM, firstSegment.getTimeScaleString());
        metadata.put(Keyword.ORIGINATOR, this.originator);
        metadata.put(Keyword.OBJECT_NAME, objectName);
        metadata.put(Keyword.OBJECT_ID, idToProcess);
        StreamingAemWriter aemWriter = new StreamingAemWriter(writer, timeScale, metadata);
        aemWriter.writeHeader();
        for (AEMFile.AttitudeEphemeridesBlock segment : segments) {
            metadata.clear();
            metadata.put(Keyword.CENTER_NAME, segment.getFrameCenterString());
            metadata.put(Keyword.REF_FRAME_A, segment.getRefFrameAString());
            metadata.put(Keyword.REF_FRAME_B, segment.getRefFrameBString());
            metadata.put(Keyword.ATTITUDE_DIR, segment.getAttitudeDirection());
            metadata.put(Keyword.START_TIME, segment.getStart().toString(timeScale));
            metadata.put(Keyword.STOP_TIME, segment.getStop().toString(timeScale));
            metadata.put(Keyword.ATTITUDE_TYPE, segment.getAttitudeType());
            metadata.put(Keyword.INTERPOLATION_METHOD, segment.getInterpolationMethod());
            metadata.put(Keyword.INTERPOLATION_DEGREE, String.valueOf(segment.getInterpolationDegree()));
            StreamingAemWriter.AEMSegment segmentWriter = aemWriter.newSegment(metadata);
            segmentWriter.writeMetadata();
            segmentWriter.startAttitudeBlock();
            for (TimeStampedAngularCoordinates coordinates : segment.getAngularCoordinates()) {
                segmentWriter.writeAttitudeEphemerisLine(coordinates, segment.isFirst(), segment.getAttitudeType(), segment.getRotationOrder());
            }
            segmentWriter.endAttitudeBlock();
        }
    }

    public void write(String outputFilePath, AEMFile aemFile) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(outputFilePath, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
            this.write(writer, aemFile);
        }
    }
}

