/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.InertialProvider;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.gnss.Phase;
import org.orekit.estimation.measurements.modifiers.TroposphericGradientConverter;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.Differentiation;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterFunction;

public class PhaseTroposphericDelayModifier
implements EstimationModifier<Phase> {
    private final DiscreteTroposphericModel tropoModel;

    public PhaseTroposphericDelayModifier(DiscreteTroposphericModel model) {
        this.tropoModel = model;
    }

    private double getStationHeightAMSL(GroundStation station) {
        double height = station.getBaseFrame().getPoint().getAltitude();
        return height;
    }

    private <T extends RealFieldElement<T>> T getStationHeightAMSL(Field<T> field, GroundStation station) {
        T height = station.getBaseFrame().getPoint(field).getAltitude();
        return height;
    }

    private double phaseErrorTroposphericModel(GroundStation station, SpacecraftState state, double wavelength) {
        Vector3D position = state.getPVCoordinates().getPosition();
        double elevation = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (elevation > 0.0) {
            double height = this.getStationHeightAMSL(station);
            double delay = this.tropoModel.pathDelay(elevation, height, this.tropoModel.getParameters(), state.getDate());
            return delay / wavelength;
        }
        return 0.0;
    }

    private <T extends RealFieldElement<T>> T phaseErrorTroposphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters, double wavelength) {
        Field<T> field = state.getDate().getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        FieldVector3D position = state.getPVCoordinates().getPosition();
        Object elevation = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (elevation.getReal() > 0.0) {
            T height = this.getStationHeightAMSL(field, station);
            RealFieldElement delay = this.tropoModel.pathDelay((RealFieldElement)elevation, (RealFieldElement)height, (RealFieldElement[])parameters, state.getDate());
            return (T)((RealFieldElement)delay.divide(wavelength));
        }
        return (T)zero;
    }

    private double[][] phaseErrorJacobianState(double[] derivatives) {
        double[][] finiteDifferencesJacobian = new double[1][6];
        System.arraycopy(derivatives, 0, finiteDifferencesJacobian[0], 0, 6);
        return finiteDifferencesJacobian;
    }

    private double phaseErrorParameterDerivative(GroundStation station, ParameterDriver driver, SpacecraftState state, double wavelength) {
        ParameterFunction rangeError = parameterDriver -> this.phaseErrorTroposphericModel(station, state, wavelength);
        ParameterFunction phaseErrorDerivative = Differentiation.differentiate(rangeError, 3, 10.0 * driver.getScale());
        return phaseErrorDerivative.value(driver);
    }

    private double[] phaseErrorParameterDerivative(double[] derivatives, int freeStateParameters) {
        int dim = derivatives.length - freeStateParameters;
        double[] rangeError = new double[dim];
        for (int i = 0; i < dim; ++i) {
            rangeError[i] = derivatives[freeStateParameters + i];
        }
        return rangeError;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.tropoModel.getParametersDrivers();
    }

    @Override
    public void modify(EstimatedMeasurement<Phase> estimated) {
        double parameterDerivative;
        Phase measurement = estimated.getObservedMeasurement();
        GroundStation station = measurement.getStation();
        SpacecraftState state = estimated.getStates()[0];
        double[] oldValue = estimated.getEstimatedValue();
        TroposphericGradientConverter converter = new TroposphericGradientConverter(state, 6, new InertialProvider(state.getFrame()));
        FieldSpacecraftState<Gradient> gState = converter.getState(this.tropoModel);
        Gradient[] gParameters = converter.getParameters(gState, this.tropoModel);
        Gradient gDelay = (Gradient)this.phaseErrorTroposphericModel(station, gState, (RealFieldElement[])gParameters, measurement.getWavelength());
        double[] derivatives = gDelay.getGradient();
        double[][] djac = this.phaseErrorJacobianState(derivatives);
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int irow = 0; irow < stateDerivatives.length; ++irow) {
            for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
                double[] dArray = stateDerivatives[irow];
                int n = jcol;
                dArray[n] = dArray[n] + djac[irow][jcol];
            }
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        int index = 0;
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            double[] dDelaydP = this.phaseErrorParameterDerivative(derivatives, converter.getFreeStateParameters());
            estimated.setParameterDerivatives(driver, parameterDerivative += dDelaydP[index]);
            ++index;
        }
        for (ParameterDriver driver : Arrays.asList(station.getClockOffsetDriver(), station.getEastOffsetDriver(), station.getNorthOffsetDriver(), station.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += this.phaseErrorParameterDerivative(station, driver, state, measurement.getWavelength()));
        }
        double[] newValue = (double[])oldValue.clone();
        newValue[0] = newValue[0] + gDelay.getReal();
        estimated.setEstimatedValue(newValue);
    }
}

