/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.Parameterizable;

public abstract class AbstractParameterizable
implements Parameterizable {
    private final List<String> parametersNames = new ArrayList<String>();

    protected AbstractParameterizable(String ... names) {
        for (String name : names) {
            this.parametersNames.add(name);
        }
    }

    protected AbstractParameterizable(Collection<String> names) {
        this.parametersNames.addAll(names);
    }

    @Override
    public List<String> getParametersNames() {
        return this.parametersNames;
    }

    @Override
    public boolean isSupported(String name) {
        for (String supportedName : this.parametersNames) {
            if (!supportedName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void complainIfNotSupported(String name) throws MathIllegalArgumentException {
        if (!this.isSupported(name)) {
            throw new MathIllegalArgumentException((Localizable)LocalizedODEFormats.UNKNOWN_PARAMETER, new Object[]{name});
        }
    }
}

