/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.exception;

import java.text.MessageFormat;
import java.util.Locale;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.LocalizedException;

public class NullArgumentException
extends NullPointerException
implements LocalizedException {
    private static final long serialVersionUID = 20160217L;
    private final Localizable specifier;
    private final Object[] parts;

    public NullArgumentException() {
        this(LocalizedCoreFormats.NULL_NOT_ALLOWED, new Object[0]);
    }

    public NullArgumentException(Localizable specifier, Object ... parts) {
        this.specifier = specifier;
        this.parts = parts == null ? new Object[]{} : (Object[])parts.clone();
    }

    @Override
    public String getMessage(Locale locale) {
        return NullArgumentException.buildMessage(locale, this.specifier, this.parts);
    }

    @Override
    public String getMessage() {
        return this.getMessage(Locale.US);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage(Locale.getDefault());
    }

    @Override
    public Localizable getSpecifier() {
        return this.specifier;
    }

    @Override
    public Object[] getParts() {
        return (Object[])this.parts.clone();
    }

    private static String buildMessage(Locale locale, Localizable specifier, Object ... parts) {
        return specifier == null ? "" : new MessageFormat(specifier.getLocalizedString(locale), locale).format(parts);
    }
}

