/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative1;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldEquinoctialOrbit<T extends RealFieldElement<T>>
extends FieldOrbit<T> {
    private final T a;
    private final T ex;
    private final T ey;
    private final T hx;
    private final T hy;
    private final T lv;
    private final T aDot;
    private final T exDot;
    private final T eyDot;
    private final T hxDot;
    private final T hyDot;
    private final T lvDot;
    private FieldPVCoordinates<T> partialPV;
    private Field<T> field;
    private T zero;
    private T one;

    public FieldEquinoctialOrbit(T a, T ex, T ey, T hx, T hy, T l, PositionAngle type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(a, ex, ey, hx, hy, l, null, null, null, null, null, null, type, frame, (FieldAbsoluteDate<Object>)date, mu);
    }

    public FieldEquinoctialOrbit(T a, T ex, T ey, T hx, T hy, T l, T aDot, T exDot, T eyDot, T hxDot, T hyDot, T lDot, PositionAngle type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        super(frame, date, mu);
        this.field = a.getField();
        this.zero = (RealFieldElement)this.field.getZero();
        this.one = (RealFieldElement)this.field.getOne();
        if (ex.getReal() * ex.getReal() + ey.getReal() * ey.getReal() >= 1.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.HYPERBOLIC_ORBIT_NOT_HANDLED_AS, this.getClass().getName());
        }
        this.a = a;
        this.aDot = aDot;
        this.ex = ex;
        this.exDot = exDot;
        this.ey = ey;
        this.eyDot = eyDot;
        this.hx = hx;
        this.hxDot = hxDot;
        this.hy = hy;
        this.hyDot = hyDot;
        if (this.hasDerivatives()) {
            FieldUnivariateDerivative1 lvUD;
            FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(ex, exDot);
            FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(ey, eyDot);
            FieldUnivariateDerivative1 lUD = new FieldUnivariateDerivative1(l, lDot);
            switch (type) {
                case MEAN: {
                    lvUD = FieldEquinoctialOrbit.eccentricToTrue(FieldEquinoctialOrbit.meanToEccentric(lUD, exUD, eyUD), exUD, eyUD);
                    break;
                }
                case ECCENTRIC: {
                    lvUD = FieldEquinoctialOrbit.eccentricToTrue(lUD, exUD, eyUD);
                    break;
                }
                case TRUE: {
                    lvUD = lUD;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.lv = lvUD.getValue();
            this.lvDot = lvUD.getDerivative(1);
        } else {
            switch (type) {
                case MEAN: {
                    this.lv = FieldEquinoctialOrbit.eccentricToTrue(FieldEquinoctialOrbit.meanToEccentric(l, ex, ey), ex, ey);
                    break;
                }
                case ECCENTRIC: {
                    this.lv = FieldEquinoctialOrbit.eccentricToTrue(l, ex, ey);
                    break;
                }
                case TRUE: {
                    this.lv = l;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.lvDot = null;
        }
        this.partialPV = null;
    }

    public FieldEquinoctialOrbit(TimeStampedFieldPVCoordinates<T> pvCoordinates, Frame frame, T mu) throws IllegalArgumentException {
        super(pvCoordinates, frame, mu);
        this.field = pvCoordinates.getPosition().getX().getField();
        this.zero = (RealFieldElement)this.field.getZero();
        this.one = (RealFieldElement)this.field.getOne();
        FieldVector3D pvP = pvCoordinates.getPosition();
        FieldVector3D pvV = pvCoordinates.getVelocity();
        FieldVector3D pvA = pvCoordinates.getAcceleration();
        RealFieldElement r2 = pvP.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        RealFieldElement V2 = pvV.getNormSq();
        RealFieldElement rV2OnMu = (RealFieldElement)((RealFieldElement)r.multiply((Object)V2)).divide(mu);
        if (rV2OnMu.getReal() > 2.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.HYPERBOLIC_ORBIT_NOT_HANDLED_AS, this.getClass().getName());
        }
        FieldVector3D w = pvCoordinates.getMomentum().normalize();
        RealFieldElement d = (RealFieldElement)this.one.divide(this.one.add((Object)w.getZ()));
        this.hx = (RealFieldElement)((RealFieldElement)d.negate()).multiply((Object)w.getY());
        this.hy = (RealFieldElement)d.multiply((Object)w.getX());
        RealFieldElement cLv = (RealFieldElement)((RealFieldElement)pvP.getX().subtract(((RealFieldElement)d.multiply((Object)pvP.getZ())).multiply((Object)w.getX()))).divide((Object)r);
        RealFieldElement sLv = (RealFieldElement)((RealFieldElement)pvP.getY().subtract(((RealFieldElement)d.multiply((Object)pvP.getZ())).multiply((Object)w.getY()))).divide((Object)r);
        this.lv = (RealFieldElement)sLv.atan2((Object)cLv);
        this.a = (RealFieldElement)r.divide(((RealFieldElement)rV2OnMu.negate()).add(2.0));
        RealFieldElement eSE = (RealFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(((RealFieldElement)this.a.multiply(mu)).sqrt());
        RealFieldElement eCE = (RealFieldElement)rV2OnMu.subtract(1.0);
        RealFieldElement e2 = (RealFieldElement)((RealFieldElement)eCE.multiply((Object)eCE)).add(eSE.multiply((Object)eSE));
        RealFieldElement f = (RealFieldElement)eCE.subtract((Object)e2);
        RealFieldElement g = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)e2.negate()).add(1.0)).sqrt()).multiply((Object)eSE);
        this.ex = (RealFieldElement)((RealFieldElement)this.a.multiply(((RealFieldElement)f.multiply((Object)cLv)).add(g.multiply((Object)sLv)))).divide((Object)r);
        this.ey = (RealFieldElement)((RealFieldElement)this.a.multiply(((RealFieldElement)f.multiply((Object)sLv)).subtract(g.multiply((Object)cLv)))).divide((Object)r);
        this.partialPV = pvCoordinates;
        if (FieldEquinoctialOrbit.hasNonKeplerianAcceleration(pvCoordinates, mu)) {
            RealFieldElement[][] jacobian = (RealFieldElement[][])MathArrays.buildArray((Field)this.a.getField(), (int)6, (int)6);
            this.getJacobianWrtCartesian(PositionAngle.MEAN, jacobian);
            FieldVector3D keplerianAcceleration = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)r.multiply((Object)r2)).reciprocal()).multiply(mu.negate()), pvP);
            FieldVector3D nonKeplerianAcceleration = pvA.subtract(keplerianAcceleration);
            RealFieldElement aX = nonKeplerianAcceleration.getX();
            RealFieldElement aY = nonKeplerianAcceleration.getY();
            RealFieldElement aZ = nonKeplerianAcceleration.getZ();
            this.aDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)jacobian[0][3].multiply((Object)aX)).add(jacobian[0][4].multiply((Object)aY))).add(jacobian[0][5].multiply((Object)aZ));
            this.exDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)jacobian[1][3].multiply((Object)aX)).add(jacobian[1][4].multiply((Object)aY))).add(jacobian[1][5].multiply((Object)aZ));
            this.eyDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)jacobian[2][3].multiply((Object)aX)).add(jacobian[2][4].multiply((Object)aY))).add(jacobian[2][5].multiply((Object)aZ));
            this.hxDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)jacobian[3][3].multiply((Object)aX)).add(jacobian[3][4].multiply((Object)aY))).add(jacobian[3][5].multiply((Object)aZ));
            this.hyDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)jacobian[4][3].multiply((Object)aX)).add(jacobian[4][4].multiply((Object)aY))).add(jacobian[4][5].multiply((Object)aZ));
            RealFieldElement lMDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.getKeplerianMeanMotion().add(jacobian[5][3].multiply((Object)aX))).add(jacobian[5][4].multiply((Object)aY))).add(jacobian[5][5].multiply((Object)aZ));
            FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
            FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
            FieldUnivariateDerivative1 lMUD = new FieldUnivariateDerivative1(this.getLM(), lMDot);
            FieldUnivariateDerivative1 lvUD = FieldEquinoctialOrbit.eccentricToTrue(FieldEquinoctialOrbit.meanToEccentric(lMUD, exUD, eyUD), exUD, eyUD);
            this.lvDot = lvUD.getDerivative(1);
        } else {
            this.aDot = null;
            this.exDot = null;
            this.eyDot = null;
            this.hxDot = null;
            this.hyDot = null;
            this.lvDot = null;
        }
    }

    public FieldEquinoctialOrbit(FieldPVCoordinates<T> pvCoordinates, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(new TimeStampedFieldPVCoordinates<T>(date, pvCoordinates), frame, mu);
    }

    public FieldEquinoctialOrbit(FieldOrbit<T> op) {
        super(op.getFrame(), op.getDate(), op.getMu());
        this.a = op.getA();
        this.ex = op.getEquinoctialEx();
        this.ey = op.getEquinoctialEy();
        this.hx = op.getHx();
        this.hy = op.getHy();
        this.lv = op.getLv();
        this.aDot = op.getADot();
        this.exDot = op.getEquinoctialExDot();
        this.eyDot = op.getEquinoctialEyDot();
        this.hxDot = op.getHxDot();
        this.hyDot = op.getHyDot();
        this.lvDot = op.getLvDot();
        this.field = this.a.getField();
        this.zero = (RealFieldElement)this.field.getZero();
        this.one = (RealFieldElement)this.field.getOne();
    }

    @Override
    public OrbitType getType() {
        return OrbitType.EQUINOCTIAL;
    }

    @Override
    public T getA() {
        return this.a;
    }

    @Override
    public T getADot() {
        return this.aDot;
    }

    @Override
    public T getEquinoctialEx() {
        return this.ex;
    }

    @Override
    public T getEquinoctialExDot() {
        return this.exDot;
    }

    @Override
    public T getEquinoctialEy() {
        return this.ey;
    }

    @Override
    public T getEquinoctialEyDot() {
        return this.eyDot;
    }

    @Override
    public T getHx() {
        return this.hx;
    }

    @Override
    public T getHxDot() {
        return this.hxDot;
    }

    @Override
    public T getHy() {
        return this.hy;
    }

    @Override
    public T getHyDot() {
        return this.hyDot;
    }

    @Override
    public T getLv() {
        return this.lv;
    }

    @Override
    public T getLvDot() {
        return this.lvDot;
    }

    @Override
    public T getLE() {
        return FieldEquinoctialOrbit.trueToEccentric(this.lv, this.ex, this.ey);
    }

    @Override
    public T getLEDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FieldUnivariateDerivative1 lVUD = new FieldUnivariateDerivative1(this.lv, this.lvDot);
        FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
        FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
        FieldUnivariateDerivative1 lEUD = FieldEquinoctialOrbit.trueToEccentric(lVUD, exUD, eyUD);
        return (T)lEUD.getDerivative(1);
    }

    @Override
    public T getLM() {
        return FieldEquinoctialOrbit.eccentricToMean(FieldEquinoctialOrbit.trueToEccentric(this.lv, this.ex, this.ey), this.ex, this.ey);
    }

    @Override
    public T getLMDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FieldUnivariateDerivative1 lVUD = new FieldUnivariateDerivative1(this.lv, this.lvDot);
        FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
        FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
        FieldUnivariateDerivative1 lMUD = FieldEquinoctialOrbit.eccentricToMean(FieldEquinoctialOrbit.trueToEccentric(lVUD, exUD, eyUD), exUD, eyUD);
        return (T)lMUD.getDerivative(1);
    }

    public T getL(PositionAngle type) {
        return type == PositionAngle.MEAN ? this.getLM() : (type == PositionAngle.ECCENTRIC ? this.getLE() : this.getLv());
    }

    public T getLDot(PositionAngle type) {
        return type == PositionAngle.MEAN ? this.getLMDot() : (type == PositionAngle.ECCENTRIC ? this.getLEDot() : this.getLvDot());
    }

    @Override
    public boolean hasDerivatives() {
        return this.aDot != null;
    }

    public static <T extends RealFieldElement<T>> T eccentricToTrue(T lE, T ex, T ey) {
        RealFieldElement epsilon = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)ex.multiply(ex)).add(ey.multiply(ey))).negate()).add(1.0)).sqrt();
        RealFieldElement cosLE = (RealFieldElement)lE.cos();
        RealFieldElement sinLE = (RealFieldElement)lE.sin();
        RealFieldElement num = (RealFieldElement)((RealFieldElement)ex.multiply((Object)sinLE)).subtract(ey.multiply((Object)cosLE));
        RealFieldElement den = (RealFieldElement)((RealFieldElement)((RealFieldElement)epsilon.add(1.0)).subtract(ex.multiply((Object)cosLE))).subtract(ey.multiply((Object)sinLE));
        return (T)((RealFieldElement)lE.add(((RealFieldElement)((RealFieldElement)num.divide((Object)den)).atan()).multiply(2)));
    }

    public static <T extends RealFieldElement<T>> T trueToEccentric(T lv, T ex, T ey) {
        RealFieldElement epsilon = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)ex.multiply(ex)).add(ey.multiply(ey))).negate()).add(1.0)).sqrt();
        RealFieldElement cosLv = (RealFieldElement)lv.cos();
        RealFieldElement sinLv = (RealFieldElement)lv.sin();
        RealFieldElement num = (RealFieldElement)((RealFieldElement)ey.multiply((Object)cosLv)).subtract(ex.multiply((Object)sinLv));
        RealFieldElement den = (RealFieldElement)((RealFieldElement)((RealFieldElement)epsilon.add(1.0)).add(ex.multiply((Object)cosLv))).add(ey.multiply((Object)sinLv));
        return (T)((RealFieldElement)lv.add(((RealFieldElement)((RealFieldElement)num.divide((Object)den)).atan()).multiply(2)));
    }

    public static <T extends RealFieldElement<T>> T meanToEccentric(T lM, T ex, T ey) {
        Object lE = lM;
        RealFieldElement shift = (RealFieldElement)lM.getField().getZero();
        RealFieldElement lEmlM = (RealFieldElement)lM.getField().getZero();
        RealFieldElement cosLE = (RealFieldElement)lE.cos();
        RealFieldElement sinLE = (RealFieldElement)lE.sin();
        int iter = 0;
        do {
            RealFieldElement f2 = (RealFieldElement)((RealFieldElement)ex.multiply((Object)sinLE)).subtract(ey.multiply((Object)cosLE));
            RealFieldElement f1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)ex.multiply((Object)cosLE)).add(ey.multiply((Object)sinLE))).negate()).add(1.0);
            RealFieldElement f0 = (RealFieldElement)lEmlM.subtract((Object)f2);
            RealFieldElement f12 = (RealFieldElement)f1.multiply(2.0);
            shift = (RealFieldElement)((RealFieldElement)f0.multiply((Object)f12)).divide(((RealFieldElement)f1.multiply((Object)f12)).subtract(f0.multiply((Object)f2)));
            lEmlM = (RealFieldElement)lEmlM.subtract((Object)shift);
            lE = (RealFieldElement)lM.add((Object)lEmlM);
            cosLE = (RealFieldElement)lE.cos();
            sinLE = (RealFieldElement)lE.sin();
        } while (++iter < 50 && FastMath.abs((double)shift.getReal()) > 1.0E-12);
        return lE;
    }

    public static <T extends RealFieldElement<T>> T eccentricToMean(T lE, T ex, T ey) {
        return (T)((RealFieldElement)((RealFieldElement)lE.subtract(ex.multiply(lE.sin()))).add(ey.multiply(lE.cos())));
    }

    @Override
    public T getE() {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey))).sqrt());
    }

    @Override
    public T getEDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.ex.multiply(this.exDot)).add(this.ey.multiply(this.eyDot))).divide(((RealFieldElement)((RealFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey))).sqrt()));
    }

    @Override
    public T getI() {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.hx.multiply(this.hx)).add(this.hy.multiply(this.hy))).sqrt()).atan()).multiply(2));
    }

    @Override
    public T getIDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        RealFieldElement h2 = (RealFieldElement)((RealFieldElement)this.hx.multiply(this.hx)).add(this.hy.multiply(this.hy));
        RealFieldElement h = (RealFieldElement)h2.sqrt();
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.hx.multiply(this.hxDot)).add(this.hy.multiply(this.hyDot))).multiply(2)).divide(h.multiply(h2.add(1.0))));
    }

    private void computePVWithoutA() {
        if (this.partialPV != null) {
            return;
        }
        T lE = this.getLE();
        RealFieldElement hx2 = (RealFieldElement)this.hx.multiply(this.hx);
        RealFieldElement hy2 = (RealFieldElement)this.hy.multiply(this.hy);
        RealFieldElement factH = (RealFieldElement)this.one.divide(((RealFieldElement)hx2.add(1.0)).add((Object)hy2));
        RealFieldElement ux = (RealFieldElement)((RealFieldElement)((RealFieldElement)hx2.add(1.0)).subtract((Object)hy2)).multiply((Object)factH);
        RealFieldElement uy = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.hx.multiply(this.hy)).multiply((Object)factH)).multiply(2);
        RealFieldElement uz = (RealFieldElement)((RealFieldElement)this.hy.multiply(-2)).multiply((Object)factH);
        RealFieldElement vx = uy;
        RealFieldElement vy = (RealFieldElement)((RealFieldElement)((RealFieldElement)hy2.subtract((Object)hx2)).add(1.0)).multiply((Object)factH);
        RealFieldElement vz = (RealFieldElement)((RealFieldElement)this.hx.multiply((Object)factH)).multiply(2);
        RealFieldElement ex2 = (RealFieldElement)this.ex.multiply(this.ex);
        RealFieldElement exey = (RealFieldElement)this.ex.multiply(this.ey);
        RealFieldElement ey2 = (RealFieldElement)this.ey.multiply(this.ey);
        RealFieldElement e2 = (RealFieldElement)ex2.add((Object)ey2);
        RealFieldElement eta = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.one.subtract((Object)e2)).sqrt()).add(1.0);
        RealFieldElement beta = (RealFieldElement)this.one.divide((Object)eta);
        RealFieldElement cLe = (RealFieldElement)lE.cos();
        RealFieldElement sLe = (RealFieldElement)lE.sin();
        RealFieldElement exCeyS = (RealFieldElement)((RealFieldElement)this.ex.multiply((Object)cLe)).add(this.ey.multiply((Object)sLe));
        RealFieldElement x = (RealFieldElement)this.a.multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)this.one.subtract(beta.multiply((Object)ey2))).multiply((Object)cLe)).add(((RealFieldElement)beta.multiply((Object)exey)).multiply((Object)sLe))).subtract(this.ex));
        RealFieldElement y = (RealFieldElement)this.a.multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)this.one.subtract(beta.multiply((Object)ex2))).multiply((Object)sLe)).add(((RealFieldElement)beta.multiply((Object)exey)).multiply((Object)cLe))).subtract(this.ey));
        RealFieldElement factor = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.getMu().divide(this.a)).sqrt()).divide(this.one.subtract((Object)exCeyS));
        RealFieldElement xdot = (RealFieldElement)factor.multiply(((RealFieldElement)sLe.negate()).add(((RealFieldElement)beta.multiply(this.ey)).multiply((Object)exCeyS)));
        RealFieldElement ydot = (RealFieldElement)factor.multiply(cLe.subtract(((RealFieldElement)beta.multiply(this.ex)).multiply((Object)exCeyS)));
        FieldVector3D position = new FieldVector3D((RealFieldElement)((RealFieldElement)x.multiply((Object)ux)).add(y.multiply((Object)vx)), (RealFieldElement)((RealFieldElement)x.multiply((Object)uy)).add(y.multiply((Object)vy)), (RealFieldElement)((RealFieldElement)x.multiply((Object)uz)).add(y.multiply((Object)vz)));
        FieldVector3D velocity = new FieldVector3D((RealFieldElement)((RealFieldElement)xdot.multiply((Object)ux)).add(ydot.multiply((Object)vx)), (RealFieldElement)((RealFieldElement)xdot.multiply((Object)uy)).add(ydot.multiply((Object)vy)), (RealFieldElement)((RealFieldElement)xdot.multiply((Object)uz)).add(ydot.multiply((Object)vz)));
        this.partialPV = new FieldPVCoordinates(position, velocity);
    }

    private FieldVector3D<T> nonKeplerianAcceleration() {
        RealFieldElement[][] dCdP = (RealFieldElement[][])MathArrays.buildArray((Field)this.a.getField(), (int)6, (int)6);
        this.getJacobianWrtParameters(PositionAngle.MEAN, dCdP);
        RealFieldElement nonKeplerianMeanMotion = (RealFieldElement)this.getLMDot().subtract(this.getKeplerianMeanMotion());
        RealFieldElement nonKeplerianAx = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dCdP[3][0].multiply(this.aDot)).add(dCdP[3][1].multiply(this.exDot))).add(dCdP[3][2].multiply(this.eyDot))).add(dCdP[3][3].multiply(this.hxDot))).add(dCdP[3][4].multiply(this.hyDot))).add(dCdP[3][5].multiply((Object)nonKeplerianMeanMotion));
        RealFieldElement nonKeplerianAy = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dCdP[4][0].multiply(this.aDot)).add(dCdP[4][1].multiply(this.exDot))).add(dCdP[4][2].multiply(this.eyDot))).add(dCdP[4][3].multiply(this.hxDot))).add(dCdP[4][4].multiply(this.hyDot))).add(dCdP[4][5].multiply((Object)nonKeplerianMeanMotion));
        RealFieldElement nonKeplerianAz = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dCdP[5][0].multiply(this.aDot)).add(dCdP[5][1].multiply(this.exDot))).add(dCdP[5][2].multiply(this.eyDot))).add(dCdP[5][3].multiply(this.hxDot))).add(dCdP[5][4].multiply(this.hyDot))).add(dCdP[5][5].multiply((Object)nonKeplerianMeanMotion));
        return new FieldVector3D(nonKeplerianAx, nonKeplerianAy, nonKeplerianAz);
    }

    @Override
    protected TimeStampedFieldPVCoordinates<T> initPVCoordinates() {
        this.computePVWithoutA();
        RealFieldElement r2 = this.partialPV.getPosition().getNormSq();
        FieldVector3D keplerianAcceleration = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)r2.multiply(r2.sqrt())).reciprocal()).multiply(this.getMu().negate()), this.partialPV.getPosition());
        FieldVector3D acceleration = this.hasDerivatives() ? keplerianAcceleration.add(this.nonKeplerianAcceleration()) : keplerianAcceleration;
        return new TimeStampedFieldPVCoordinates(this.getDate(), this.partialPV.getPosition(), this.partialPV.getVelocity(), acceleration);
    }

    @Override
    public FieldEquinoctialOrbit<T> shiftedBy(double dt) {
        return this.shiftedBy((RealFieldElement)((RealFieldElement)this.getDate().getField().getZero()).add(dt));
    }

    @Override
    public FieldEquinoctialOrbit<T> shiftedBy(T dt) {
        FieldEquinoctialOrbit<RealFieldElement> keplerianShifted = new FieldEquinoctialOrbit<RealFieldElement>((RealFieldElement)this.a, (RealFieldElement)this.ex, (RealFieldElement)this.ey, (RealFieldElement)this.hx, (RealFieldElement)this.hy, (RealFieldElement)this.getLM().add(this.getKeplerianMeanMotion().multiply(dt)), PositionAngle.MEAN, this.getFrame(), this.getDate().shiftedBy(dt), (RealFieldElement)this.getMu());
        if (this.hasDerivatives()) {
            FieldVector3D<T> nonKeplerianAcceleration = this.nonKeplerianAcceleration();
            super.computePVWithoutA();
            FieldVector3D fixedP = new FieldVector3D(this.one, keplerianShifted.partialPV.getPosition(), (RealFieldElement)((RealFieldElement)dt.multiply(dt)).multiply(0.5), nonKeplerianAcceleration);
            RealFieldElement fixedR2 = fixedP.getNormSq();
            RealFieldElement fixedR = (RealFieldElement)fixedR2.sqrt();
            FieldVector3D fixedV = new FieldVector3D(this.one, keplerianShifted.partialPV.getVelocity(), dt, nonKeplerianAcceleration);
            FieldVector3D fixedA = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)fixedR2.multiply((Object)fixedR)).reciprocal()).multiply(this.getMu().negate()), keplerianShifted.partialPV.getPosition(), this.one, nonKeplerianAcceleration);
            return new FieldEquinoctialOrbit(new TimeStampedFieldPVCoordinates(keplerianShifted.getDate(), fixedP, fixedV, fixedA), keplerianShifted.getFrame(), keplerianShifted.getMu());
        }
        return keplerianShifted;
    }

    @Override
    public FieldEquinoctialOrbit<T> interpolate(FieldAbsoluteDate<T> date, Stream<FieldOrbit<T>> sample) {
        List list = sample.collect(Collectors.toList());
        boolean useDerivatives = true;
        for (FieldOrbit orbit : list) {
            useDerivatives = useDerivatives && orbit.hasDerivatives();
        }
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        FieldAbsoluteDate previousDate = null;
        Object previousLm = (RealFieldElement)this.zero.add(Double.NaN);
        for (FieldOrbit orbit : list) {
            Object continuousLm;
            FieldEquinoctialOrbit equi = (FieldEquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(orbit);
            if (previousDate == null) {
                continuousLm = equi.getLM();
            } else {
                Object dt = equi.getDate().durationFrom(previousDate);
                RealFieldElement keplerLm = (RealFieldElement)previousLm.add((Object)((RealFieldElement)equi.getKeplerianMeanMotion().multiply(dt)));
                continuousLm = MathUtils.normalizeAngle(equi.getLM(), (RealFieldElement)keplerLm);
            }
            previousDate = equi.getDate();
            previousLm = continuousLm;
            RealFieldElement[] toAdd = (RealFieldElement[])MathArrays.buildArray(this.field, (int)6);
            toAdd[0] = equi.getA();
            toAdd[1] = equi.getEquinoctialEx();
            toAdd[2] = equi.getEquinoctialEy();
            toAdd[3] = equi.getHx();
            toAdd[4] = equi.getHy();
            toAdd[5] = continuousLm;
            if (useDerivatives) {
                RealFieldElement[] toAddDot = (RealFieldElement[])MathArrays.buildArray((Field)this.one.getField(), (int)6);
                toAddDot[0] = equi.getADot();
                toAddDot[1] = equi.getEquinoctialExDot();
                toAddDot[2] = equi.getEquinoctialEyDot();
                toAddDot[3] = equi.getHxDot();
                toAddDot[4] = equi.getHyDot();
                toAddDot[5] = equi.getLMDot();
                interpolator.addSamplePoint(equi.getDate().durationFrom(date), (FieldElement[][])new RealFieldElement[][]{toAdd, toAddDot});
                continue;
            }
            interpolator.addSamplePoint(equi.getDate().durationFrom(date), (FieldElement[][])new RealFieldElement[][]{toAdd});
        }
        RealFieldElement[][] interpolated = (RealFieldElement[][])interpolator.derivatives(this.zero, 1);
        return new FieldEquinoctialOrbit<RealFieldElement>(interpolated[0][0], interpolated[0][1], interpolated[0][2], interpolated[0][3], interpolated[0][4], interpolated[0][5], interpolated[1][0], interpolated[1][1], interpolated[1][2], interpolated[1][3], interpolated[1][4], interpolated[1][5], PositionAngle.MEAN, this.getFrame(), (FieldAbsoluteDate<RealFieldElement>)date, (RealFieldElement)this.getMu());
    }

    @Override
    protected T[][] computeJacobianMeanWrtCartesian() {
        RealFieldElement[][] jacobian = (RealFieldElement[][])MathArrays.buildArray(this.field, (int)6, (int)6);
        this.computePVWithoutA();
        FieldVector3D<T> position = this.partialPV.getPosition();
        FieldVector3D<T> velocity = this.partialPV.getVelocity();
        RealFieldElement r2 = position.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        RealFieldElement r3 = (RealFieldElement)r.multiply((Object)r2);
        Object mu = this.getMu();
        RealFieldElement sqrtMuA = (RealFieldElement)((RealFieldElement)this.a.multiply(mu)).sqrt();
        RealFieldElement a2 = (RealFieldElement)this.a.multiply(this.a);
        RealFieldElement e2 = (RealFieldElement)((RealFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey));
        RealFieldElement oMe2 = (RealFieldElement)this.one.subtract((Object)e2);
        RealFieldElement epsilon = (RealFieldElement)oMe2.sqrt();
        RealFieldElement beta = (RealFieldElement)this.one.divide(epsilon.add(1.0));
        RealFieldElement ratio = (RealFieldElement)epsilon.multiply((Object)beta);
        RealFieldElement hx2 = (RealFieldElement)this.hx.multiply(this.hx);
        RealFieldElement hy2 = (RealFieldElement)this.hy.multiply(this.hy);
        RealFieldElement hxhy = (RealFieldElement)this.hx.multiply(this.hy);
        FieldVector3D f = new FieldVector3D((RealFieldElement)((RealFieldElement)hx2.subtract((Object)hy2)).add(1.0), (RealFieldElement)hxhy.multiply(2), (RealFieldElement)this.hy.multiply(-2)).normalize();
        FieldVector3D g = new FieldVector3D((RealFieldElement)hxhy.multiply(2), (RealFieldElement)((RealFieldElement)hy2.add(1.0)).subtract((Object)hx2), (RealFieldElement)this.hx.multiply(2)).normalize();
        FieldVector3D w = FieldVector3D.crossProduct(position, velocity).normalize();
        RealFieldElement x = FieldVector3D.dotProduct(position, (FieldVector3D)f);
        RealFieldElement y = FieldVector3D.dotProduct(position, (FieldVector3D)g);
        RealFieldElement xDot = FieldVector3D.dotProduct(velocity, (FieldVector3D)f);
        RealFieldElement yDot = FieldVector3D.dotProduct(velocity, (FieldVector3D)g);
        RealFieldElement c1 = (RealFieldElement)this.a.divide(sqrtMuA.multiply((Object)epsilon));
        RealFieldElement c1N = (RealFieldElement)c1.negate();
        RealFieldElement c2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.a.multiply((Object)sqrtMuA)).multiply((Object)beta)).divide((Object)r3);
        RealFieldElement c3 = (RealFieldElement)sqrtMuA.divide(r3.multiply((Object)epsilon));
        FieldVector3D drDotSdEx = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c1.multiply((Object)xDot)).multiply((Object)yDot)).subtract(((RealFieldElement)c2.multiply(this.ey)).multiply((Object)x))).subtract(((RealFieldElement)c3.multiply((Object)x)).multiply((Object)y)), f, (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c1N.multiply((Object)xDot)).multiply((Object)xDot)).subtract(((RealFieldElement)c2.multiply(this.ey)).multiply((Object)y))).add(((RealFieldElement)c3.multiply((Object)x)).multiply((Object)x)), g);
        FieldVector3D drDotSdEy = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c1.multiply((Object)yDot)).multiply((Object)yDot)).add(((RealFieldElement)c2.multiply(this.ex)).multiply((Object)x))).subtract(((RealFieldElement)c3.multiply((Object)y)).multiply((Object)y)), f, (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c1N.multiply((Object)xDot)).multiply((Object)yDot)).add(((RealFieldElement)c2.multiply(this.ex)).multiply((Object)y))).add(((RealFieldElement)c3.multiply((Object)x)).multiply((Object)y)), g);
        FieldVector3D vectorAR = new FieldVector3D((RealFieldElement)((RealFieldElement)a2.multiply(2)).divide((Object)r3), position);
        FieldVector3D vectorARDot = new FieldVector3D((RealFieldElement)((RealFieldElement)a2.multiply(2)).divide(mu), velocity);
        this.fillHalfRow((RealFieldElement)this.one, vectorAR, jacobian[0], 0);
        this.fillHalfRow((RealFieldElement)this.one, vectorARDot, jacobian[0], 3);
        RealFieldElement d1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.a.negate()).multiply((Object)ratio)).divide((Object)r3);
        RealFieldElement d2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.hy.multiply((Object)xDot)).subtract(this.hx.multiply((Object)yDot))).divide(sqrtMuA.multiply((Object)epsilon));
        RealFieldElement d3 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.hx.multiply((Object)y)).subtract(this.hy.multiply((Object)x))).divide((Object)sqrtMuA);
        FieldVector3D vectorExRDot = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)x.multiply(2)).multiply((Object)yDot)).subtract(xDot.multiply((Object)y))).divide(mu), g, (RealFieldElement)((RealFieldElement)((RealFieldElement)y.negate()).multiply((Object)yDot)).divide(mu), f, (RealFieldElement)((RealFieldElement)((RealFieldElement)this.ey.negate()).multiply((Object)d3)).divide((Object)epsilon), w);
        this.fillHalfRow((RealFieldElement)this.ex.multiply((Object)d1), position, (RealFieldElement)((RealFieldElement)this.ey.negate()).multiply((Object)d2), w, (RealFieldElement)epsilon.divide((Object)sqrtMuA), drDotSdEy, jacobian[1], 0);
        this.fillHalfRow((RealFieldElement)this.one, vectorExRDot, jacobian[1], 3);
        FieldVector3D vectorEyRDot = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)xDot.multiply(2)).multiply((Object)y)).subtract(x.multiply((Object)yDot))).divide(mu), f, (RealFieldElement)((RealFieldElement)((RealFieldElement)x.negate()).multiply((Object)xDot)).divide(mu), g, (RealFieldElement)((RealFieldElement)this.ex.multiply((Object)d3)).divide((Object)epsilon), w);
        this.fillHalfRow((RealFieldElement)this.ey.multiply((Object)d1), position, (RealFieldElement)this.ex.multiply((Object)d2), w, (RealFieldElement)((RealFieldElement)epsilon.negate()).divide((Object)sqrtMuA), drDotSdEx, jacobian[2], 0);
        this.fillHalfRow((RealFieldElement)this.one, vectorEyRDot, jacobian[2], 3);
        RealFieldElement h = (RealFieldElement)((RealFieldElement)((RealFieldElement)hx2.add(1.0)).add((Object)hy2)).divide(((RealFieldElement)sqrtMuA.multiply(2)).multiply((Object)epsilon));
        this.fillHalfRow((RealFieldElement)((RealFieldElement)h.negate()).multiply((Object)xDot), w, jacobian[3], 0);
        this.fillHalfRow((RealFieldElement)h.multiply((Object)x), w, jacobian[3], 3);
        this.fillHalfRow((RealFieldElement)((RealFieldElement)h.negate()).multiply((Object)yDot), w, jacobian[4], 0);
        this.fillHalfRow((RealFieldElement)h.multiply((Object)y), w, jacobian[4], 3);
        RealFieldElement l = (RealFieldElement)((RealFieldElement)ratio.negate()).divide((Object)sqrtMuA);
        this.fillHalfRow((RealFieldElement)((RealFieldElement)this.one.negate()).divide((Object)sqrtMuA), velocity, d2, w, (RealFieldElement)l.multiply(this.ex), drDotSdEx, (RealFieldElement)l.multiply(this.ey), drDotSdEy, jacobian[5], 0);
        this.fillHalfRow((RealFieldElement)((RealFieldElement)this.zero.add(-2.0)).divide((Object)sqrtMuA), position, (RealFieldElement)this.ex.multiply((Object)beta), vectorEyRDot, (RealFieldElement)((RealFieldElement)this.ey.negate()).multiply((Object)beta), vectorExRDot, d3, w, jacobian[5], 3);
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianEccentricWrtCartesian() {
        RealFieldElement[][] jacobian = this.computeJacobianMeanWrtCartesian();
        T le = this.getLE();
        RealFieldElement cosLe = (RealFieldElement)le.cos();
        RealFieldElement sinLe = (RealFieldElement)le.sin();
        RealFieldElement aOr = (RealFieldElement)this.one.divide(((RealFieldElement)this.one.subtract(this.ex.multiply((Object)cosLe))).subtract(this.ey.multiply((Object)sinLe)));
        RealFieldElement[] rowEx = jacobian[1];
        RealFieldElement[] rowEy = jacobian[2];
        RealFieldElement[] rowL = jacobian[5];
        for (int j = 0; j < 6; ++j) {
            rowL[j] = (RealFieldElement)aOr.multiply(((RealFieldElement)rowL[j].add(sinLe.multiply((Object)rowEx[j]))).subtract(cosLe.multiply((Object)rowEy[j])));
        }
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianTrueWrtCartesian() {
        RealFieldElement[][] jacobian = this.computeJacobianEccentricWrtCartesian();
        T le = this.getLE();
        RealFieldElement cosLe = (RealFieldElement)le.cos();
        RealFieldElement sinLe = (RealFieldElement)le.sin();
        RealFieldElement eSinE = (RealFieldElement)((RealFieldElement)this.ex.multiply((Object)sinLe)).subtract(this.ey.multiply((Object)cosLe));
        RealFieldElement ecosE = (RealFieldElement)((RealFieldElement)this.ex.multiply((Object)cosLe)).add(this.ey.multiply((Object)sinLe));
        RealFieldElement e2 = (RealFieldElement)((RealFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey));
        RealFieldElement epsilon = (RealFieldElement)((RealFieldElement)this.one.subtract((Object)e2)).sqrt();
        RealFieldElement onePeps = (RealFieldElement)epsilon.add(1.0);
        RealFieldElement d = (RealFieldElement)onePeps.subtract((Object)ecosE);
        RealFieldElement cT = (RealFieldElement)((RealFieldElement)((RealFieldElement)d.multiply((Object)d)).add(eSinE.multiply((Object)eSinE))).divide(2.0);
        RealFieldElement cE = (RealFieldElement)((RealFieldElement)ecosE.multiply((Object)onePeps)).subtract((Object)e2);
        RealFieldElement cX = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.ex.multiply((Object)eSinE)).divide((Object)epsilon)).subtract(this.ey)).add(sinLe.multiply((Object)onePeps));
        RealFieldElement cY = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.ey.multiply((Object)eSinE)).divide((Object)epsilon)).add(this.ex)).subtract(cosLe.multiply((Object)onePeps));
        RealFieldElement factorLe = (RealFieldElement)((RealFieldElement)cT.add((Object)cE)).divide((Object)cT);
        RealFieldElement factorEx = (RealFieldElement)cX.divide((Object)cT);
        RealFieldElement factorEy = (RealFieldElement)cY.divide((Object)cT);
        RealFieldElement[] rowEx = jacobian[1];
        RealFieldElement[] rowEy = jacobian[2];
        RealFieldElement[] rowL = jacobian[5];
        for (int j = 0; j < 6; ++j) {
            rowL[j] = (RealFieldElement)((RealFieldElement)((RealFieldElement)factorLe.multiply((Object)rowL[j])).add(factorEx.multiply((Object)rowEx[j]))).add(factorEy.multiply((Object)rowEy[j]));
        }
        return jacobian;
    }

    @Override
    public void addKeplerContribution(PositionAngle type, T gm, T[] pDot) {
        RealFieldElement n = (RealFieldElement)((RealFieldElement)((RealFieldElement)gm.divide(this.a)).sqrt()).divide(this.a);
        switch (type) {
            case MEAN: {
                pDot[5] = (RealFieldElement)pDot[5].add((Object)n);
                break;
            }
            case ECCENTRIC: {
                RealFieldElement oMe2 = (RealFieldElement)((RealFieldElement)this.one.subtract(this.ex.multiply(this.ex))).subtract(this.ey.multiply(this.ey));
                RealFieldElement ksi = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.ex.multiply(this.lv.cos())).add(1.0)).add(this.ey.multiply(this.lv.sin()));
                pDot[5] = (RealFieldElement)pDot[5].add(((RealFieldElement)n.multiply((Object)ksi)).divide((Object)oMe2));
                break;
            }
            case TRUE: {
                RealFieldElement oMe2 = (RealFieldElement)((RealFieldElement)this.one.subtract(this.ex.multiply(this.ex))).subtract(this.ey.multiply(this.ey));
                RealFieldElement ksi = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.ex.multiply(this.lv.cos())).add(1.0)).add(this.ey.multiply(this.lv.sin()));
                pDot[5] = (RealFieldElement)pDot[5].add(((RealFieldElement)((RealFieldElement)n.multiply((Object)ksi)).multiply((Object)ksi)).divide(oMe2.multiply(oMe2.sqrt())));
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
    }

    public String toString() {
        return new StringBuffer().append("equinoctial parameters: ").append('{').append("a: ").append(this.a.getReal()).append("; ex: ").append(this.ex.getReal()).append("; ey: ").append(this.ey.getReal()).append("; hx: ").append(this.hx.getReal()).append("; hy: ").append(this.hy.getReal()).append("; lv: ").append(FastMath.toDegrees((double)this.lv.getReal())).append(";}").toString();
    }

    @Deprecated
    public static <T extends RealFieldElement<T>> T normalizeAngle(T a, T center) {
        return (T)((RealFieldElement)a.subtract(Math.PI * 2 * FastMath.floor((double)((a.getReal() + Math.PI - center.getReal()) / (Math.PI * 2)))));
    }

    @Override
    public EquinoctialOrbit toOrbit() {
        if (this.hasDerivatives()) {
            return new EquinoctialOrbit(this.a.getReal(), this.ex.getReal(), this.ey.getReal(), this.hx.getReal(), this.hy.getReal(), this.lv.getReal(), this.aDot.getReal(), this.exDot.getReal(), this.eyDot.getReal(), this.hxDot.getReal(), this.hyDot.getReal(), this.lvDot.getReal(), PositionAngle.TRUE, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
        }
        return new EquinoctialOrbit(this.a.getReal(), this.ex.getReal(), this.ey.getReal(), this.hx.getReal(), this.hy.getReal(), this.lv.getReal(), PositionAngle.TRUE, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
    }
}

