/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.hipparchus.analysis.interpolation.BilinearInterpolatingFunction;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.AbstractSelfFeedingLoader;
import org.orekit.data.DataContext;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.troposphere.ViennaModelType;
import org.orekit.time.DateTimeComponents;

public class ViennaModelCoefficientsLoader
extends AbstractSelfFeedingLoader
implements DataLoader {
    public static final String DEFAULT_SUPPORTED_NAMES = "VMF*_\\\\*\\*\\.*H$";
    private static final Pattern SEPARATOR = Pattern.compile("\\s+");
    private double[] coefficientsA = null;
    private double[] zenithDelay = null;
    private double latitude;
    private double longitude;
    private ViennaModelType type;

    @DefaultDataContext
    public ViennaModelCoefficientsLoader(String supportedNames, double latitude, double longitude, ViennaModelType type) {
        this(supportedNames, latitude, longitude, type, DataContext.getDefault().getDataProvidersManager());
    }

    public ViennaModelCoefficientsLoader(String supportedNames, double latitude, double longitude, ViennaModelType type, DataProvidersManager dataProvidersManager) {
        super(supportedNames, dataProvidersManager);
        this.type = type;
        this.latitude = latitude;
        this.longitude = MathUtils.normalizeAngle((double)longitude, (double)Math.PI);
    }

    @DefaultDataContext
    public ViennaModelCoefficientsLoader(double latitude, double longitude, ViennaModelType type) {
        this(DEFAULT_SUPPORTED_NAMES, latitude, longitude, type);
    }

    public double[] getA() {
        return (double[])this.coefficientsA.clone();
    }

    public double[] getZenithDelay() {
        return (double[])this.zenithDelay.clone();
    }

    @Override
    public String getSupportedNames() {
        return super.getSupportedNames();
    }

    public void loadViennaCoefficients() {
        this.feed(this);
        if (this.coefficientsA == null || this.zenithDelay == null) {
            throw new OrekitException((Localizable)OrekitMessages.VIENNA_ACOEF_OR_ZENITH_DELAY_NOT_LOADED, this.getSupportedNames());
        }
    }

    public void loadViennaCoefficients(DateTimeComponents dateTimeComponents) {
        int year = dateTimeComponents.getDate().getYear();
        int month = dateTimeComponents.getDate().getMonth();
        int day = dateTimeComponents.getDate().getDay();
        int hour = dateTimeComponents.getTime().getHour();
        String monthString = month < 10 ? "0" + month : String.valueOf(month);
        String dayString = day < 10 ? "0" + day : String.valueOf(day);
        String hourString = hour < 10 ? "0" + hour : String.valueOf(hour);
        switch (this.type) {
            case VIENNA_ONE: {
                this.setSupportedNames(String.format("VMFG_%04d%2s%2s.H%2s", year, monthString, dayString, hourString));
                break;
            }
            case VIENNA_THREE: {
                this.setSupportedNames(String.format("VMF3_%04d%2s%2s.H%2s", year, monthString, dayString, hourString));
                break;
            }
        }
        try {
            this.loadViennaCoefficients();
        }
        catch (OrekitException oe) {
            throw new OrekitException(oe, OrekitMessages.VIENNA_ACOEF_OR_ZENITH_DELAY_NOT_AVAILABLE_FOR_DATE, dateTimeComponents.toString());
        }
    }

    @Override
    public boolean stillAcceptsData() {
        return true;
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException {
        int lineNumber = 0;
        String line = null;
        ArrayList<Double> latitudes = new ArrayList<Double>();
        ArrayList<Double> longitudes = new ArrayList<Double>();
        ArrayList<Double> ah = new ArrayList<Double>();
        ArrayList<Double> aw = new ArrayList<Double>();
        ArrayList<Double> zhd = new ArrayList<Double>();
        ArrayList<Double> zwd = new ArrayList<Double>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            line = br.readLine();
            while (line != null) {
                ++lineNumber;
                if ((line = line.trim()).length() > 0 && line.startsWith("! Range/resolution:")) {
                    String[] range_line = SEPARATOR.split(line);
                    for (double lat = Double.parseDouble(range_line[2]); lat <= Double.parseDouble(range_line[3]); lat += Double.parseDouble(range_line[6])) {
                        latitudes.add(FastMath.toRadians((double)lat));
                    }
                    for (double lon = Double.parseDouble(range_line[4]); lon <= Double.parseDouble(range_line[5]); lon += Double.parseDouble(range_line[7])) {
                        longitudes.add(FastMath.toRadians((double)lon));
                        if (this.type == ViennaModelType.VIENNA_ONE && lon >= 357.5) break;
                    }
                }
                if (line.length() > 0 && !line.startsWith("!")) {
                    String[] values_line = SEPARATOR.split(line);
                    ah.add(Double.valueOf(values_line[2]));
                    aw.add(Double.valueOf(values_line[3]));
                    zhd.add(Double.valueOf(values_line[4]));
                    zwd.add(Double.valueOf(values_line[5]));
                }
                line = br.readLine();
            }
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
        }
        int dimLat = latitudes.size();
        int dimLon = longitudes.size();
        double[] xVal = new double[dimLat];
        for (int i = 0; i < dimLat; ++i) {
            xVal[i] = (Double)latitudes.get(i);
        }
        double[] yVal = new double[dimLon];
        for (int j = 0; j < dimLon; ++j) {
            yVal[j] = (Double)longitudes.get(j);
        }
        double[][] fvalAH = new double[dimLat][dimLon];
        double[][] fvalAW = new double[dimLat][dimLon];
        double[][] fvalZH = new double[dimLat][dimLon];
        double[][] fvalZW = new double[dimLat][dimLon];
        int index = dimLon * dimLat;
        for (int x = 0; x < dimLat; ++x) {
            for (int y = dimLon - 1; y >= 0; --y) {
                fvalAH[x][y] = (Double)ah.get(--index);
                fvalAW[x][y] = (Double)aw.get(index);
                fvalZH[x][y] = (Double)zhd.get(index);
                fvalZW[x][y] = (Double)zwd.get(index);
            }
        }
        BilinearInterpolatingFunction functionAH = new BilinearInterpolatingFunction(xVal, yVal, fvalAH);
        BilinearInterpolatingFunction functionAW = new BilinearInterpolatingFunction(xVal, yVal, fvalAW);
        BilinearInterpolatingFunction functionZH = new BilinearInterpolatingFunction(xVal, yVal, fvalZH);
        BilinearInterpolatingFunction functionZW = new BilinearInterpolatingFunction(xVal, yVal, fvalZW);
        this.coefficientsA = new double[2];
        this.zenithDelay = new double[2];
        this.coefficientsA[0] = functionAH.value(this.latitude, this.longitude);
        this.coefficientsA[1] = functionAW.value(this.latitude, this.longitude);
        this.zenithDelay[0] = functionZH.value(this.latitude, this.longitude);
        this.zenithDelay[1] = functionZW.value(this.latitude, this.longitude);
        if (this.coefficientsA == null || this.zenithDelay == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_VIENNA_ACOEF_OR_ZENITH_DELAY_IN_FILE, name);
        }
    }
}

