/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.radiation.AbstractRadiationForceModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;

public class ECOM2
extends AbstractRadiationForceModel {
    public static final String ECOM_COEFFICIENT = "ECOM coefficient";
    private static final double MIN_VALUE = Double.NEGATIVE_INFINITY;
    private static final double MAX_VALUE = Double.POSITIVE_INFINITY;
    private final double SCALE = FastMath.scalb((double)1.0, (int)-22);
    private final int nD;
    private final int nB;
    private final ParameterDriver[] coefficients;
    private final ExtendedPVCoordinatesProvider sun;

    public ECOM2(int nD, int nB, double value, ExtendedPVCoordinatesProvider sun, double equatorialRadius) {
        super(sun, equatorialRadius);
        int i;
        this.nB = nB;
        this.nD = nD;
        this.coefficients = new ParameterDriver[2 * (nD + nB) + 3];
        ParameterDriver driver = new ParameterDriver("ECOM coefficient B0", value, this.SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        driver.setSelected(true);
        this.coefficients[0] = driver;
        for (i = 1; i < nB + 1; ++i) {
            driver = new ParameterDriver("ECOM coefficient Bcos" + Integer.toString(i - 1), value, this.SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            driver.setSelected(true);
            this.coefficients[i] = driver;
        }
        for (i = nB + 1; i < 2 * nB + 1; ++i) {
            driver = new ParameterDriver("ECOM coefficient Bsin" + Integer.toString(i - (nB + 1)), value, this.SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            driver.setSelected(true);
            this.coefficients[i] = driver;
        }
        driver = new ParameterDriver("ECOM coefficient D0", value, this.SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        driver.setSelected(true);
        this.coefficients[2 * nB + 1] = driver;
        for (i = 2 * nB + 2; i < 2 * nB + 2 + nD; ++i) {
            driver = new ParameterDriver("ECOM coefficient Dcos" + Integer.toString(i - (2 * nB + 2)), value, this.SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            driver.setSelected(true);
            this.coefficients[i] = driver;
        }
        for (i = 2 * nB + 2 + nD; i < 2 * (nB + nD) + 2; ++i) {
            driver = new ParameterDriver("ECOM coefficient Dsin" + Integer.toString(i - (2 * nB + nD + 2)), value, this.SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            driver.setSelected(true);
            this.coefficients[i] = driver;
        }
        driver = new ParameterDriver("ECOM coefficient Y0", value, this.SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        driver.setSelected(true);
        this.coefficients[2 * (nB + nD) + 2] = driver;
        this.sun = sun;
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        Vector3D Z = s.getPVCoordinates().getMomentum().normalize();
        Vector3D sunPos = this.sun.getPVCoordinates(s.getDate(), s.getFrame()).getPosition().normalize();
        Vector3D Y = Z.crossProduct((Vector)sunPos);
        Vector3D X = Y.crossProduct((Vector)Z);
        Vector3D position = s.getPVCoordinates().getPosition().normalize();
        Vector3D eD = sunPos.add(-1.0, (Vector)position);
        Vector3D eY = position.crossProduct((Vector)eD);
        Vector3D eB = eD.crossProduct((Vector)eY);
        double delta_u = FastMath.atan2((double)position.dotProduct((Vector)Y), (double)position.dotProduct((Vector)X));
        double b_u = parameters[0];
        for (int i = 1; i < this.nB + 1; ++i) {
            b_u += parameters[i] * FastMath.cos((double)((double)(2 * i) * delta_u)) + parameters[i + this.nB] * FastMath.sin((double)((double)(2 * i) * delta_u));
        }
        double d_u = parameters[2 * this.nB + 1];
        for (int i = 1; i < this.nD + 1; ++i) {
            d_u += parameters[2 * this.nB + 1 + i] * FastMath.cos((double)((double)(2 * i - 1) * delta_u)) + parameters[2 * this.nB + 1 + i + this.nD] * FastMath.sin((double)((double)(2 * i - 1) * delta_u));
        }
        return new Vector3D(d_u, eD, parameters[2 * (this.nD + this.nB) + 2], eY, b_u, eB);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        FieldVector3D Z = s.getPVCoordinates().getMomentum().normalize();
        FieldVector3D sunPos = this.sun.getPVCoordinates(s.getDate(), s.getFrame()).getPosition().normalize();
        FieldVector3D Y = Z.crossProduct(sunPos);
        FieldVector3D X = Y.crossProduct(Z);
        FieldVector3D position = s.getPVCoordinates().getPosition().normalize();
        FieldVector3D eD = sunPos.add(-1.0, position);
        FieldVector3D eY = position.crossProduct(eD);
        FieldVector3D eB = eD.crossProduct(eY);
        RealFieldElement delta_u = FastMath.atan2((RealFieldElement)position.dotProduct(Y), (RealFieldElement)position.dotProduct(X));
        Object b_u = parameters[0];
        for (int i = 1; i < this.nB + 1; ++i) {
            b_u = (RealFieldElement)((RealFieldElement)b_u.add(FastMath.cos((RealFieldElement)((RealFieldElement)delta_u.multiply(2 * i))).multiply(parameters[i]))).add(FastMath.sin((RealFieldElement)((RealFieldElement)delta_u.multiply(2 * i))).multiply(parameters[i + this.nB]));
        }
        Object d_u = parameters[2 * this.nB + 1];
        for (int i = 1; i < this.nD + 1; ++i) {
            d_u = (RealFieldElement)((RealFieldElement)d_u.add(FastMath.cos((RealFieldElement)((RealFieldElement)delta_u.multiply(2 * i - 1))).multiply(parameters[2 * this.nB + 1 + i]))).add(FastMath.sin((RealFieldElement)((RealFieldElement)delta_u.multiply(2 * i - 1))).multiply(parameters[2 * this.nB + 1 + i + this.nD]));
        }
        return new FieldVector3D(d_u, eD, parameters[2 * (this.nD + this.nB) + 2], eY, b_u, eB);
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return (ParameterDriver[])this.coefficients.clone();
    }
}

