/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ADMFile;
import org.orekit.files.ccsds.ADMMetaData;
import org.orekit.files.ccsds.CcsdsTimeScale;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class AEMFile
extends ADMFile {
    private List<AttitudeEphemeridesBlock> attitudeBlocks = new ArrayList<AttitudeEphemeridesBlock>();

    public void addAttitudeBlock() {
        this.attitudeBlocks.add(new AttitudeEphemeridesBlock());
    }

    public List<AttitudeEphemeridesBlock> getAttitudeBlocks() {
        return Collections.unmodifiableList(this.attitudeBlocks);
    }

    public void checkTimeSystems() {
        CcsdsTimeScale timeSystem = this.getAttitudeBlocks().get(0).getMetaData().getTimeSystem();
        for (AttitudeEphemeridesBlock block : this.attitudeBlocks) {
            if (timeSystem.equals((Object)block.getMetaData().getTimeSystem())) continue;
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_AEM_INCONSISTENT_TIME_SYSTEMS, new Object[]{timeSystem, block.getMetaData().getTimeSystem()});
        }
    }

    public Map<String, AemSatelliteEphemeris> getSatellites() {
        HashMap satellites = new HashMap();
        for (AttitudeEphemeridesBlock ephemeridesBlock : this.attitudeBlocks) {
            String id = ephemeridesBlock.getMetaData().getObjectID();
            satellites.putIfAbsent(id, new ArrayList());
            ((List)satellites.get(id)).add(ephemeridesBlock);
        }
        HashMap<String, AemSatelliteEphemeris> ret = new HashMap<String, AemSatelliteEphemeris>();
        for (Map.Entry entry : satellites.entrySet()) {
            String id = (String)entry.getKey();
            ret.put(id, new AemSatelliteEphemeris((List)entry.getValue()));
        }
        return ret;
    }

    public static class AemSatelliteEphemeris {
        private final List<AttitudeEphemeridesBlock> blocks;

        public AemSatelliteEphemeris(List<AttitudeEphemeridesBlock> blocks) {
            this.blocks = blocks;
        }

        public List<AttitudeEphemeridesBlock> getSegments() {
            return Collections.unmodifiableList(this.blocks);
        }

        public AbsoluteDate getStart() {
            return this.blocks.get(0).getStart();
        }

        public AbsoluteDate getStop() {
            return this.blocks.get(this.blocks.size() - 1).getStop();
        }
    }

    public class AttitudeEphemeridesBlock {
        private ADMMetaData metaData;
        private String refFrameAString;
        private String refFrameBString;
        private String attitudeDir;
        private AbsoluteDate startTime;
        private AbsoluteDate stopTime;
        private AbsoluteDate useableStartTime;
        private AbsoluteDate useableStopTime;
        private String attitudeType;
        private boolean isFirst;
        private String eulerRotSeq;
        private String rateFrameString;
        private String interpolationMethod;
        private int interpolationDegree;
        private RotationOrder rotationOrder;
        private List<TimeStampedAngularCoordinates> attitudeDataLines = new ArrayList<TimeStampedAngularCoordinates>();
        private List<String> attitudeDataLinesComment;

        public AttitudeEphemeridesBlock() {
            this.metaData = new ADMMetaData(AEMFile.this);
        }

        public List<TimeStampedAngularCoordinates> getAttitudeDataLines() {
            return this.attitudeDataLines;
        }

        public List<TimeStampedAngularCoordinates> getAngularCoordinates() {
            return Collections.unmodifiableList(this.attitudeDataLines);
        }

        public ADMMetaData getMetaData() {
            return this.metaData;
        }

        public String getFrameCenterString() {
            return this.getMetaData().getCenterName();
        }

        public String getRefFrameAString() {
            return this.refFrameAString;
        }

        public void setRefFrameAString(String frame) {
            this.refFrameAString = frame;
        }

        public String getRefFrameBString() {
            return this.refFrameBString;
        }

        public void setRefFrameBString(String frame) {
            this.refFrameBString = frame;
        }

        public String getRateFrameString() {
            return this.rateFrameString;
        }

        public void setRateFrameString(String frame) {
            this.rateFrameString = frame;
        }

        public String getAttitudeDirection() {
            return this.attitudeDir;
        }

        public void setAttitudeDirection(String direction) {
            this.attitudeDir = direction;
        }

        public String getAttitudeType() {
            return this.attitudeType;
        }

        public void setAttitudeType(String type) {
            this.attitudeType = type;
        }

        public boolean isFirst() {
            return this.isFirst;
        }

        public void setIsFirst(boolean isFirst) {
            this.isFirst = isFirst;
        }

        public String getEulerRotSeq() {
            return this.eulerRotSeq;
        }

        public void setEulerRotSeq(String eulerRotSeq) {
            this.eulerRotSeq = eulerRotSeq;
        }

        public String getTimeScaleString() {
            return this.metaData.getTimeSystem().toString();
        }

        public TimeScale getTimeScale() {
            return this.metaData.getTimeScale();
        }

        public AbsoluteDate getStartTime() {
            return this.startTime;
        }

        public void setStartTime(AbsoluteDate startTime) {
            this.startTime = startTime;
        }

        public AbsoluteDate getStopTime() {
            return this.stopTime;
        }

        public void setStopTime(AbsoluteDate stopTime) {
            this.stopTime = stopTime;
        }

        public AbsoluteDate getUseableStartTime() {
            return this.useableStartTime;
        }

        public void setUseableStartTime(AbsoluteDate useableStartTime) {
            this.useableStartTime = useableStartTime;
        }

        public AbsoluteDate getUseableStopTime() {
            return this.useableStopTime;
        }

        public void setUseableStopTime(AbsoluteDate useableStopTime) {
            this.useableStopTime = useableStopTime;
        }

        public AbsoluteDate getStart() {
            AbsoluteDate start = this.getUseableStartTime();
            if (start != null) {
                return start;
            }
            return this.getStartTime();
        }

        public AbsoluteDate getStop() {
            AbsoluteDate stop = this.getUseableStopTime();
            if (stop != null) {
                return stop;
            }
            return this.getStopTime();
        }

        public String getInterpolationMethod() {
            return this.interpolationMethod;
        }

        public void setInterpolationMethod(String interpolationMethod) {
            this.interpolationMethod = interpolationMethod;
        }

        public int getInterpolationDegree() {
            return this.interpolationDegree;
        }

        public void setInterpolationDegree(int interpolationDegree) {
            this.interpolationDegree = interpolationDegree;
        }

        public List<String> getAttitudeDataLinesComment() {
            return this.attitudeDataLinesComment;
        }

        public void setAttitudeDataLinesComment(List<String> ephemeridesDataLinesComment) {
            this.attitudeDataLinesComment = new ArrayList<String>(ephemeridesDataLinesComment);
        }

        public RotationOrder getRotationOrder() {
            return this.rotationOrder;
        }

        public void setRotationOrder(RotationOrder order) {
            this.rotationOrder = order;
        }
    }
}

