/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.adjustment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.optim.ConvergenceChecker;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresProblem;
import org.hipparchus.optim.nonlinear.vector.leastsquares.MultivariateJacobianFunction;
import org.hipparchus.optim.nonlinear.vector.leastsquares.ParameterValidator;
import org.orekit.rugged.adjustment.measurements.Observables;
import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedMessages;
import org.orekit.rugged.linesensor.LineSensor;
import org.orekit.rugged.utils.DSGenerator;
import org.orekit.utils.ParameterDriver;

abstract class OptimizationProblemBuilder {
    protected static final int ESTIMATION_LINE_RANGE_MARGIN = 100;
    private final DSGenerator generator;
    private final List<ParameterDriver> drivers;
    private final int nbParams;
    private Observables measurements;
    private final List<LineSensor> sensors;

    OptimizationProblemBuilder(List<LineSensor> sensors, Observables measurements) {
        this.generator = this.createGenerator(sensors);
        this.drivers = this.generator.getSelected();
        this.nbParams = this.drivers.size();
        if (this.nbParams == 0) {
            throw new RuggedException(RuggedMessages.NO_PARAMETERS_SELECTED, new Object[0]);
        }
        this.measurements = measurements;
        this.sensors = sensors;
    }

    public abstract LeastSquaresProblem build(int var1, double var2);

    final ConvergenceChecker<LeastSquaresProblem.Evaluation> createChecker(double parametersConvergenceThreshold) {
        ConvergenceChecker checker = (iteration, previous, current) -> current.getPoint().getLInfDistance(previous.getPoint()) <= parametersConvergenceThreshold;
        return checker;
    }

    final double[] createStartTab() {
        double[] start = new double[this.nbParams];
        int iStart = 0;
        for (ParameterDriver driver : this.drivers) {
            start[iStart++] = driver.getNormalizedValue();
        }
        return start;
    }

    protected abstract void createTargetAndWeight();

    protected abstract MultivariateJacobianFunction createFunction();

    protected abstract void initMapping();

    final ParameterValidator createParameterValidator() {
        ParameterValidator validator = params -> {
            int i = 0;
            for (ParameterDriver driver : this.drivers) {
                driver.setNormalizedValue(params.getEntry(i));
                params.setEntry(i++, driver.getNormalizedValue());
            }
            return params;
        };
        return validator;
    }

    private DSGenerator createGenerator(List<LineSensor> selectedSensors) {
        HashSet names = new HashSet();
        for (LineSensor sensor : selectedSensors) {
            sensor.getParametersDrivers().forEach(driver -> {
                if (!names.contains(driver.getName())) {
                    names.add(driver.getName());
                }
            });
        }
        final ArrayList selected = new ArrayList();
        final HashMap map = new HashMap();
        for (LineSensor sensor : selectedSensors) {
            sensor.getParametersDrivers().filter(driver -> driver.isSelected()).forEach(driver -> {
                if (map.get(driver.getName()) == null) {
                    map.put(driver.getName(), map.size());
                    selected.add(driver);
                }
            });
        }
        final DSFactory factory = new DSFactory(map.size(), 1);
        return new DSGenerator(){

            @Override
            public List<ParameterDriver> getSelected() {
                return selected;
            }

            @Override
            public DerivativeStructure constant(double value) {
                return factory.constant(value);
            }

            @Override
            public DerivativeStructure variable(ParameterDriver driver) {
                Integer index = (Integer)map.get(driver.getName());
                if (index == null) {
                    return this.constant(driver.getValue());
                }
                return factory.variable(index.intValue(), driver.getValue());
            }
        };
    }

    protected List<LineSensor> getSensors() {
        return this.sensors;
    }

    protected final int getNbParams() {
        return this.nbParams;
    }

    protected final List<ParameterDriver> getDrivers() {
        return this.drivers;
    }

    protected final DSGenerator getGenerator() {
        return this.generator;
    }

    protected Observables getMeasurements() {
        return this.measurements;
    }
}

