/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitIllegalStateException;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.TimeStampedCacheException;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.TimeStamped;
import org.orekit.utils.TimeStampedCache;

public class ImmutableTimeStampedCache<T extends TimeStamped>
implements TimeStampedCache<T> {
    private static final ChronologicalComparator CMP = new ChronologicalComparator();
    private static final ImmutableTimeStampedCache EMPTY_CACHE = new EmptyTimeStampedCache();
    private final List<T> data;
    private final int neighborsSize;

    public ImmutableTimeStampedCache(int neighborsSize, Collection<? extends T> data) {
        if (neighborsSize > data.size()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NOT_ENOUGH_CACHED_NEIGHBORS, data.size(), neighborsSize);
        }
        if (neighborsSize < 1) {
            throw new OrekitIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_SMALL, neighborsSize, 0);
        }
        this.neighborsSize = neighborsSize;
        this.data = new ArrayList<T>(data);
        Collections.sort(this.data, CMP);
    }

    private ImmutableTimeStampedCache() {
        this.data = null;
        this.neighborsSize = 0;
    }

    @Override
    public Stream<T> getNeighbors(AbsoluteDate central) {
        int i = this.findIndex(central);
        if (i < 0) {
            throw new TimeStampedCacheException((Localizable)OrekitMessages.UNABLE_TO_GENERATE_NEW_DATA_BEFORE, this.getEarliest().getDate(), central);
        }
        if (i >= this.data.size()) {
            throw new TimeStampedCacheException((Localizable)OrekitMessages.UNABLE_TO_GENERATE_NEW_DATA_AFTER, this.getLatest().getDate(), central);
        }
        int start = FastMath.max((int)0, (int)(i - (this.neighborsSize - 1) / 2));
        int end = FastMath.min((int)this.data.size(), (int)(start + this.neighborsSize));
        start = end - this.neighborsSize;
        return this.data.subList(start, end).stream();
    }

    private int findIndex(AbsoluteDate t) {
        int i = Collections.binarySearch(this.data, t, CMP);
        if (i == -this.data.size() - 1) {
            i = this.data.size();
        } else if (i < 0) {
            i = -i - 2;
        }
        return i;
    }

    @Override
    public int getNeighborsSize() {
        return this.neighborsSize;
    }

    @Override
    public T getEarliest() {
        return (T)((TimeStamped)this.data.get(0));
    }

    @Override
    public T getLatest() {
        return (T)((TimeStamped)this.data.get(this.data.size() - 1));
    }

    public List<T> getAll() {
        return Collections.unmodifiableList(this.data);
    }

    public String toString() {
        return "Immutable cache with " + this.data.size() + " entries";
    }

    public static final <TS extends TimeStamped> ImmutableTimeStampedCache<TS> emptyCache() {
        return EMPTY_CACHE;
    }

    private static class EmptyTimeStampedCache<T extends TimeStamped>
    extends ImmutableTimeStampedCache<T> {
        private EmptyTimeStampedCache() {
        }

        @Override
        public Stream<T> getNeighbors(AbsoluteDate central) {
            throw new TimeStampedCacheException((Localizable)OrekitMessages.NO_CACHED_ENTRIES, new Object[0]);
        }

        @Override
        public int getNeighborsSize() {
            return 0;
        }

        @Override
        public T getEarliest() {
            throw new OrekitIllegalStateException(OrekitMessages.NO_CACHED_ENTRIES, new Object[0]);
        }

        @Override
        public T getLatest() {
            throw new OrekitIllegalStateException(OrekitMessages.NO_CACHED_ENTRIES, new Object[0]);
        }

        @Override
        public List<T> getAll() {
            return Collections.emptyList();
        }

        @Override
        public String toString() {
            return "Empty immutable cache";
        }
    }
}

