/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.FiniteDifferencePropagatorConverter;
import org.orekit.propagation.conversion.KeplerianPropagatorBuilder;

public class OsculatingToMeanElementsConverter {
    private static final int MAX_EVALUATION = 1000;
    private final SpacecraftState state;
    private final int satelliteRevolution;
    private final Propagator propagator;
    private double positionScale;

    public OsculatingToMeanElementsConverter(SpacecraftState state, int satelliteRevolution, Propagator propagator, double positionScale) {
        this.state = state;
        this.satelliteRevolution = satelliteRevolution;
        this.propagator = propagator;
        this.positionScale = positionScale;
    }

    public final SpacecraftState convert() {
        double timeSpan = this.state.getKeplerianPeriod() * (double)this.satelliteRevolution;
        this.propagator.resetInitialState(this.state);
        FiniteDifferencePropagatorConverter converter = new FiniteDifferencePropagatorConverter(new KeplerianPropagatorBuilder(this.state.getOrbit(), PositionAngle.MEAN, this.positionScale, this.propagator.getAttitudeProvider()), 1.0E-6, 1000);
        Propagator prop = converter.convert(this.propagator, timeSpan, this.satelliteRevolution * 36, new String[0]);
        return prop.getInitialState();
    }
}

