/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.CCSDSFrame;
import org.orekit.files.ccsds.KeyValue;
import org.orekit.files.ccsds.Keyword;
import org.orekit.files.ccsds.ODMParser;
import org.orekit.files.ccsds.OEMFile;
import org.orekit.files.general.EphemerisFileParser;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OEMParser
extends ODMParser
implements EphemerisFileParser {
    @DefaultDataContext
    public OEMParser() {
        this(DataContext.getDefault());
    }

    public OEMParser(DataContext dataContext) {
        this(AbsoluteDate.FUTURE_INFINITY, Double.NaN, null, true, 0, 0, "", dataContext);
    }

    private OEMParser(AbsoluteDate missionReferenceDate, double mu, IERSConventions conventions, boolean simpleEOP, int launchYear, int launchNumber, String launchPiece, DataContext dataContext) {
        super(missionReferenceDate, mu, conventions, simpleEOP, launchYear, launchNumber, launchPiece, dataContext);
    }

    @Override
    public OEMParser withMissionReferenceDate(AbsoluteDate newMissionReferenceDate) {
        return new OEMParser(newMissionReferenceDate, this.getMu(), this.getConventions(), this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), this.getDataContext());
    }

    @Override
    public OEMParser withMu(double newMu) {
        return new OEMParser(this.getMissionReferenceDate(), newMu, this.getConventions(), this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), this.getDataContext());
    }

    @Override
    public OEMParser withConventions(IERSConventions newConventions) {
        return new OEMParser(this.getMissionReferenceDate(), this.getMu(), newConventions, this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), this.getDataContext());
    }

    @Override
    public OEMParser withSimpleEOP(boolean newSimpleEOP) {
        return new OEMParser(this.getMissionReferenceDate(), this.getMu(), this.getConventions(), newSimpleEOP, this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), this.getDataContext());
    }

    @Override
    public OEMParser withInternationalDesignator(int newLaunchYear, int newLaunchNumber, String newLaunchPiece) {
        return new OEMParser(this.getMissionReferenceDate(), this.getMu(), this.getConventions(), this.isSimpleEOP(), newLaunchYear, newLaunchNumber, newLaunchPiece, this.getDataContext());
    }

    @Override
    public OEMParser withDataContext(DataContext dataContext) {
        return new OEMParser(this.getMissionReferenceDate(), this.getMu(), this.getConventions(), this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), dataContext);
    }

    @Override
    public OEMFile parse(String fileName) {
        return (OEMFile)super.parse(fileName);
    }

    @Override
    public OEMFile parse(InputStream stream) {
        return (OEMFile)super.parse(stream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OEMFile parse(InputStream stream, String fileName) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            OEMFile oEMFile = this.parse(reader, fileName);
            return oEMFile;
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    @Override
    public OEMFile parse(BufferedReader reader, String fileName) {
        try {
            ParseInfo pi = new ParseInfo();
            pi.fileName = fileName;
            OEMFile file = pi.file;
            pi.file.setMissionReferenceDate(this.getMissionReferenceDate());
            pi.file.setMuSet(this.getMu());
            pi.file.setConventions(this.getConventions());
            pi.file.setDataContext(this.getDataContext());
            String line = reader.readLine();
            while (line != null) {
                ++pi.lineNumber;
                if (line.trim().length() != 0) {
                    pi.keyValue = new KeyValue(line, pi.lineNumber, pi.fileName);
                    if (pi.keyValue.getKeyword() == null) {
                        throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, pi.lineNumber, pi.fileName, line);
                    }
                    switch (pi.keyValue.getKeyword()) {
                        case CCSDS_OEM_VERS: {
                            file.setFormatVersion(pi.keyValue.getDoubleValue());
                            break;
                        }
                        case META_START: {
                            file.addEphemeridesBlock();
                            pi.lastEphemeridesBlock = file.getEphemeridesBlocks().get(file.getEphemeridesBlocks().size() - 1);
                            pi.lastEphemeridesBlock.getMetaData().setLaunchYear(this.getLaunchYear());
                            pi.lastEphemeridesBlock.getMetaData().setLaunchNumber(this.getLaunchNumber());
                            pi.lastEphemeridesBlock.getMetaData().setLaunchPiece(this.getLaunchPiece());
                            break;
                        }
                        case START_TIME: {
                            pi.lastEphemeridesBlock.setStartTime(this.parseDate(pi.keyValue.getValue(), pi.lastEphemeridesBlock.getMetaData().getTimeSystem()));
                            break;
                        }
                        case USEABLE_START_TIME: {
                            pi.lastEphemeridesBlock.setUseableStartTime(this.parseDate(pi.keyValue.getValue(), pi.lastEphemeridesBlock.getMetaData().getTimeSystem()));
                            break;
                        }
                        case USEABLE_STOP_TIME: {
                            pi.lastEphemeridesBlock.setUseableStopTime(this.parseDate(pi.keyValue.getValue(), pi.lastEphemeridesBlock.getMetaData().getTimeSystem()));
                            break;
                        }
                        case STOP_TIME: {
                            pi.lastEphemeridesBlock.setStopTime(this.parseDate(pi.keyValue.getValue(), pi.lastEphemeridesBlock.getMetaData().getTimeSystem()));
                            break;
                        }
                        case INTERPOLATION: {
                            pi.lastEphemeridesBlock.setInterpolationMethod(pi.keyValue.getValue());
                            break;
                        }
                        case INTERPOLATION_DEGREE: {
                            pi.lastEphemeridesBlock.setInterpolationDegree(Integer.parseInt(pi.keyValue.getValue()));
                            break;
                        }
                        case META_STOP: {
                            file.setMuUsed();
                            this.parseEphemeridesDataLines(reader, pi);
                            break;
                        }
                        case COVARIANCE_START: {
                            this.parseCovarianceDataLines(reader, pi);
                            break;
                        }
                        default: {
                            boolean parsed = false;
                            parsed = parsed || this.parseComment(pi.keyValue, pi.commentTmp);
                            boolean bl = parsed = parsed || this.parseHeaderEntry(pi.keyValue, file, pi.commentTmp);
                            if (pi.lastEphemeridesBlock != null) {
                                boolean bl2 = parsed = parsed || this.parseMetaDataEntry(pi.keyValue, pi.lastEphemeridesBlock.getMetaData(), pi.commentTmp);
                                if (parsed && pi.keyValue.getKeyword() == Keyword.REF_FRAME_EPOCH) {
                                    pi.lastEphemeridesBlock.setHasRefFrameEpoch(true);
                                }
                            }
                            if (parsed) break;
                            throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, pi.lineNumber, pi.fileName, line);
                        }
                    }
                }
                line = reader.readLine();
            }
            file.checkTimeSystems();
            return file;
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    private void parseEphemeridesDataLines(BufferedReader reader, ParseInfo pi) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            block23: {
                ++pi.lineNumber;
                if (line.trim().length() > 0) {
                    pi.keyValue = new KeyValue(line, pi.lineNumber, pi.fileName);
                    if (pi.keyValue.getKeyword() == null) {
                        try (Scanner sc = new Scanner(line);){
                            AbsoluteDate date = this.parseDate(sc.next(), pi.lastEphemeridesBlock.getMetaData().getTimeSystem());
                            Vector3D position = new Vector3D(Double.parseDouble(sc.next()) * 1000.0, Double.parseDouble(sc.next()) * 1000.0, Double.parseDouble(sc.next()) * 1000.0);
                            Vector3D velocity = new Vector3D(Double.parseDouble(sc.next()) * 1000.0, Double.parseDouble(sc.next()) * 1000.0, Double.parseDouble(sc.next()) * 1000.0);
                            Vector3D acceleration = Vector3D.NaN;
                            boolean hasAcceleration = false;
                            if (sc.hasNext()) {
                                acceleration = new Vector3D(Double.parseDouble(sc.next()) * 1000.0, Double.parseDouble(sc.next()) * 1000.0, Double.parseDouble(sc.next()) * 1000.0);
                                hasAcceleration = true;
                            }
                            TimeStampedPVCoordinates epDataLine = hasAcceleration ? new TimeStampedPVCoordinates(date, position, velocity, acceleration) : new TimeStampedPVCoordinates(date, position, velocity);
                            pi.lastEphemeridesBlock.getEphemeridesDataLines().add(epDataLine);
                            pi.lastEphemeridesBlock.updateHasAcceleration(hasAcceleration);
                            break block23;
                        }
                        catch (NumberFormatException nfe) {
                            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, pi.lineNumber, pi.fileName, line);
                        }
                    }
                    switch (pi.keyValue.getKeyword()) {
                        case META_START: {
                            pi.lastEphemeridesBlock.setEphemeridesDataLinesComment(pi.commentTmp);
                            pi.commentTmp.clear();
                            pi.lineNumber--;
                            reader.reset();
                            return;
                        }
                        case COVARIANCE_START: {
                            pi.lastEphemeridesBlock.setEphemeridesDataLinesComment(pi.commentTmp);
                            pi.commentTmp.clear();
                            pi.lineNumber--;
                            reader.reset();
                            return;
                        }
                        case COMMENT: {
                            pi.commentTmp.add(pi.keyValue.getValue());
                            break;
                        }
                        default: {
                            throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, pi.lineNumber, pi.fileName, line);
                        }
                    }
                }
            }
            reader.mark(300);
            line = reader.readLine();
        }
    }

    private void parseCovarianceDataLines(BufferedReader reader, ParseInfo pi) throws IOException {
        int i = 0;
        String line = reader.readLine();
        while (line != null) {
            block25: {
                ++pi.lineNumber;
                if (line.trim().length() != 0) {
                    pi.keyValue = new KeyValue(line, pi.lineNumber, pi.fileName);
                    if (pi.keyValue.getKeyword() == null) {
                        try (Scanner sc = new Scanner(line);){
                            for (int j = 0; j < i + 1; ++j) {
                                pi.lastMatrix.addToEntry(i, j, Double.parseDouble(sc.next()));
                                if (j == i) continue;
                                pi.lastMatrix.addToEntry(j, i, pi.lastMatrix.getEntry(i, j));
                            }
                            if (i == 5) {
                                OEMFile.CovarianceMatrix cm = new OEMFile.CovarianceMatrix(pi.epoch, pi.covRefLofType, pi.covRefFrame, pi.lastMatrix);
                                pi.lastEphemeridesBlock.getCovarianceMatrices().add(cm);
                            }
                            ++i;
                            break block25;
                        }
                        catch (NumberFormatException nfe) {
                            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, pi.lineNumber, pi.fileName, line);
                        }
                    }
                    switch (pi.keyValue.getKeyword()) {
                        case EPOCH: {
                            i = 0;
                            pi.covRefLofType = null;
                            pi.covRefFrame = null;
                            pi.lastMatrix = MatrixUtils.createRealMatrix((int)6, (int)6);
                            pi.epoch = this.parseDate(pi.keyValue.getValue(), pi.lastEphemeridesBlock.getMetaData().getTimeSystem());
                            break;
                        }
                        case COV_REF_FRAME: {
                            CCSDSFrame frame = this.parseCCSDSFrame(pi.keyValue.getValue());
                            if (frame.isLof()) {
                                pi.covRefLofType = frame.getLofType();
                                pi.covRefFrame = null;
                                break;
                            }
                            pi.covRefLofType = null;
                            pi.covRefFrame = frame.getFrame(this.getConventions(), this.isSimpleEOP(), this.getDataContext());
                            break;
                        }
                        case COVARIANCE_STOP: {
                            return;
                        }
                        default: {
                            throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, pi.lineNumber, pi.fileName, line);
                        }
                    }
                }
            }
            line = reader.readLine();
        }
    }

    private static class ParseInfo {
        private OEMFile.EphemeridesBlock lastEphemeridesBlock;
        private String fileName;
        private int lineNumber = 0;
        private OEMFile file = new OEMFile();
        private KeyValue keyValue;
        private AbsoluteDate epoch;
        private LOFType covRefLofType;
        private Frame covRefFrame;
        private RealMatrix lastMatrix;
        private List<String> commentTmp = new ArrayList<String>();

        protected ParseInfo() {
        }
    }
}

