/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss;

import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.Frames;
import org.orekit.propagation.analytical.gnss.AbstractGNSSPropagator;
import org.orekit.propagation.analytical.gnss.IRNSSOrbitalElements;
import org.orekit.utils.IERSConventions;

public class IRNSSPropagator
extends AbstractGNSSPropagator {
    private static final double IRNSS_AV = 7.2921151467E-5;
    private static final double IRNSS_CYCLE_DURATION = 6.193152E8;
    private final IRNSSOrbitalElements irnssOrbit;

    private IRNSSPropagator(Builder builder) {
        super(builder.orbit, builder.attitudeProvider, builder.eci, builder.ecef, builder.mass, 7.2921151467E-5, 6.193152E8, 3.986005E14);
        this.irnssOrbit = builder.orbit;
    }

    public IRNSSOrbitalElements getIRNSSOrbitalElements() {
        return this.irnssOrbit;
    }

    public static class Builder {
        private final IRNSSOrbitalElements orbit;
        private AttitudeProvider attitudeProvider;
        private double mass = 1000.0;
        private Frame eci = null;
        private Frame ecef = null;

        public Builder(IRNSSOrbitalElements irnssOrbElt, Frames frames) {
            this.orbit = irnssOrbElt;
            this.eci = frames.getEME2000();
            this.ecef = frames.getITRF(IERSConventions.IERS_2010, true);
            this.attitudeProvider = new InertialProvider(this.eci);
        }

        public Builder attitudeProvider(AttitudeProvider userProvider) {
            this.attitudeProvider = userProvider;
            return this;
        }

        public Builder mass(double userMass) {
            this.mass = userMass;
            return this;
        }

        public Builder eci(Frame inertial) {
            this.eci = inertial;
            return this;
        }

        public Builder ecef(Frame bodyFixed) {
            this.ecef = bodyFixed;
            return this;
        }

        public IRNSSPropagator build() {
            return new IRNSSPropagator(this);
        }
    }
}

