/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.io.Serializable;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.CircularOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedPVCoordinates;

public class EcksteinHechlerPropagator
extends AbstractAnalyticalPropagator {
    private EHModel initialModel;
    private transient TimeSpanMap<EHModel> models;
    private double referenceRadius;
    private double mu;
    private double[] ck0;

    @DefaultDataContext
    public EcksteinHechlerPropagator(Orbit initialOrbit, UnnormalizedSphericalHarmonicsProvider provider) {
        this(initialOrbit, Propagator.getDefaultLaw(DataContext.getDefault().getFrames()), 1000.0, provider, provider.onDate(initialOrbit.getDate()));
    }

    public EcksteinHechlerPropagator(Orbit initialOrbit, AttitudeProvider attitude, double mass, UnnormalizedSphericalHarmonicsProvider provider, UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics) {
        this(initialOrbit, attitude, mass, provider.getAe(), provider.getMu(), harmonics.getUnnormalizedCnm(2, 0), harmonics.getUnnormalizedCnm(3, 0), harmonics.getUnnormalizedCnm(4, 0), harmonics.getUnnormalizedCnm(5, 0), harmonics.getUnnormalizedCnm(6, 0));
    }

    @DefaultDataContext
    public EcksteinHechlerPropagator(Orbit initialOrbit, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double c60) {
        this(initialOrbit, Propagator.getDefaultLaw(DataContext.getDefault().getFrames()), 1000.0, referenceRadius, mu, c20, c30, c40, c50, c60);
    }

    @DefaultDataContext
    public EcksteinHechlerPropagator(Orbit initialOrbit, double mass, UnnormalizedSphericalHarmonicsProvider provider) {
        this(initialOrbit, Propagator.getDefaultLaw(DataContext.getDefault().getFrames()), mass, provider, provider.onDate(initialOrbit.getDate()));
    }

    @DefaultDataContext
    public EcksteinHechlerPropagator(Orbit initialOrbit, double mass, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double c60) {
        this(initialOrbit, Propagator.getDefaultLaw(DataContext.getDefault().getFrames()), mass, referenceRadius, mu, c20, c30, c40, c50, c60);
    }

    public EcksteinHechlerPropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, UnnormalizedSphericalHarmonicsProvider provider) {
        this(initialOrbit, attitudeProv, 1000.0, provider, provider.onDate(initialOrbit.getDate()));
    }

    public EcksteinHechlerPropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double c60) {
        this(initialOrbit, attitudeProv, 1000.0, referenceRadius, mu, c20, c30, c40, c50, c60);
    }

    public EcksteinHechlerPropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mass, UnnormalizedSphericalHarmonicsProvider provider) {
        this(initialOrbit, attitudeProv, mass, provider, provider.onDate(initialOrbit.getDate()));
    }

    public EcksteinHechlerPropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mass, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double c60) {
        this(initialOrbit, attitudeProv, mass, referenceRadius, mu, c20, c30, c40, c50, c60, PropagationType.OSCULATING);
    }

    @DefaultDataContext
    public EcksteinHechlerPropagator(Orbit initialOrbit, UnnormalizedSphericalHarmonicsProvider provider, PropagationType initialType) {
        this(initialOrbit, Propagator.getDefaultLaw(DataContext.getDefault().getFrames()), 1000.0, provider, provider.onDate(initialOrbit.getDate()), initialType);
    }

    public EcksteinHechlerPropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mass, UnnormalizedSphericalHarmonicsProvider provider, PropagationType initialType) {
        this(initialOrbit, attitudeProv, mass, provider, provider.onDate(initialOrbit.getDate()), initialType);
    }

    public EcksteinHechlerPropagator(Orbit initialOrbit, AttitudeProvider attitude, double mass, UnnormalizedSphericalHarmonicsProvider provider, UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics, PropagationType initialType) {
        this(initialOrbit, attitude, mass, provider.getAe(), provider.getMu(), harmonics.getUnnormalizedCnm(2, 0), harmonics.getUnnormalizedCnm(3, 0), harmonics.getUnnormalizedCnm(4, 0), harmonics.getUnnormalizedCnm(5, 0), harmonics.getUnnormalizedCnm(6, 0), initialType);
    }

    public EcksteinHechlerPropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mass, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double c60, PropagationType initialType) {
        super(attitudeProv);
        this.referenceRadius = referenceRadius;
        this.mu = mu;
        this.ck0 = new double[]{0.0, 0.0, c20, c30, c40, c50, c60};
        this.resetInitialState(new SpacecraftState(initialOrbit, attitudeProv.getAttitude(initialOrbit, initialOrbit.getDate(), initialOrbit.getFrame()), mass), initialType);
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        this.resetInitialState(state, PropagationType.OSCULATING);
    }

    public void resetInitialState(SpacecraftState state, PropagationType stateType) {
        super.resetInitialState(state);
        CircularOrbit circular = (CircularOrbit)OrbitType.CIRCULAR.convertType(state.getOrbit());
        this.initialModel = stateType == PropagationType.MEAN ? new EHModel(circular, state.getMass(), this.referenceRadius, this.mu, this.ck0) : this.computeMeanParameters(circular, state.getMass());
        this.models = new TimeSpanMap<EHModel>(this.initialModel);
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        EHModel newModel = this.computeMeanParameters((CircularOrbit)OrbitType.CIRCULAR.convertType(state.getOrbit()), state.getMass());
        if (forward) {
            this.models.addValidAfter(newModel, state.getDate());
        } else {
            this.models.addValidBefore(newModel, state.getDate());
        }
        this.stateChanged(state);
    }

    private EHModel computeMeanParameters(CircularOrbit osculating, double mass) {
        if (osculating.getA() < this.referenceRadius) {
            throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_INSIDE_BRILLOUIN_SPHERE, osculating.getA());
        }
        EHModel current = new EHModel(osculating, mass, this.referenceRadius, this.mu, this.ck0);
        double epsilon = 1.0E-13;
        double thresholdA = 1.0E-13 * (1.0 + FastMath.abs((double)current.mean.getA()));
        double thresholdE = 1.0E-13 * (1.0 + current.mean.getE());
        double thresholdAngles = 3.141592653589793E-13;
        int i = 0;
        while (i++ < 100) {
            UnivariateDerivative2[] parameters = current.propagateParameters(current.mean.getDate());
            double deltaA = osculating.getA() - parameters[0].getValue();
            double deltaEx = osculating.getCircularEx() - parameters[1].getValue();
            double deltaEy = osculating.getCircularEy() - parameters[2].getValue();
            double deltaI = osculating.getI() - parameters[3].getValue();
            double deltaRAAN = MathUtils.normalizeAngle((double)(osculating.getRightAscensionOfAscendingNode() - parameters[4].getValue()), (double)0.0);
            double deltaAlphaM = MathUtils.normalizeAngle((double)(osculating.getAlphaM() - parameters[5].getValue()), (double)0.0);
            current = new EHModel(new CircularOrbit(current.mean.getA() + deltaA, current.mean.getCircularEx() + deltaEx, current.mean.getCircularEy() + deltaEy, current.mean.getI() + deltaI, current.mean.getRightAscensionOfAscendingNode() + deltaRAAN, current.mean.getAlphaM() + deltaAlphaM, PositionAngle.MEAN, current.mean.getFrame(), current.mean.getDate(), this.mu), mass, this.referenceRadius, this.mu, this.ck0);
            if (!(FastMath.abs((double)deltaA) < thresholdA) || !(FastMath.abs((double)deltaEx) < thresholdE) || !(FastMath.abs((double)deltaEy) < thresholdE) || !(FastMath.abs((double)deltaI) < 3.141592653589793E-13) || !(FastMath.abs((double)deltaRAAN) < 3.141592653589793E-13) || !(FastMath.abs((double)deltaAlphaM) < 3.141592653589793E-13)) continue;
            return current;
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_ECKSTEIN_HECHLER_MEAN_PARAMETERS, i);
    }

    @Override
    public CartesianOrbit propagateOrbit(AbsoluteDate date) {
        EHModel current = this.models.get(date);
        return new CartesianOrbit(this.toCartesian(date, current.propagateParameters(date)), current.mean.getFrame(), this.mu);
    }

    private TimeStampedPVCoordinates toCartesian(AbsoluteDate date, UnivariateDerivative2[] parameters) {
        UnivariateDerivative2 cosOmega = parameters[4].cos();
        UnivariateDerivative2 sinOmega = parameters[4].sin();
        UnivariateDerivative2 cosI = parameters[3].cos();
        UnivariateDerivative2 sinI = parameters[3].sin();
        UnivariateDerivative2 alphaE = this.meanToEccentric(parameters[5], parameters[1], parameters[2]);
        UnivariateDerivative2 cosAE = alphaE.cos();
        UnivariateDerivative2 sinAE = alphaE.sin();
        UnivariateDerivative2 ex2 = parameters[1].multiply(parameters[1]);
        UnivariateDerivative2 ey2 = parameters[2].multiply(parameters[2]);
        UnivariateDerivative2 exy = parameters[1].multiply(parameters[2]);
        UnivariateDerivative2 q = ex2.add(ey2).subtract(1.0).negate().sqrt();
        UnivariateDerivative2 beta = q.add(1.0).reciprocal();
        UnivariateDerivative2 bx2 = beta.multiply(ex2);
        UnivariateDerivative2 by2 = beta.multiply(ey2);
        UnivariateDerivative2 bxy = beta.multiply(exy);
        UnivariateDerivative2 u = bxy.multiply(sinAE).subtract(parameters[1].add(by2.subtract(1.0).multiply(cosAE)));
        UnivariateDerivative2 v = bxy.multiply(cosAE).subtract(parameters[2].add(bx2.subtract(1.0).multiply(sinAE)));
        UnivariateDerivative2 x = parameters[0].multiply(u);
        UnivariateDerivative2 y = parameters[0].multiply(v);
        FieldVector3D p = new FieldVector3D((RealFieldElement)x.multiply(cosOmega).subtract(y.multiply(cosI.multiply(sinOmega))), (RealFieldElement)x.multiply(sinOmega).add(y.multiply(cosI.multiply(cosOmega))), (RealFieldElement)y.multiply(sinI));
        Vector3D p0 = new Vector3D(((UnivariateDerivative2)p.getX()).getValue(), ((UnivariateDerivative2)p.getY()).getValue(), ((UnivariateDerivative2)p.getZ()).getValue());
        Vector3D p1 = new Vector3D(((UnivariateDerivative2)p.getX()).getFirstDerivative(), ((UnivariateDerivative2)p.getY()).getFirstDerivative(), ((UnivariateDerivative2)p.getZ()).getFirstDerivative());
        Vector3D p2 = new Vector3D(((UnivariateDerivative2)p.getX()).getSecondDerivative(), ((UnivariateDerivative2)p.getY()).getSecondDerivative(), ((UnivariateDerivative2)p.getZ()).getSecondDerivative());
        return new TimeStampedPVCoordinates(date, p0, p1, p2);
    }

    private UnivariateDerivative2 meanToEccentric(UnivariateDerivative2 alphaM, UnivariateDerivative2 ex, UnivariateDerivative2 ey) {
        UnivariateDerivative2 alphaE = alphaM;
        UnivariateDerivative2 shift = alphaM.getField().getZero();
        UnivariateDerivative2 alphaEMalphaM = alphaM.getField().getZero();
        UnivariateDerivative2 cosAlphaE = alphaE.cos();
        UnivariateDerivative2 sinAlphaE = alphaE.sin();
        int iter = 0;
        do {
            UnivariateDerivative2 f2 = ex.multiply(sinAlphaE).subtract(ey.multiply(cosAlphaE));
            UnivariateDerivative2 f1 = alphaM.getField().getOne().subtract(ex.multiply(cosAlphaE)).subtract(ey.multiply(sinAlphaE));
            UnivariateDerivative2 f0 = alphaEMalphaM.subtract(f2);
            UnivariateDerivative2 f12 = f1.multiply(2);
            shift = f0.multiply(f12).divide(f1.multiply(f12).subtract(f0.multiply(f2)));
            alphaEMalphaM = alphaEMalphaM.subtract(shift);
            alphaE = alphaM.add(alphaEMalphaM);
            cosAlphaE = alphaE.cos();
            sinAlphaE = alphaE.sin();
        } while (++iter < 50 && FastMath.abs((double)shift.getValue()) > 1.0E-12);
        return alphaE;
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.models.get(date).mass;
    }

    private static class EHModel
    implements Serializable {
        private static final long serialVersionUID = 20160115L;
        private final CircularOrbit mean;
        private final double mass;
        private final double xnotDot;
        private final double rdpom;
        private final double rdpomp;
        private final double eps1;
        private final double eps2;
        private final double xim;
        private final double ommD;
        private final double rdl;
        private final double aMD;
        private final double kh;
        private final double kl;
        private final double ax1;
        private final double ay1;
        private final double as1;
        private final double ac2;
        private final double axy3;
        private final double as3;
        private final double ac4;
        private final double as5;
        private final double ac6;
        private final double ex1;
        private final double exx2;
        private final double exy2;
        private final double ex3;
        private final double ex4;
        private final double ey1;
        private final double eyx2;
        private final double eyy2;
        private final double ey3;
        private final double ey4;
        private final double rx1;
        private final double ry1;
        private final double r2;
        private final double r3;
        private final double rl;
        private final double iy1;
        private final double ix1;
        private final double i2;
        private final double i3;
        private final double ih;
        private final double lx1;
        private final double ly1;
        private final double l2;
        private final double l3;
        private final double ll;

        EHModel(CircularOrbit mean, double mass, double referenceRadius, double mu, double[] ck0) {
            this.mean = mean;
            this.mass = mass;
            double q = referenceRadius / mean.getA();
            double ql = q * q;
            double g2 = ck0[2] * ql;
            double g3 = ck0[3] * (ql *= q);
            double g4 = ck0[4] * (ql *= q);
            double g5 = ck0[5] * (ql *= q);
            double g6 = ck0[6] * (ql *= q);
            double cosI1 = FastMath.cos((double)mean.getI());
            double sinI1 = FastMath.sin((double)mean.getI());
            double sinI2 = sinI1 * sinI1;
            double sinI4 = sinI2 * sinI2;
            double sinI6 = sinI2 * sinI4;
            if (sinI2 < 1.0E-10) {
                throw new OrekitException((Localizable)OrekitMessages.ALMOST_EQUATORIAL_ORBIT, FastMath.toDegrees((double)mean.getI()));
            }
            if (FastMath.abs((double)(sinI2 - 0.8)) < 0.001) {
                throw new OrekitException((Localizable)OrekitMessages.ALMOST_CRITICALLY_INCLINED_ORBIT, FastMath.toDegrees((double)mean.getI()));
            }
            if (mean.getE() > 0.1) {
                throw new OrekitException((Localizable)OrekitMessages.TOO_LARGE_ECCENTRICITY_FOR_PROPAGATION_MODEL, mean.getE());
            }
            this.xnotDot = FastMath.sqrt((double)(mu / mean.getA())) / mean.getA();
            this.rdpom = -0.75 * g2 * (4.0 - 5.0 * sinI2);
            this.rdpomp = 7.5 * g4 * (1.0 - 3.875 * sinI2 + 3.0625 * sinI4) - 13.125 * g6 * (1.0 - 8.0 * sinI2 + 16.125 * sinI4 - 9.28125 * sinI6);
            q = 3.0 / (32.0 * this.rdpom);
            this.eps1 = q * g4 * sinI2 * (30.0 - 35.0 * sinI2) - 175.0 * q * g6 * sinI2 * (1.0 - 3.0 * sinI2 + 2.0625 * sinI4);
            q = 3.0 * sinI1 / (8.0 * this.rdpom);
            this.eps2 = q * g3 * (4.0 - 5.0 * sinI2) - q * g5 * (10.0 - 35.0 * sinI2 + 26.25 * sinI4);
            this.xim = mean.getI();
            this.ommD = cosI1 * (1.5 * g2 - 2.25 * g2 * g2 * (2.5 - 3.1666666666666665 * sinI2) + 0.9375 * g4 * (7.0 * sinI2 - 4.0) + 3.28125 * g6 * (2.0 - 9.0 * sinI2 + 8.25 * sinI4));
            this.rdl = 1.0 - 1.5 * g2 * (3.0 - 4.0 * sinI2);
            this.aMD = this.rdl + 2.25 * g2 * g2 * (9.0 - 21.916666666666668 * sinI2 + 14.208333333333334 * sinI4) + 0.9375 * g4 * (8.0 - 31.0 * sinI2 + 24.5 * sinI4) + 3.28125 * g6 * (-3.3333333333333335 + 25.0 * sinI2 - 48.75 * sinI4 + 27.5 * sinI6);
            double qq = -1.5 * g2 / this.rdl;
            double qA = 0.75 * g2 * g2 * sinI2;
            double qB = 0.25 * g4 * sinI2;
            double qC = 6.5625 * g6 * sinI2;
            double qD = -0.75 * g3 * sinI1;
            double qE = 3.75 * g5 * sinI1;
            this.kh = 0.375 / this.rdpom;
            this.kl = this.kh / sinI1;
            this.ax1 = qq * (2.0 - 3.5 * sinI2);
            this.ay1 = qq * (2.0 - 2.5 * sinI2);
            this.as1 = qD * (4.0 - 5.0 * sinI2) + qE * (2.625 * sinI4 - 3.5 * sinI2 + 1.0);
            this.ac2 = qq * sinI2 + qA * 7.0 * (2.0 - 3.0 * sinI2) + qB * (15.0 - 17.5 * sinI2) + qC * (3.0 * sinI2 - 1.0 - 2.0625 * sinI4);
            this.axy3 = qq * 3.5 * sinI2;
            this.as3 = qD * 5.0 / 3.0 * sinI2 + qE * 7.0 / 6.0 * sinI2 * (1.0 - 1.125 * sinI2);
            this.ac4 = qA * sinI2 + qB * 4.375 * sinI2 + qC * 0.75 * (1.1 * sinI4 - sinI2);
            this.as5 = qE * 21.0 / 80.0 * sinI4;
            this.ac6 = qC * -11.0 / 80.0 * sinI4;
            this.ex1 = qq * (1.0 - 1.25 * sinI2);
            this.exx2 = qq * 0.5 * (3.0 - 5.0 * sinI2);
            this.exy2 = qq * (2.0 - 1.5 * sinI2);
            this.ex3 = qq * 7.0 / 12.0 * sinI2;
            this.ex4 = qq * 17.0 / 8.0 * sinI2;
            this.ey1 = qq * (1.0 - 1.75 * sinI2);
            this.eyx2 = qq * (1.0 - 3.0 * sinI2);
            this.eyy2 = qq * (2.0 * sinI2 - 1.5);
            this.ey3 = qq * 7.0 / 12.0 * sinI2;
            this.ey4 = qq * 17.0 / 8.0 * sinI2;
            q = -qq * cosI1;
            this.rx1 = 3.5 * q;
            this.ry1 = -2.5 * q;
            this.r2 = -0.5 * q;
            this.r3 = 1.1666666666666667 * q;
            this.rl = g3 * cosI1 * (4.0 - 15.0 * sinI2) - 2.5 * g5 * cosI1 * (4.0 - 42.0 * sinI2 + 52.5 * sinI4);
            this.iy1 = q = 0.5 * qq * sinI1 * cosI1;
            this.ix1 = -q;
            this.i2 = q;
            this.i3 = q * 7.0 / 3.0;
            this.ih = -g3 * cosI1 * (4.0 - 5.0 * sinI2) + 2.5 * g5 * cosI1 * (4.0 - 14.0 * sinI2 + 10.5 * sinI4);
            this.lx1 = qq * (7.0 - 9.625 * sinI2);
            this.ly1 = qq * (6.875 * sinI2 - 7.5);
            this.l2 = qq * (1.25 * sinI2 - 0.5);
            this.l3 = qq * (3.2083333333333335 * sinI2 - 1.1666666666666667);
            this.ll = g3 * (53.0 * sinI2 - 4.0 - 57.5 * sinI4) + 2.5 * g5 * (4.0 - 96.0 * sinI2 + 269.5 * sinI4 - 183.75 * sinI6);
        }

        public UnivariateDerivative2[] propagateParameters(AbsoluteDate date) {
            UnivariateDerivative2 dt = new UnivariateDerivative2(date.durationFrom(this.mean.getDate()), 1.0, 0.0);
            UnivariateDerivative2 xnot = dt.multiply(this.xnotDot);
            UnivariateDerivative2 x = xnot.multiply(this.rdpom + this.rdpomp);
            UnivariateDerivative2 cx = x.cos();
            UnivariateDerivative2 sx = x.sin();
            UnivariateDerivative2 exm = cx.multiply(this.mean.getCircularEx()).add(sx.multiply(this.eps2 - (1.0 - this.eps1) * this.mean.getCircularEy()));
            UnivariateDerivative2 eym = sx.multiply((1.0 + this.eps1) * this.mean.getCircularEx()).add(cx.multiply(this.mean.getCircularEy() - this.eps2)).add(this.eps2);
            UnivariateDerivative2 omm = new UnivariateDerivative2(MathUtils.normalizeAngle((double)(this.mean.getRightAscensionOfAscendingNode() + this.ommD * xnot.getValue()), (double)Math.PI), this.ommD * this.xnotDot, 0.0);
            UnivariateDerivative2 xlm = new UnivariateDerivative2(MathUtils.normalizeAngle((double)(this.mean.getAlphaM() + this.aMD * xnot.getValue()), (double)Math.PI), this.aMD * this.xnotDot, 0.0);
            UnivariateDerivative2 cl1 = xlm.cos();
            UnivariateDerivative2 sl1 = xlm.sin();
            UnivariateDerivative2 cl2 = cl1.multiply(cl1).subtract(sl1.multiply(sl1));
            UnivariateDerivative2 sl2 = cl1.multiply(sl1).add(sl1.multiply(cl1));
            UnivariateDerivative2 cl3 = cl2.multiply(cl1).subtract(sl2.multiply(sl1));
            UnivariateDerivative2 sl3 = cl2.multiply(sl1).add(sl2.multiply(cl1));
            UnivariateDerivative2 cl4 = cl3.multiply(cl1).subtract(sl3.multiply(sl1));
            UnivariateDerivative2 sl4 = cl3.multiply(sl1).add(sl3.multiply(cl1));
            UnivariateDerivative2 cl5 = cl4.multiply(cl1).subtract(sl4.multiply(sl1));
            UnivariateDerivative2 sl5 = cl4.multiply(sl1).add(sl4.multiply(cl1));
            UnivariateDerivative2 cl6 = cl5.multiply(cl1).subtract(sl5.multiply(sl1));
            UnivariateDerivative2 qh = eym.subtract(this.eps2).multiply(this.kh);
            UnivariateDerivative2 ql = exm.multiply(this.kl);
            UnivariateDerivative2 exmCl1 = exm.multiply(cl1);
            UnivariateDerivative2 exmSl1 = exm.multiply(sl1);
            UnivariateDerivative2 eymCl1 = eym.multiply(cl1);
            UnivariateDerivative2 eymSl1 = eym.multiply(sl1);
            UnivariateDerivative2 exmCl2 = exm.multiply(cl2);
            UnivariateDerivative2 exmSl2 = exm.multiply(sl2);
            UnivariateDerivative2 eymCl2 = eym.multiply(cl2);
            UnivariateDerivative2 eymSl2 = eym.multiply(sl2);
            UnivariateDerivative2 exmCl3 = exm.multiply(cl3);
            UnivariateDerivative2 exmSl3 = exm.multiply(sl3);
            UnivariateDerivative2 eymCl3 = eym.multiply(cl3);
            UnivariateDerivative2 eymSl3 = eym.multiply(sl3);
            UnivariateDerivative2 exmCl4 = exm.multiply(cl4);
            UnivariateDerivative2 exmSl4 = exm.multiply(sl4);
            UnivariateDerivative2 eymCl4 = eym.multiply(cl4);
            UnivariateDerivative2 eymSl4 = eym.multiply(sl4);
            UnivariateDerivative2 rda = exmCl1.multiply(this.ax1).add(eymSl1.multiply(this.ay1)).add(sl1.multiply(this.as1)).add(cl2.multiply(this.ac2)).add(exmCl3.add(eymSl3).multiply(this.axy3)).add(sl3.multiply(this.as3)).add(cl4.multiply(this.ac4)).add(sl5.multiply(this.as5)).add(cl6.multiply(this.ac6));
            UnivariateDerivative2 rdex = cl1.multiply(this.ex1).add(exmCl2.multiply(this.exx2)).add(eymSl2.multiply(this.exy2)).add(cl3.multiply(this.ex3)).add(exmCl4.add(eymSl4).multiply(this.ex4));
            UnivariateDerivative2 rdey = sl1.multiply(this.ey1).add(exmSl2.multiply(this.eyx2)).add(eymCl2.multiply(this.eyy2)).add(sl3.multiply(this.ey3)).add(exmSl4.subtract(eymCl4).multiply(this.ey4));
            UnivariateDerivative2 rdom = exmSl1.multiply(this.rx1).add(eymCl1.multiply(this.ry1)).add(sl2.multiply(this.r2)).add(eymCl3.subtract(exmSl3).multiply(this.r3)).add(ql.multiply(this.rl));
            UnivariateDerivative2 rdxi = eymSl1.multiply(this.iy1).add(exmCl1.multiply(this.ix1)).add(cl2.multiply(this.i2)).add(exmCl3.add(eymSl3).multiply(this.i3)).add(qh.multiply(this.ih));
            UnivariateDerivative2 rdxl = exmSl1.multiply(this.lx1).add(eymCl1.multiply(this.ly1)).add(sl2.multiply(this.l2)).add(exmSl3.subtract(eymCl3).multiply(this.l3)).add(ql.multiply(this.ll));
            return new UnivariateDerivative2[]{rda.add(1.0).multiply(this.mean.getA()), rdex.add(exm), rdey.add(eym), rdxi.add(this.xim), rdom.add(omm), rdxl.add(xlm)};
        }
    }
}

