/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class MendesPavlisModel
implements DiscreteTroposphericModel {
    private static final double[] K_COEFFICIENTS = new double[]{238.0185, 19990.975, 57.362, 579.55174};
    private static final double[] W_COEFFICIENTS = new double[]{295.235, 2.6422, -0.03238, 0.004028};
    private static final double[][] A_COEFFICIENTS = new double[][]{{0.00121008, 1.7295E-6, 3.191E-5, -1.8478E-8}, {0.00304965, 2.344E-6, -1.035E-4, -1.856E-8}, {0.068777, 1.972E-5, -0.003458, 1.06E-7}};
    private static final double C02 = 0.99995995;
    private double latitude;
    private double lambda;
    private double P0;
    private double T0;
    private double e0;

    public MendesPavlisModel(double t0, double p0, double rh, double latitude, double lambda) {
        this.P0 = p0;
        this.T0 = t0;
        this.e0 = this.getWaterVapor(rh);
        this.latitude = latitude;
        this.lambda = lambda;
    }

    public static MendesPavlisModel getStandardModel(double latitude, double lambda) {
        return new MendesPavlisModel(291.15, 1013.25, 0.5, latitude, lambda);
    }

    @Override
    public double pathDelay(double elevation, double height, double[] parameters, AbsoluteDate date) {
        double[] zenithDelay = this.computeZenithDelay(height, parameters, date);
        double[] mappingFunction = this.mappingFactors(elevation, height, parameters, date);
        return zenithDelay[0] * mappingFunction[0] + zenithDelay[1] * mappingFunction[1];
    }

    @Override
    public <T extends RealFieldElement<T>> T pathDelay(T elevation, T height, T[] parameters, FieldAbsoluteDate<T> date) {
        RealFieldElement[] delays = this.computeZenithDelay((RealFieldElement)height, (RealFieldElement[])parameters, date);
        RealFieldElement[] mappingFunction = this.mappingFactors((RealFieldElement)elevation, (RealFieldElement)height, (RealFieldElement[])parameters, date);
        return (T)((RealFieldElement)((RealFieldElement)delays[0].multiply((Object)mappingFunction[0])).add(delays[1].multiply((Object)mappingFunction[1])));
    }

    @Override
    public double[] computeZenithDelay(double height, double[] parameters, AbsoluteDate date) {
        double fsite = this.getSiteFunctionValue(height);
        double[] delay = new double[2];
        double sigma = 1.0 / this.lambda;
        double sigma2 = sigma * sigma;
        double coef1 = K_COEFFICIENTS[0] + sigma2;
        double coef2 = K_COEFFICIENTS[0] - sigma2;
        double coef3 = K_COEFFICIENTS[2] + sigma2;
        double coef4 = K_COEFFICIENTS[2] - sigma2;
        double frac1 = coef1 / (coef2 * coef2);
        double frac2 = coef3 / (coef4 * coef4);
        double fLambdaH = 0.01 * (K_COEFFICIENTS[1] * frac1 + K_COEFFICIENTS[3] * frac2) * 0.99995995;
        delay[0] = 0.002416579 * (fLambdaH / fsite) * this.P0;
        double sigma4 = sigma2 * sigma2;
        double sigma6 = sigma4 * sigma2;
        double w1s2 = 3.0 * W_COEFFICIENTS[1] * sigma2;
        double w2s4 = 5.0 * W_COEFFICIENTS[2] * sigma4;
        double w3s6 = 7.0 * W_COEFFICIENTS[3] * sigma6;
        double fLambdaNH = 0.003101 * (W_COEFFICIENTS[0] + w1s2 + w2s4 + w3s6);
        delay[1] = 1.0E-4 * (5.316 * fLambdaNH - 3.759 * fLambdaH) * (this.e0 / fsite);
        return delay;
    }

    @Override
    public <T extends RealFieldElement<T>> T[] computeZenithDelay(T height, T[] parameters, FieldAbsoluteDate<T> date) {
        Field field = height.getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        T fsite = this.getSiteFunctionValue(height);
        RealFieldElement[] delay = (RealFieldElement[])MathArrays.buildArray((Field)field, (int)2);
        RealFieldElement sigma = (RealFieldElement)zero.add(1.0 / this.lambda);
        RealFieldElement sigma2 = (RealFieldElement)sigma.multiply((Object)sigma);
        RealFieldElement coef1 = (RealFieldElement)sigma2.add(K_COEFFICIENTS[0]);
        RealFieldElement coef2 = (RealFieldElement)((RealFieldElement)sigma2.negate()).add(K_COEFFICIENTS[0]);
        RealFieldElement coef3 = (RealFieldElement)sigma2.add(K_COEFFICIENTS[2]);
        RealFieldElement coef4 = (RealFieldElement)((RealFieldElement)sigma2.negate()).add(K_COEFFICIENTS[2]);
        RealFieldElement frac1 = (RealFieldElement)coef1.divide(coef2.multiply((Object)coef2));
        RealFieldElement frac2 = (RealFieldElement)coef3.divide(coef4.multiply((Object)coef4));
        RealFieldElement fLambdaH = (RealFieldElement)((RealFieldElement)((RealFieldElement)frac1.multiply(K_COEFFICIENTS[1])).add(frac2.multiply(K_COEFFICIENTS[3]))).multiply(0.009999599500000001);
        delay[0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)fLambdaH.divide(fsite)).multiply(this.P0)).multiply(0.002416579);
        RealFieldElement sigma4 = (RealFieldElement)sigma2.multiply((Object)sigma2);
        RealFieldElement sigma6 = (RealFieldElement)sigma4.multiply((Object)sigma2);
        RealFieldElement w1s2 = (RealFieldElement)sigma2.multiply(3.0 * W_COEFFICIENTS[1]);
        RealFieldElement w2s4 = (RealFieldElement)sigma4.multiply(5.0 * W_COEFFICIENTS[2]);
        RealFieldElement w3s6 = (RealFieldElement)sigma6.multiply(7.0 * W_COEFFICIENTS[3]);
        RealFieldElement fLambdaNH = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)w1s2.add((Object)w2s4)).add((Object)w3s6)).add(W_COEFFICIENTS[0])).multiply(0.003101);
        delay[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)fLambdaNH.multiply(5.316)).subtract(fLambdaH.multiply(3.759))).multiply(((RealFieldElement)fsite.divide(this.e0)).reciprocal())).multiply(1.0E-4);
        return delay;
    }

    @Override
    public double[] mappingFactors(double elevation, double height, double[] parameters, AbsoluteDate date) {
        double sinE = FastMath.sin((double)elevation);
        double T2degree = this.T0 - 273.15;
        double a1 = this.computeMFCoeffient(A_COEFFICIENTS[0][0], A_COEFFICIENTS[0][1], A_COEFFICIENTS[0][2], A_COEFFICIENTS[0][3], T2degree, height);
        double a2 = this.computeMFCoeffient(A_COEFFICIENTS[1][0], A_COEFFICIENTS[1][1], A_COEFFICIENTS[1][2], A_COEFFICIENTS[1][3], T2degree, height);
        double a3 = this.computeMFCoeffient(A_COEFFICIENTS[2][0], A_COEFFICIENTS[2][1], A_COEFFICIENTS[2][2], A_COEFFICIENTS[2][3], T2degree, height);
        double numMP = 1.0 + a1 / (1.0 + a2 / (1.0 + a3));
        double denMP = sinE + a1 / (sinE + a2 / (sinE + a3));
        double factor = numMP / denMP;
        return new double[]{factor, factor};
    }

    @Override
    public <T extends RealFieldElement<T>> T[] mappingFactors(T elevation, T height, T[] parameters, FieldAbsoluteDate<T> date) {
        Field<T> field = date.getField();
        RealFieldElement sinE = FastMath.sin(elevation);
        double T2degree = this.T0 - 273.15;
        T a1 = this.computeMFCoeffient(A_COEFFICIENTS[0][0], A_COEFFICIENTS[0][1], A_COEFFICIENTS[0][2], A_COEFFICIENTS[0][3], T2degree, height);
        T a2 = this.computeMFCoeffient(A_COEFFICIENTS[1][0], A_COEFFICIENTS[1][1], A_COEFFICIENTS[1][2], A_COEFFICIENTS[1][3], T2degree, height);
        T a3 = this.computeMFCoeffient(A_COEFFICIENTS[2][0], A_COEFFICIENTS[2][1], A_COEFFICIENTS[2][2], A_COEFFICIENTS[2][3], T2degree, height);
        RealFieldElement numMP = (RealFieldElement)((RealFieldElement)a1.divide(((RealFieldElement)a2.divide(a3.add(1.0))).add(1.0))).add(1.0);
        RealFieldElement denMP = (RealFieldElement)((RealFieldElement)a1.divide(((RealFieldElement)a2.divide(a3.add((Object)sinE))).add((Object)sinE))).add((Object)sinE);
        RealFieldElement factor = (RealFieldElement)numMP.divide((Object)denMP);
        RealFieldElement[] mapping = (RealFieldElement[])MathArrays.buildArray(field, (int)2);
        mapping[0] = factor;
        mapping[1] = factor;
        return mapping;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    private double getSiteFunctionValue(double height) {
        return 1.0 - 0.00266 * FastMath.cos((double)(2.0 * this.latitude)) - 2.8E-7 * height;
    }

    private <T extends RealFieldElement<T>> T getSiteFunctionValue(T height) {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)height.multiply(2.8E-7)).negate()).add(1.0 - 0.00266 * FastMath.cos((double)(2.0 * this.latitude))));
    }

    private double computeMFCoeffient(double a0, double a1, double a2, double a3, double T, double height) {
        return a0 + a1 * T + a2 * FastMath.cos((double)this.latitude) + a3 * height;
    }

    private <T extends RealFieldElement<T>> T computeMFCoeffient(double a0, double a1, double a2, double a3, double temp, T height) {
        return (T)((RealFieldElement)((RealFieldElement)height.multiply(a3)).add(a0 + a1 * temp + a2 * FastMath.cos((double)this.latitude)));
    }

    private double getWaterVapor(double rh) {
        double es = 0.01 * FastMath.exp((double)(1.2378847000000001E-5 * this.T0 * this.T0 - 0.019121316 * this.T0 + 33.93711047 - 6343.164500000001 / this.T0));
        double fw = 1.00062 + 3.14E-6 * this.P0 + 5.599999999999999E-7 * FastMath.pow((double)(this.T0 - 273.15), (int)2);
        double e = rh * fw * es;
        return e;
    }
}

