/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.tessellation;

import org.hipparchus.ode.events.Action;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.LatitudeExtremumDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;

class HalfTrackSpanHandler
implements EventHandler<LatitudeExtremumDetector> {
    private final boolean isAscending;
    private AbsoluteDate start;
    private AbsoluteDate end;

    HalfTrackSpanHandler(boolean isAscending) {
        this.isAscending = isAscending;
        this.start = null;
        this.end = null;
    }

    public AbsoluteDate getStart() {
        return this.start;
    }

    public AbsoluteDate getEnd() {
        return this.end;
    }

    @Override
    public Action eventOccurred(SpacecraftState s, LatitudeExtremumDetector detector, boolean increasing) {
        if (increasing ^ this.isAscending) {
            if (this.start == null) {
                return Action.CONTINUE;
            }
            this.end = s.getDate();
            return Action.STOP;
        }
        this.start = s.getDate();
        return Action.CONTINUE;
    }
}

