/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.OceanLoadDeformationCoefficients;
import org.orekit.forces.gravity.potential.OceanTidesReader;

public class FESCHatEpsilonReader
extends OceanTidesReader {
    private static final String UNKNOWN_TYPE_PATTERN = "\\S+";
    private static final String INTEGER_TYPE_PATTERN = "[-+]?\\p{Digit}+";
    private static final String REAL_TYPE_PATTERN = "[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?";
    private static final String DOODSON_TYPE_PATTERN = "\\p{Digit}{2,3}[.,]\\p{Digit}{3}";
    private static final Pattern PATTERN = Pattern.compile("[.,]");
    private static final double RHO = 1025.0;
    private static final double BIG_G = 6.67428E-11;
    private static final double GE = 9.7803278;
    private final double scaleCHat;
    private final double scaleEpsilon;
    private final OceanLoadDeformationCoefficients oldc;
    private final Map<Integer, Double> astronomicalAmplitudes;

    public FESCHatEpsilonReader(String supportedNames, double scaleCHat, double scaleEpsilon, OceanLoadDeformationCoefficients oldc, Map<Integer, Double> astronomicalAmplitudes) {
        super(supportedNames);
        this.scaleCHat = scaleCHat;
        this.scaleEpsilon = scaleEpsilon;
        this.oldc = oldc;
        this.astronomicalAmplitudes = astronomicalAmplitudes;
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException {
        String[] fieldsPatterns = new String[]{DOODSON_TYPE_PATTERN, UNKNOWN_TYPE_PATTERN, INTEGER_TYPE_PATTERN, INTEGER_TYPE_PATTERN, REAL_TYPE_PATTERN, REAL_TYPE_PATTERN, REAL_TYPE_PATTERN, REAL_TYPE_PATTERN, REAL_TYPE_PATTERN, REAL_TYPE_PATTERN, REAL_TYPE_PATTERN, REAL_TYPE_PATTERN};
        StringBuilder builder = new StringBuilder("^\\p{Space}*");
        for (int i = 0; i < fieldsPatterns.length; ++i) {
            builder.append("(");
            builder.append(fieldsPatterns[i]);
            builder.append(")");
            builder.append(i < fieldsPatterns.length - 1 ? "\\p{Space}+" : "\\p{Space}*$");
        }
        Pattern regularLinePattern = Pattern.compile(builder.toString());
        double commonFactor = 8.789916322191701E-8;
        double[] kPrime = this.oldc.getCoefficients();
        this.startParse(name);
        try (BufferedReader r = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            int lineNumber = 0;
            String line = r.readLine();
            while (line != null) {
                ++lineNumber;
                Matcher regularMatcher = regularLinePattern.matcher(line);
                if (regularMatcher.matches()) {
                    int m;
                    int doodson = Integer.parseInt(PATTERN.matcher(regularMatcher.group(1)).replaceAll(""));
                    int n = Integer.parseInt(regularMatcher.group(3));
                    if (this.canAdd(n, m = Integer.parseInt(regularMatcher.group(4)))) {
                        double cHatPlus = this.scaleCHat * Double.parseDouble(regularMatcher.group(9));
                        double ePlus = this.scaleEpsilon * Double.parseDouble(regularMatcher.group(10));
                        double cHatMinus = this.scaleCHat * Double.parseDouble(regularMatcher.group(11));
                        double eMinus = this.scaleEpsilon * Double.parseDouble(regularMatcher.group(12));
                        double hf = this.astronomicalAmplitudes.getOrDefault(doodson, 0.0);
                        int cGamma = doodson / 100000;
                        double chiF = cGamma == 0 ? (hf > 0.0 ? Math.PI : 0.0) : (cGamma == 1 ? (hf > 0.0 ? 1.5707963267948966 : -1.5707963267948966) : (cGamma == 2 ? (hf > 0.0 ? 0.0 : Math.PI) : 0.0));
                        if (n >= kPrime.length) {
                            throw new OrekitException((Localizable)OrekitMessages.OCEAN_TIDE_LOAD_DEFORMATION_LIMITS, kPrime.length - 1, n, name);
                        }
                        double termFactor = (1.0 + kPrime[n]) / (double)(2 * n + 1);
                        double cPlus = 8.789916322191701E-8 * termFactor * cHatPlus * FastMath.sin((double)(ePlus + chiF));
                        double sPlus = 8.789916322191701E-8 * termFactor * cHatPlus * FastMath.cos((double)(ePlus + chiF));
                        double cMinus = m == 0 ? 0.0 : 8.789916322191701E-8 * termFactor * cHatMinus * FastMath.sin((double)(eMinus + chiF));
                        double sMinus = m == 0 ? 0.0 : 8.789916322191701E-8 * termFactor * cHatMinus * FastMath.cos((double)(eMinus + chiF));
                        this.addWaveCoefficients(doodson, n, m, cPlus, sPlus, cMinus, sMinus, lineNumber, line);
                    }
                }
                line = r.readLine();
            }
        }
        this.endParse();
    }
}

