/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Arrays;
import java.util.HashMap;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.FieldTransform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class Phase
extends AbstractMeasurement<Phase> {
    public static final String AMBIGUITY_NAME = "ambiguity";
    private final ParameterDriver ambiguityDriver = new ParameterDriver("ambiguity", 0.0, 1.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    private final GroundStation station;
    private final double wavelength;

    public Phase(GroundStation station, AbsoluteDate date, double phase, double wavelength, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(date, phase, sigma, baseWeight, Arrays.asList(satellite));
        this.addParameterDriver(this.ambiguityDriver);
        this.addParameterDriver(station.getClockOffsetDriver());
        this.addParameterDriver(station.getEastOffsetDriver());
        this.addParameterDriver(station.getNorthOffsetDriver());
        this.addParameterDriver(station.getZenithOffsetDriver());
        this.addParameterDriver(station.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(station.getPrimeMeridianDriftDriver());
        this.addParameterDriver(station.getPolarOffsetXDriver());
        this.addParameterDriver(station.getPolarDriftXDriver());
        this.addParameterDriver(station.getPolarOffsetYDriver());
        this.addParameterDriver(station.getPolarDriftYDriver());
        this.station = station;
        this.wavelength = wavelength;
    }

    public GroundStation getStation() {
        return this.station;
    }

    public double getWavelength() {
        return this.wavelength;
    }

    @Override
    protected EstimatedMeasurement<Phase> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        SpacecraftState state = states[0];
        int nbParams = 6;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            indices.put(driver.getName(), nbParams++);
        }
        FieldVector3D zero = FieldVector3D.getZero((Field)GradientField.getField((int)nbParams));
        TimeStampedFieldPVCoordinates<Gradient> pvaDS = Phase.getCoordinates(state, 0, nbParams);
        FieldTransform<Gradient> offsetToInertialDownlink = this.station.getOffsetToInertial(state.getFrame(), this.getDate(), nbParams, indices);
        FieldAbsoluteDate<Gradient> downlinkDateDS = offsetToInertialDownlink.getFieldDate();
        TimeStampedFieldPVCoordinates<Gradient> stationDownlink = offsetToInertialDownlink.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(downlinkDateDS, zero, zero, zero));
        Gradient tauD = Phase.signalTimeOfFlight(pvaDS, stationDownlink.getPosition(), downlinkDateDS);
        Gradient delta = downlinkDateDS.durationFrom(state.getDate());
        Gradient deltaMTauD = tauD.negate().add(delta);
        SpacecraftState transitState = state.shiftedBy(deltaMTauD.getValue());
        FieldPVCoordinates transitStateDS = pvaDS.shiftedBy((RealFieldElement)deltaMTauD);
        EstimatedMeasurement<Phase> estimated = new EstimatedMeasurement<Phase>(this, iteration, evaluation, new SpacecraftState[]{transitState}, new TimeStampedPVCoordinates[]{((TimeStampedFieldPVCoordinates)transitStateDS).toTimeStampedPVCoordinates(), stationDownlink.toTimeStampedPVCoordinates()});
        ObservableSatellite satellite = this.getSatellites().get(0);
        Gradient dts = satellite.getClockOffsetDriver().getValue(nbParams, indices);
        Gradient dtg = this.station.getClockOffsetDriver().getValue(nbParams, indices);
        double cOverLambda = 2.99792458E8 / this.wavelength;
        Gradient ambiguity = this.ambiguityDriver.getValue(nbParams, indices);
        Gradient phase = tauD.add(dtg).subtract(dts).multiply(cOverLambda).add(ambiguity);
        estimated.setEstimatedValue(phase.getValue());
        double[] derivatives = phase.getGradient();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 0, 6)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            Integer index = (Integer)indices.get(driver.getName());
            if (index == null) continue;
            estimated.setParameterDerivatives(driver, derivatives[index]);
        }
        return estimated;
    }
}

