/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.intersection;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.rugged.api.AlgorithmId;
import org.orekit.rugged.errors.DumpManager;
import org.orekit.rugged.intersection.IntersectionAlgorithm;
import org.orekit.rugged.utils.ExtendedEllipsoid;
import org.orekit.rugged.utils.NormalizedGeodeticPoint;

public class ConstantElevationAlgorithm
implements IntersectionAlgorithm {
    private final double constantElevation;

    public ConstantElevationAlgorithm(double constantElevation) {
        this.constantElevation = constantElevation;
    }

    @Override
    public NormalizedGeodeticPoint intersection(ExtendedEllipsoid ellipsoid, Vector3D position, Vector3D los) {
        DumpManager.dumpAlgorithm(AlgorithmId.CONSTANT_ELEVATION_OVER_ELLIPSOID, this.constantElevation);
        Vector3D p = ellipsoid.pointAtAltitude(position, los, this.constantElevation);
        GeodeticPoint gp = ellipsoid.transform(p, ellipsoid.getFrame(), null);
        return new NormalizedGeodeticPoint(gp.getLatitude(), gp.getLongitude(), gp.getAltitude(), 0.0);
    }

    @Override
    public NormalizedGeodeticPoint refineIntersection(ExtendedEllipsoid ellipsoid, Vector3D position, Vector3D los, NormalizedGeodeticPoint closeGuess) {
        DumpManager.dumpAlgorithm(AlgorithmId.CONSTANT_ELEVATION_OVER_ELLIPSOID, this.constantElevation);
        Vector3D p = ellipsoid.pointAtAltitude(position, los, this.constantElevation);
        GeodeticPoint gp = ellipsoid.transform(p, ellipsoid.getFrame(), null);
        return new NormalizedGeodeticPoint(gp.getLatitude(), gp.getLongitude(), gp.getAltitude(), closeGuess.getLongitude());
    }

    @Override
    public double getElevation(double latitude, double longitude) {
        DumpManager.dumpAlgorithm(AlgorithmId.CONSTANT_ELEVATION_OVER_ELLIPSOID, this.constantElevation);
        return this.constantElevation;
    }
}

