/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import java.util.Arrays;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.RealMatrixPreservingVisitor;
import org.hipparchus.ode.ExpandableODE;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.AdamsIntegrator;
import org.hipparchus.ode.nonstiff.AdamsStateInterpolator;
import org.hipparchus.util.FastMath;

public class AdamsMoultonIntegrator
extends AdamsIntegrator {
    private static final String METHOD_NAME = "Adams-Moulton";

    public AdamsMoultonIntegrator(int nSteps, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) throws MathIllegalArgumentException {
        super(METHOD_NAME, nSteps, nSteps + 1, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
    }

    public AdamsMoultonIntegrator(int nSteps, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) throws IllegalArgumentException {
        super(METHOD_NAME, nSteps, nSteps + 1, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
    }

    @Override
    public ODEStateAndDerivative integrate(ExpandableODE equations, ODEState initialState, double finalTime) throws MathIllegalArgumentException, MathIllegalStateException {
        this.sanityChecks(initialState, finalTime);
        this.setStepStart(this.initIntegration(equations, initialState, finalTime));
        boolean forward = finalTime > initialState.getTime();
        this.start(equations, this.getStepStart(), finalTime);
        ODEStateAndDerivative stepStart = this.getStepStart();
        ODEStateAndDerivative stepEnd = AdamsStateInterpolator.taylor(equations.getMapper(), stepStart, stepStart.getTime() + this.getStepSize(), this.getStepSize(), this.scaled, this.nordsieck);
        this.setIsLastStep(false);
        double[] y = stepStart.getCompleteState();
        do {
            double[] predictedY = null;
            double[] predictedScaled = new double[y.length];
            Array2DRowRealMatrix predictedNordsieck = null;
            double error = 10.0;
            while (error >= 1.0) {
                predictedY = stepEnd.getCompleteState();
                double[] yDot = this.computeDerivatives(stepEnd.getTime(), predictedY);
                for (int j = 0; j < predictedScaled.length; ++j) {
                    predictedScaled[j] = this.getStepSize() * yDot[j];
                }
                predictedNordsieck = this.updateHighOrderDerivativesPhase1(this.nordsieck);
                this.updateHighOrderDerivativesPhase2(this.scaled, predictedScaled, predictedNordsieck);
                error = predictedNordsieck.walkInOptimizedOrder((RealMatrixPreservingVisitor)new Corrector(y, predictedScaled, predictedY));
                if (Double.isNaN(error)) {
                    throw new MathIllegalStateException((Localizable)LocalizedODEFormats.NAN_APPEARING_DURING_INTEGRATION, new Object[]{stepEnd.getTime()});
                }
                if (!(error >= 1.0)) continue;
                double factor = this.computeStepGrowShrinkFactor(error);
                this.rescale(this.filterStep(this.getStepSize() * factor, forward, false));
                stepEnd = AdamsStateInterpolator.taylor(equations.getMapper(), this.getStepStart(), this.getStepStart().getTime() + this.getStepSize(), this.getStepSize(), this.scaled, this.nordsieck);
            }
            double[] correctedYDot = this.computeDerivatives(stepEnd.getTime(), predictedY);
            double[] correctedScaled = new double[y.length];
            for (int j = 0; j < correctedScaled.length; ++j) {
                correctedScaled[j] = this.getStepSize() * correctedYDot[j];
            }
            this.updateHighOrderDerivativesPhase2(predictedScaled, correctedScaled, predictedNordsieck);
            stepEnd = equations.getMapper().mapStateAndDerivative(stepEnd.getTime(), predictedY, correctedYDot);
            this.setStepStart(this.acceptStep(new AdamsStateInterpolator(this.getStepSize(), stepEnd, correctedScaled, predictedNordsieck, forward, this.getStepStart(), stepEnd, equations.getMapper()), finalTime));
            this.scaled = correctedScaled;
            this.nordsieck = predictedNordsieck;
            if (this.isLastStep()) continue;
            if (this.resetOccurred()) {
                this.start(equations, this.getStepStart(), finalTime);
                double nextT = this.getStepStart().getTime() + this.getStepSize();
                boolean nextIsLast = forward ? nextT >= finalTime : nextT <= finalTime;
                double hNew = nextIsLast ? finalTime - this.getStepStart().getTime() : this.getStepSize();
                this.rescale(hNew);
                System.arraycopy(this.getStepStart().getCompleteState(), 0, y, 0, y.length);
            } else {
                boolean filteredNextIsLast;
                double factor = this.computeStepGrowShrinkFactor(error);
                double scaledH = this.getStepSize() * factor;
                double nextT = this.getStepStart().getTime() + scaledH;
                boolean nextIsLast = forward ? nextT >= finalTime : nextT <= finalTime;
                double hNew = this.filterStep(scaledH, forward, nextIsLast);
                double filteredNextT = this.getStepStart().getTime() + hNew;
                boolean bl = forward ? filteredNextT >= finalTime : (filteredNextIsLast = filteredNextT <= finalTime);
                if (filteredNextIsLast) {
                    hNew = finalTime - this.getStepStart().getTime();
                }
                this.rescale(hNew);
                System.arraycopy(predictedY, 0, y, 0, y.length);
            }
            stepEnd = AdamsStateInterpolator.taylor(equations.getMapper(), this.getStepStart(), this.getStepStart().getTime() + this.getStepSize(), this.getStepSize(), this.scaled, this.nordsieck);
        } while (!this.isLastStep());
        ODEStateAndDerivative finalState = this.getStepStart();
        this.setStepStart(null);
        this.setStepSize(Double.NaN);
        return finalState;
    }

    private class Corrector
    implements RealMatrixPreservingVisitor {
        private final double[] previous;
        private final double[] scaled;
        private final double[] before;
        private final double[] after;

        Corrector(double[] previous, double[] scaled, double[] state) {
            this.previous = previous;
            this.scaled = scaled;
            this.after = state;
            this.before = (double[])state.clone();
        }

        public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
            Arrays.fill(this.after, 0.0);
        }

        public void visit(int row, int column, double value) {
            if ((row & 1) == 0) {
                int n = column;
                this.after[n] = this.after[n] - value;
            } else {
                int n = column;
                this.after[n] = this.after[n] + value;
            }
        }

        public double end() {
            double error = 0.0;
            for (int i = 0; i < this.after.length; ++i) {
                int n = i;
                this.after[n] = this.after[n] + (this.previous[i] + this.scaled[i]);
                if (i >= AdamsMoultonIntegrator.this.mainSetDimension) continue;
                double yScale = FastMath.max((double)FastMath.abs((double)this.previous[i]), (double)FastMath.abs((double)this.after[i]));
                double tol = AdamsMoultonIntegrator.this.vecAbsoluteTolerance == null ? AdamsMoultonIntegrator.this.scalAbsoluteTolerance + AdamsMoultonIntegrator.this.scalRelativeTolerance * yScale : AdamsMoultonIntegrator.this.vecAbsoluteTolerance[i] + AdamsMoultonIntegrator.this.vecRelativeTolerance[i] * yScale;
                double ratio = (this.after[i] - this.before[i]) / tol;
                error += ratio * ratio;
            }
            return FastMath.sqrt((double)(error / (double)AdamsMoultonIntegrator.this.mainSetDimension));
        }
    }
}

