/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration;

import org.hipparchus.analysis.integration.BaseAbstractUnivariateIntegrator;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.util.FastMath;

public class MidPointIntegrator
extends BaseAbstractUnivariateIntegrator {
    public static final int MIDPOINT_MAX_ITERATIONS_COUNT = 64;

    public MidPointIntegrator(double relativeAccuracy, double absoluteAccuracy, int minimalIterationCount, int maximalIterationCount) throws MathIllegalArgumentException {
        super(relativeAccuracy, absoluteAccuracy, minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 64) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, maximalIterationCount, 64);
        }
    }

    public MidPointIntegrator(int minimalIterationCount, int maximalIterationCount) throws MathIllegalArgumentException {
        super(minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 64) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, maximalIterationCount, 64);
        }
    }

    public MidPointIntegrator() {
        super(3, 64);
    }

    private double stage(int n, double previousStageResult, double min, double diffMaxMin) throws MathIllegalStateException {
        long np = 1L << n - 1;
        double sum = 0.0;
        double spacing = diffMaxMin / (double)np;
        double x = min + 0.5 * spacing;
        for (long i = 0L; i < np; ++i) {
            sum += this.computeObjectiveValue(x);
            x += spacing;
        }
        return 0.5 * (previousStageResult + sum * spacing);
    }

    @Override
    protected double doIntegrate() throws MathIllegalArgumentException, MathIllegalStateException {
        double min = this.getMin();
        double diff = this.getMax() - min;
        double midPoint = min + 0.5 * diff;
        double oldt = diff * this.computeObjectiveValue(midPoint);
        while (true) {
            double rLimit;
            double delta;
            this.iterations.increment();
            int i = this.iterations.getCount();
            double t = this.stage(i, oldt, min, diff);
            if (i >= this.getMinimalIterationCount() && ((delta = FastMath.abs(t - oldt)) <= (rLimit = this.getRelativeAccuracy() * (FastMath.abs(oldt) + FastMath.abs(t)) * 0.5) || delta <= this.getAbsoluteAccuracy())) {
                return t;
            }
            oldt = t;
        }
    }
}

