/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import org.hipparchus.util.FastMath;
import org.orekit.time.DateComponents;
import org.orekit.time.Month;
import org.orekit.time.TimeComponents;

public class DateTimeComponents
implements Serializable,
Comparable<DateTimeComponents> {
    public static final DateTimeComponents JULIAN_EPOCH = new DateTimeComponents(DateComponents.JULIAN_EPOCH, TimeComponents.H12);
    private static final long serialVersionUID = 5061129505488924484L;
    private final DateComponents date;
    private final TimeComponents time;

    public DateTimeComponents(DateComponents date, TimeComponents time) {
        this.date = date;
        this.time = time;
    }

    public DateTimeComponents(int year, int month, int day, int hour, int minute, double second) throws IllegalArgumentException {
        this.date = new DateComponents(year, month, day);
        this.time = new TimeComponents(hour, minute, second);
    }

    public DateTimeComponents(int year, Month month, int day, int hour, int minute, double second) throws IllegalArgumentException {
        this.date = new DateComponents(year, month, day);
        this.time = new TimeComponents(hour, minute, second);
    }

    public DateTimeComponents(int year, int month, int day) throws IllegalArgumentException {
        this.date = new DateComponents(year, month, day);
        this.time = TimeComponents.H00;
    }

    public DateTimeComponents(int year, Month month, int day) throws IllegalArgumentException {
        this.date = new DateComponents(year, month, day);
        this.time = TimeComponents.H00;
    }

    public DateTimeComponents(DateTimeComponents reference, double offset) {
        int day = reference.getDate().getJ2000Day();
        double seconds = reference.getTime().getSecondsInLocalDay();
        int dayShift = (int)FastMath.floor((double)((seconds += offset) / 86400.0));
        TimeComponents tmpTime = new TimeComponents(seconds -= 86400.0 * (double)dayShift);
        this.date = new DateComponents(day += dayShift);
        this.time = new TimeComponents(tmpTime.getHour(), tmpTime.getMinute(), tmpTime.getSecond(), reference.getTime().getMinutesFromUTC());
    }

    public static DateTimeComponents parseDateTime(String string) {
        int tIndex = string.indexOf(84);
        if (tIndex > 0) {
            return new DateTimeComponents(DateComponents.parseDate(string.substring(0, tIndex)), TimeComponents.parseTime(string.substring(tIndex + 1)));
        }
        return new DateTimeComponents(DateComponents.parseDate(string), TimeComponents.H00);
    }

    public double offsetFrom(DateTimeComponents dateTime) {
        int dateOffset = this.date.getJ2000Day() - dateTime.date.getJ2000Day();
        double timeOffset = this.time.getSecondsInUTCDay() - dateTime.time.getSecondsInUTCDay();
        return 86400.0 * (double)dateOffset + timeOffset;
    }

    public DateComponents getDate() {
        return this.date;
    }

    public TimeComponents getTime() {
        return this.time;
    }

    @Override
    public int compareTo(DateTimeComponents other) {
        int dateComparison = this.date.compareTo(other.date);
        if (dateComparison < 0) {
            return -1;
        }
        if (dateComparison > 0) {
            return 1;
        }
        return this.time.compareTo(other.time);
    }

    public boolean equals(Object other) {
        try {
            DateTimeComponents otherDateTime = (DateTimeComponents)other;
            return otherDateTime != null && this.date.equals(otherDateTime.date) && this.time.equals(otherDateTime.time);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        return this.date.hashCode() << 16 ^ this.time.hashCode();
    }

    public String toString() {
        return this.toString(60);
    }

    public String toString(int minuteDuration) {
        double wrap;
        double second = this.time.getSecond();
        if (second >= (wrap = (double)minuteDuration - 5.0E-4)) {
            int minute = this.time.getMinute();
            int hour = this.time.getHour();
            int j2000 = this.date.getJ2000Day();
            second = 0.0;
            if (++minute > 59) {
                minute = 0;
                if (++hour > 23) {
                    hour = 0;
                    ++j2000;
                }
            }
            return new DateComponents(j2000).toString() + 'T' + new TimeComponents(hour, minute, second).toString();
        }
        return this.date.toString() + 'T' + this.time.toString();
    }
}

