/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.CombinatoricsUtils;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.CelestialBody;
import org.orekit.propagation.semianalytical.dsst.forces.ForceModelContext;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.CoefficientsFactory;
import org.orekit.propagation.semianalytical.dsst.utilities.UpperBounds;

class DSSTThirdBodyContext
extends ForceModelContext {
    private static final int MAX_POWER = 22;
    private static final double BIG_TRUNCATION_TOLERANCE = 0.1;
    private static final double SMALL_TRUNCATION_TOLERANCE = 1.9E-6;
    private static final int MAX_ECCPOWER_SP = 4;
    private int maxAR3Pow;
    private int maxEccPow;
    private double[] aoR3Pow;
    private int maxEccPowShort;
    private int maxFreqF;
    private double[][] Qns;
    private final double gm;
    private double R3;
    private final double A;
    private double alpha;
    private double beta;
    private double gamma;
    private double BB;
    private double BBB;
    private double X;
    private double XX;
    private double XXX;
    private double m2aoA;
    private double BoA;
    private double ooAB;
    private double mCo2AB;
    private double BoABpo;
    private double muoR3;
    private double b;
    private double hXXX;
    private double kXXX;
    private final double motion;

    DSSTThirdBodyContext(AuxiliaryElements auxiliaryElements, CelestialBody thirdBody, double[] parameters) {
        super(auxiliaryElements);
        double mu = parameters[1];
        this.A = FastMath.sqrt((double)(mu * auxiliaryElements.getSma()));
        this.gm = parameters[0];
        double absA = FastMath.abs((double)auxiliaryElements.getSma());
        this.motion = FastMath.sqrt((double)(mu / absA)) / absA;
        Vector3D bodyPos = thirdBody.getPVCoordinates(auxiliaryElements.getDate(), auxiliaryElements.getFrame()).getPosition();
        this.R3 = bodyPos.getNorm();
        Vector3D bodyDir = bodyPos.normalize();
        this.alpha = bodyDir.dotProduct((Vector)auxiliaryElements.getVectorF());
        this.beta = bodyDir.dotProduct((Vector)auxiliaryElements.getVectorG());
        this.gamma = bodyDir.dotProduct((Vector)auxiliaryElements.getVectorW());
        this.BB = auxiliaryElements.getB() * auxiliaryElements.getB();
        this.BBB = this.BB * auxiliaryElements.getB();
        this.b = 1.0 / (1.0 + auxiliaryElements.getB());
        this.X = 1.0 / auxiliaryElements.getB();
        this.XX = this.X * this.X;
        this.XXX = this.X * this.XX;
        this.m2aoA = -2.0 * auxiliaryElements.getSma() / this.A;
        this.BoA = auxiliaryElements.getB() / this.A;
        this.ooAB = 1.0 / (this.A * auxiliaryElements.getB());
        this.mCo2AB = -auxiliaryElements.getC() * this.ooAB / 2.0;
        this.BoABpo = this.BoA / (1.0 + auxiliaryElements.getB());
        this.muoR3 = this.gm / this.R3;
        this.hXXX = auxiliaryElements.getH() * this.XXX;
        this.kXXX = auxiliaryElements.getK() * this.XXX;
        double aoR3 = auxiliaryElements.getSma() / this.R3;
        double tol = aoR3 > 0.3 || aoR3 > 0.15 && auxiliaryElements.getEcc() > 0.25 ? 0.1 : 1.9E-6;
        double eo2 = FastMath.max((double)0.0025, (double)(auxiliaryElements.getEcc() / 2.0));
        double x2o2 = this.XX / 2.0;
        double[] eccPwr = new double[22];
        double[] chiPwr = new double[22];
        eccPwr[0] = 1.0;
        chiPwr[0] = this.X;
        for (int i = 1; i < 22; ++i) {
            eccPwr[i] = eccPwr[i - 1] * eo2;
            chiPwr[i] = chiPwr[i - 1] * x2o2;
        }
        double ao2rxx = aoR3 / (2.0 * this.XX);
        double xmuarn = ao2rxx * ao2rxx * this.gm / (this.X * this.R3);
        double term = 0.0;
        this.maxAR3Pow = 2;
        this.maxEccPow = 0;
        int n = 2;
        int m = 2;
        int nsmd2 = 0;
        do {
            if ((term = xmuarn * (CombinatoricsUtils.factorialDouble((int)(n + m)) / (CombinatoricsUtils.factorialDouble((int)nsmd2) * CombinatoricsUtils.factorialDouble((int)(nsmd2 + m)))) * (CombinatoricsUtils.factorialDouble((int)(n + m + 1)) / (CombinatoricsUtils.factorialDouble((int)m) * CombinatoricsUtils.factorialDouble((int)(n + 1)))) * (CombinatoricsUtils.factorialDouble((int)(n - m + 1)) / CombinatoricsUtils.factorialDouble((int)(n + 1))) * eccPwr[m] * UpperBounds.getDnl(this.XX, chiPwr[m], n + 2, m)) < tol) {
                if (m == 0) break;
                if (m < 2) {
                    xmuarn *= ao2rxx;
                    m = 0;
                    ++n;
                    ++nsmd2;
                    continue;
                }
                m -= 2;
                ++nsmd2;
                continue;
            }
            this.maxAR3Pow = n++;
            this.maxEccPow = FastMath.max((int)m, (int)this.maxEccPow);
            xmuarn *= ao2rxx;
            ++m;
        } while (n < 22);
        this.maxEccPow = FastMath.min((int)this.maxAR3Pow, (int)this.maxEccPow);
        this.aoR3Pow = new double[this.maxAR3Pow + 1];
        this.aoR3Pow[0] = 1.0;
        for (int i = 1; i <= this.maxAR3Pow; ++i) {
            this.aoR3Pow[i] = aoR3 * this.aoR3Pow[i - 1];
        }
        this.maxFreqF = this.maxAR3Pow + 1;
        this.maxEccPowShort = 4;
        this.Qns = CoefficientsFactory.computeQns(this.gamma, this.maxAR3Pow, FastMath.max((int)this.maxEccPow, (int)this.maxEccPowShort));
    }

    public double getA() {
        return this.A;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getBB() {
        return this.BB;
    }

    public double getBBB() {
        return this.BBB;
    }

    public double getb() {
        return this.b;
    }

    public double getX() {
        return this.X;
    }

    public double getM2aoA() {
        return this.m2aoA;
    }

    public double getBoA() {
        return this.BoA;
    }

    public double getOoAB() {
        return this.ooAB;
    }

    public double getMCo2AB() {
        return this.mCo2AB;
    }

    public double getBoABpo() {
        return this.BoABpo;
    }

    public double getMuoR3() {
        return this.muoR3;
    }

    public double getHXXX() {
        return this.hXXX;
    }

    public double getKXXX() {
        return this.kXXX;
    }

    public int getMaxAR3Pow() {
        return this.maxAR3Pow;
    }

    public int getMaxEccPow() {
        return this.maxEccPow;
    }

    public double[] getAoR3Pow() {
        return this.aoR3Pow;
    }

    public int getMaxFreqF() {
        return this.maxFreqF;
    }

    public double getMeanMotion() {
        return this.motion;
    }

    public double[][] getQns() {
        return this.Qns;
    }
}

