/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.ode.FieldODEIntegrator;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.ForceModel;
import org.orekit.forces.gravity.NewtonianAttraction;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.FieldAbstractIntegratedPropagator;
import org.orekit.propagation.integration.FieldStateMapper;
import org.orekit.propagation.numerical.FieldTimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldAbsolutePVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterObserver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldNumericalPropagator<T extends RealFieldElement<T>>
extends FieldAbstractIntegratedPropagator<T> {
    private final List<ForceModel> forceModels;
    private final Field<T> field;
    private boolean ignoreCentralAttraction = false;

    @DefaultDataContext
    public FieldNumericalPropagator(Field<T> field, FieldODEIntegrator<T> integrator) {
        this(field, integrator, Propagator.getDefaultLaw(DataContext.getDefault().getFrames()));
    }

    public FieldNumericalPropagator(Field<T> field, FieldODEIntegrator<T> integrator, AttitudeProvider attitudeProvider) {
        super(field, integrator, PropagationType.MEAN);
        this.field = field;
        this.forceModels = new ArrayList<ForceModel>();
        this.initMapper(field);
        this.setAttitudeProvider(attitudeProvider);
        this.setMu((RealFieldElement)((RealFieldElement)field.getZero()).add(Double.NaN));
        this.setSlaveMode();
        this.setOrbitType(OrbitType.EQUINOCTIAL);
        this.setPositionAngleType(PositionAngle.TRUE);
    }

    public void setIgnoreCentralAttraction(boolean ignoreCentralAttraction) {
        this.ignoreCentralAttraction = ignoreCentralAttraction;
    }

    @Override
    public void setMu(T mu) {
        if (this.ignoreCentralAttraction) {
            this.superSetMu(mu);
        } else {
            this.addForceModel(new NewtonianAttraction(mu.getReal()));
        }
    }

    private void superSetMu(T mu) {
        super.setMu(mu);
    }

    private boolean hasNewtonianAttraction() {
        int last = this.forceModels.size() - 1;
        return last >= 0 && this.forceModels.get(last) instanceof NewtonianAttraction;
    }

    public void addForceModel(ForceModel model) {
        if (model instanceof NewtonianAttraction) {
            try {
                model.getParametersDrivers()[0].addObserver(new ParameterObserver(){

                    @Override
                    public void valueChanged(double previousValue, ParameterDriver driver) {
                        FieldNumericalPropagator.this.superSetMu((RealFieldElement)((RealFieldElement)FieldNumericalPropagator.this.field.getZero()).add(driver.getValue()));
                    }
                });
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
            if (this.hasNewtonianAttraction()) {
                this.forceModels.set(this.forceModels.size() - 1, model);
            } else {
                this.forceModels.add(model);
            }
        } else if (this.hasNewtonianAttraction()) {
            this.forceModels.add(this.forceModels.size() - 1, model);
        } else {
            this.forceModels.add(model);
        }
    }

    public void removeForceModels() {
        this.forceModels.clear();
    }

    public List<ForceModel> getAllForceModels() {
        return Collections.unmodifiableList(this.forceModels);
    }

    @Override
    public void setOrbitType(OrbitType orbitType) {
        super.setOrbitType(orbitType);
    }

    @Override
    public OrbitType getOrbitType() {
        return this.superGetOrbitType();
    }

    private OrbitType superGetOrbitType() {
        return super.getOrbitType();
    }

    @Override
    public void setPositionAngleType(PositionAngle positionAngleType) {
        super.setPositionAngleType(positionAngleType);
    }

    @Override
    public PositionAngle getPositionAngleType() {
        return super.getPositionAngleType();
    }

    public void setInitialState(FieldSpacecraftState<T> initialState) {
        this.resetInitialState(initialState);
    }

    @Override
    public void resetInitialState(FieldSpacecraftState<T> state) {
        super.resetInitialState(state);
        if (!this.hasNewtonianAttraction()) {
            this.setMu(state.getMu());
        }
        this.setStartDate(state.getDate());
    }

    @Override
    public TimeStampedFieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> date, Frame frame) {
        return this.propagate(date).getPVCoordinates(frame);
    }

    @Override
    protected FieldStateMapper<T> createMapper(FieldAbsoluteDate<T> referenceDate, T mu, OrbitType orbitType, PositionAngle positionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
        return new FieldOsculatingMapper(this, referenceDate, mu, orbitType, positionAngleType, attitudeProvider, frame);
    }

    @Override
    protected FieldAbstractIntegratedPropagator.MainStateEquations<T> getMainStateEquations(FieldODEIntegrator<T> integrator) {
        return new Main(integrator);
    }

    public static <T extends RealFieldElement<T>> double[][] tolerances(T dP, FieldOrbit<T> orbit, OrbitType type) {
        TimeStampedFieldPVCoordinates<T> pv = orbit.getPVCoordinates();
        RealFieldElement r2 = pv.getPosition().getNormSq();
        RealFieldElement v = pv.getVelocity().getNorm();
        RealFieldElement dV = (RealFieldElement)((RealFieldElement)dP.multiply(orbit.getMu())).divide(v.multiply((Object)r2));
        double[] absTol = new double[7];
        double[] relTol = new double[7];
        absTol[6] = 1.0E-6;
        if (type == OrbitType.CARTESIAN) {
            absTol[0] = dP.getReal();
            absTol[1] = dP.getReal();
            absTol[2] = dP.getReal();
            absTol[3] = dV.getReal();
            absTol[4] = dV.getReal();
            absTol[5] = dV.getReal();
        } else {
            RealFieldElement[][] jacobian = (RealFieldElement[][])MathArrays.buildArray((Field)dP.getField(), (int)6, (int)6);
            FieldOrbit<T> converted = type.convertType(orbit);
            converted.getJacobianWrtCartesian(PositionAngle.TRUE, jacobian);
            for (int i = 0; i < 6; ++i) {
                RealFieldElement[] row = jacobian[i];
                absTol[i] = ((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)row[0].abs()).multiply(dP)).add(((RealFieldElement)row[1].abs()).multiply(dP))).add(((RealFieldElement)row[2].abs()).multiply(dP))).add(((RealFieldElement)row[3].abs()).multiply((Object)dV))).add(((RealFieldElement)row[4].abs()).multiply((Object)dV))).add(((RealFieldElement)row[5].abs()).multiply((Object)dV))).getReal();
                if (!Double.isNaN(absTol[i])) continue;
                throw new OrekitException((Localizable)OrekitMessages.SINGULAR_JACOBIAN_FOR_ORBIT_TYPE, new Object[]{type});
            }
        }
        Arrays.fill(relTol, ((RealFieldElement)dP.divide(r2.sqrt())).getReal());
        return new double[][]{absTol, relTol};
    }

    private class Main
    implements FieldAbstractIntegratedPropagator.MainStateEquations<T>,
    FieldTimeDerivativesEquations<T> {
        private final T[] yDot;
        private FieldSpacecraftState<T> currentState;
        private T[][] jacobian;

        Main(FieldODEIntegrator<T> integrator) {
            this.yDot = (RealFieldElement[])MathArrays.buildArray(FieldNumericalPropagator.this.getField(), (int)7);
            this.jacobian = (RealFieldElement[][])MathArrays.buildArray(FieldNumericalPropagator.this.getField(), (int)6, (int)6);
            for (ForceModel forceModel : FieldNumericalPropagator.this.forceModels) {
                forceModel.getFieldEventsDetectors(FieldNumericalPropagator.this.getField()).forEach(detector -> FieldNumericalPropagator.this.setUpEventDetector(integrator, detector));
            }
            if (FieldNumericalPropagator.this.superGetOrbitType() == null) {
                for (int i = 0; i < this.jacobian.length; ++i) {
                    Arrays.fill(this.jacobian[i], FieldNumericalPropagator.this.getField().getZero());
                    this.jacobian[i][i] = (RealFieldElement)FieldNumericalPropagator.this.getField().getOne();
                }
            }
        }

        @Override
        public void init(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> target) {
            SpacecraftState stateD = initialState.toSpacecraftState();
            AbsoluteDate targetD = target.toAbsoluteDate();
            for (ForceModel forceModel : FieldNumericalPropagator.this.forceModels) {
                forceModel.init(stateD, targetD);
            }
        }

        @Override
        public T[] computeDerivatives(FieldSpacecraftState<T> state) {
            RealFieldElement zero = (RealFieldElement)state.getA().getField().getZero();
            this.currentState = state;
            Arrays.fill(this.yDot, zero);
            if (FieldNumericalPropagator.this.superGetOrbitType() != null) {
                this.currentState.getOrbit().getJacobianWrtCartesian(FieldNumericalPropagator.this.getPositionAngleType(), (RealFieldElement[][])this.jacobian);
            }
            for (ForceModel forceModel : FieldNumericalPropagator.this.forceModels) {
                forceModel.addContribution(state, this);
            }
            if (FieldNumericalPropagator.this.superGetOrbitType() == null) {
                FieldVector3D velocity = this.currentState.getPVCoordinates().getVelocity();
                this.yDot[0] = (RealFieldElement)this.yDot[0].add((Object)velocity.getX());
                this.yDot[1] = (RealFieldElement)this.yDot[1].add((Object)velocity.getY());
                this.yDot[2] = (RealFieldElement)this.yDot[2].add((Object)velocity.getZ());
            }
            return (RealFieldElement[])this.yDot.clone();
        }

        @Override
        public void addKeplerContribution(T mu) {
            if (FieldNumericalPropagator.this.superGetOrbitType() == null) {
                if (mu.getReal() > 0.0) {
                    FieldVector3D position = this.currentState.getPVCoordinates().getPosition();
                    double r2 = position.getNormSq().getReal();
                    double coeff = -mu.getReal() / (r2 * FastMath.sqrt((double)r2));
                    this.yDot[3] = (RealFieldElement)this.yDot[3].add(coeff * position.getX().getReal());
                    this.yDot[4] = (RealFieldElement)this.yDot[4].add(coeff * position.getY().getReal());
                    this.yDot[5] = (RealFieldElement)this.yDot[5].add(coeff * position.getZ().getReal());
                }
            } else {
                this.currentState.getOrbit().addKeplerContribution(FieldNumericalPropagator.this.getPositionAngleType(), (RealFieldElement)mu, (RealFieldElement[])this.yDot);
            }
        }

        @Override
        public void addNonKeplerianAcceleration(FieldVector3D<T> gamma) {
            for (int i = 0; i < 6; ++i) {
                T[] jRow = this.jacobian[i];
                this.yDot[i] = (RealFieldElement)this.yDot[i].add(jRow[3].linearCombination(jRow[3], (Object)gamma.getX(), jRow[4], (Object)gamma.getY(), jRow[5], (Object)gamma.getZ()));
            }
        }

        @Override
        public void addMassDerivative(T q) {
            if (q.getReal() > 0.0) {
                throw new OrekitIllegalArgumentException(OrekitMessages.POSITIVE_FLOW_RATE, q);
            }
            this.yDot[6] = (RealFieldElement)this.yDot[6].add(q);
        }
    }

    private static class FieldOsculatingMapper
    extends FieldStateMapper<T> {
        final /* synthetic */ FieldNumericalPropagator this$0;

        FieldOsculatingMapper(FieldAbsoluteDate<T> referenceDate, T mu, OrbitType orbitType, PositionAngle positionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
            this.this$0 = var1_1;
            super(referenceDate, mu, orbitType, positionAngleType, attitudeProvider, frame);
        }

        @Override
        public FieldSpacecraftState<T> mapArrayToState(FieldAbsoluteDate<T> date, T[] y, T[] yDot, PropagationType type) {
            Object mass = y[6];
            if (mass.getReal() <= 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.SPACECRAFT_MASS_BECOMES_NEGATIVE, mass);
            }
            if (this.this$0.superGetOrbitType() == null) {
                FieldAbsolutePVCoordinates absPva;
                FieldVector3D p = new FieldVector3D(y[0], y[1], y[2]);
                FieldVector3D v = new FieldVector3D(y[3], y[4], y[5]);
                if (yDot == null) {
                    absPva = new FieldAbsolutePVCoordinates(this.getFrame(), new TimeStampedFieldPVCoordinates(date, p, v, FieldVector3D.getZero(date.getField())));
                } else {
                    FieldVector3D a = new FieldVector3D(yDot[3], yDot[4], yDot[5]);
                    absPva = new FieldAbsolutePVCoordinates(this.getFrame(), new TimeStampedFieldPVCoordinates(date, p, v, a));
                }
                FieldAttitude attitude = this.getAttitudeProvider().getAttitude(absPva, date, this.getFrame());
                return new FieldSpacecraftState(absPva, attitude, mass);
            }
            FieldOrbit orbit = this.this$0.superGetOrbitType().mapArrayToOrbit((RealFieldElement[])y, (RealFieldElement[])yDot, super.getPositionAngleType(), date, (RealFieldElement)this.getMu(), this.getFrame());
            FieldAttitude attitude = this.getAttitudeProvider().getAttitude(orbit, date, this.getFrame());
            return new FieldSpacecraftState(orbit, attitude, mass);
        }

        @Override
        public void mapStateToArray(FieldSpacecraftState<T> state, T[] y, T[] yDot) {
            if (this.this$0.superGetOrbitType() == null) {
                FieldVector3D p = state.getAbsPVA().getPosition();
                FieldVector3D v = state.getAbsPVA().getVelocity();
                y[0] = p.getX();
                y[1] = p.getY();
                y[2] = p.getZ();
                y[3] = v.getX();
                y[4] = v.getY();
                y[5] = v.getZ();
                y[6] = state.getMass();
            } else {
                this.this$0.superGetOrbitType().mapOrbitToArray(state.getOrbit(), super.getPositionAngleType(), (RealFieldElement[])y, (RealFieldElement[])yDot);
                y[6] = state.getMass();
            }
        }
    }
}

