/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.MultiSatStepHandler;
import org.orekit.propagation.sampling.OrekitStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;

public class PropagatorsParallelizer {
    private static long MAX_WAIT = 10L;
    private final List<Propagator> propagators;
    private final MultiSatStepHandler globalHandler;

    public PropagatorsParallelizer(List<Propagator> propagators, MultiSatStepHandler globalHandler) {
        this.propagators = propagators;
        this.globalHandler = globalHandler;
    }

    public List<Propagator> getPropagators() {
        return Collections.unmodifiableList(this.propagators);
    }

    public List<SpacecraftState> propagate(AbsoluteDate start, AbsoluteDate target) {
        if (this.propagators.size() == 1) {
            this.propagators.get(0).setMasterMode(new SinglePropagatorHandler(this.globalHandler));
            return Collections.singletonList(this.propagators.get(0).propagate(start, target));
        }
        double sign = FastMath.copySign((double)1.0, (double)target.durationFrom(start));
        int n = this.propagators.size();
        ArrayList<SynchronousQueue<SpacecraftState>> initQueues = new ArrayList<SynchronousQueue<SpacecraftState>>(n);
        ArrayList<SynchronousQueue<StepHandlingParameters>> shpQueues = new ArrayList<SynchronousQueue<StepHandlingParameters>>(n);
        for (Propagator propagator : this.propagators) {
            SynchronousQueue<SpacecraftState> initQueue = new SynchronousQueue<SpacecraftState>();
            initQueues.add(initQueue);
            SynchronousQueue<StepHandlingParameters> shpQueue = new SynchronousQueue<StepHandlingParameters>();
            shpQueues.add(shpQueue);
            propagator.setMasterMode(new MultiplePropagatorsHandler(initQueue, shpQueue));
        }
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        ArrayList<Future<SpacecraftState>> futures = new ArrayList<Future<SpacecraftState>>(n);
        ArrayList<SpacecraftState> initialStates = new ArrayList<SpacecraftState>(n);
        ArrayList stepHandlingParameters = new ArrayList(n);
        ArrayList<OrekitStepInterpolator> restricted = new ArrayList<OrekitStepInterpolator>(n);
        ArrayList<SpacecraftState> finalStates = new ArrayList<SpacecraftState>(n);
        for (int i = 0; i < n; ++i) {
            Propagator propagator = this.propagators.get(i);
            Future<SpacecraftState> future = executorService.submit(() -> propagator.propagate(start, target));
            futures.add(future);
            initialStates.add((SpacecraftState)this.getParameters(i, future, (SynchronousQueue)initQueues.get(i)));
            stepHandlingParameters.add(this.getParameters(i, future, (SynchronousQueue)shpQueues.get(i)));
            restricted.add(null);
            finalStates.add(null);
        }
        AbsoluteDate previousDate = start;
        this.globalHandler.init(initialStates, target);
        boolean isLast = false;
        while (!isLast) {
            int i;
            int selected = -1;
            AbsoluteDate selectedStepEnd = null;
            for (i = 0; i < n; ++i) {
                AbsoluteDate stepEnd = ((StepHandlingParameters)stepHandlingParameters.get(i)).getDate();
                if (selected >= 0 && !(sign * selectedStepEnd.durationFrom(stepEnd) > 0.0)) continue;
                selected = i;
                selectedStepEnd = stepEnd;
            }
            for (i = 0; i < n; ++i) {
                OrekitStepInterpolator interpolator = ((StepHandlingParameters)stepHandlingParameters.get(i)).interpolator;
                SpacecraftState previousState = interpolator.getInterpolatedState(previousDate);
                SpacecraftState currentState = interpolator.getInterpolatedState(selectedStepEnd);
                restricted.set(i, interpolator.restrictStep(previousState, currentState));
            }
            isLast = ((StepHandlingParameters)stepHandlingParameters.get(selected)).isLast;
            this.globalHandler.handleStep(restricted, isLast);
            if (!isLast) {
                stepHandlingParameters.set(selected, this.getParameters(selected, (Future)futures.get(selected), (SynchronousQueue)shpQueues.get(selected)));
            }
            previousDate = selectedStepEnd;
        }
        executorService.shutdownNow();
        for (int i = 0; i < n; ++i) {
            try {
                finalStates.set(i, (SpacecraftState)((Future)futures.get(i)).get());
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                this.manageException(e);
                finalStates.set(i, ((StepHandlingParameters)stepHandlingParameters.get(i)).interpolator.getInterpolatedState(previousDate));
            }
        }
        return finalStates;
    }

    private <T> T getParameters(int index, Future<SpacecraftState> future, SynchronousQueue<T> queue) {
        try {
            T params = null;
            while (params == null && !future.isDone()) {
                params = queue.poll(MAX_WAIT, TimeUnit.MILLISECONDS);
            }
            if (params == null) {
                future.get();
            }
            return params;
        }
        catch (InterruptedException | ExecutionException e) {
            this.manageException(e);
            return null;
        }
    }

    private void manageException(Exception exception) {
        if (exception.getCause() instanceof PropagatorStoppingException) {
            return;
        }
        if (exception.getCause() instanceof OrekitException) {
            throw (OrekitException)exception.getCause();
        }
        throw new OrekitException(exception.getCause(), (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, exception.getLocalizedMessage());
    }

    private static class StepHandlingParameters
    implements TimeStamped {
        private final OrekitStepInterpolator interpolator;
        private final boolean isLast;

        StepHandlingParameters(OrekitStepInterpolator interpolator, boolean isLast) {
            this.interpolator = interpolator;
            this.isLast = isLast;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.interpolator.getCurrentState().getDate();
        }
    }

    private static class MultiplePropagatorsHandler
    implements OrekitStepHandler {
        private final SynchronousQueue<SpacecraftState> initQueue;
        private final SynchronousQueue<StepHandlingParameters> shpQueue;

        MultiplePropagatorsHandler(SynchronousQueue<SpacecraftState> initQueue, SynchronousQueue<StepHandlingParameters> shpQueue) {
            this.initQueue = initQueue;
            this.shpQueue = shpQueue;
        }

        @Override
        public void init(SpacecraftState s0, AbsoluteDate t) {
            try {
                this.initQueue.put(s0);
            }
            catch (InterruptedException ie) {
                throw new PropagatorStoppingException(ie);
            }
        }

        @Override
        public void handleStep(OrekitStepInterpolator interpolator, boolean isLast) {
            try {
                this.shpQueue.put(new StepHandlingParameters(interpolator, isLast));
            }
            catch (InterruptedException ie) {
                throw new PropagatorStoppingException(ie);
            }
        }
    }

    private static class SinglePropagatorHandler
    implements OrekitStepHandler {
        private final MultiSatStepHandler globalHandler;

        SinglePropagatorHandler(MultiSatStepHandler globalHandler) {
            this.globalHandler = globalHandler;
        }

        @Override
        public void init(SpacecraftState s0, AbsoluteDate t) {
            this.globalHandler.init(Collections.singletonList(s0), t);
        }

        @Override
        public void handleStep(OrekitStepInterpolator interpolator, boolean isLast) {
            this.globalHandler.handleStep(Collections.singletonList(interpolator), isLast);
        }
    }

    private static class PropagatorStoppingException
    extends OrekitException {
        private static final long serialVersionUID = 20170629L;

        PropagatorStoppingException(InterruptedException ie) {
            super(ie, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, ie.getLocalizedMessage());
        }
    }
}

