/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.CombinatoricsUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.models.earth.troposphere.MappingFunction;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.ParameterDriver;

public class GlobalMappingFunctionModel
implements MappingFunction {
    private final double latitude;
    private final double longitude;
    private final TimeScale utc;

    @DefaultDataContext
    public GlobalMappingFunctionModel(double latitude, double longitude) {
        this(latitude, longitude, DataContext.getDefault().getTimeScales().getUTC());
    }

    public GlobalMappingFunctionModel(double latitude, double longitude, TimeScale utc) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.utc = utc;
    }

    @Override
    public double[] mappingFactors(double elevation, double height, double[] parameters, AbsoluteDate date) {
        double psi;
        double c11h;
        double c10h;
        DateTimeComponents dtc = date.getComponents(this.utc);
        int dofyear = dtc.getDate().getDayOfYear();
        double bh = 0.0029;
        double c0h = 0.062;
        if (FastMath.sin((double)this.latitude) > 0.0) {
            c10h = 0.001;
            c11h = 0.005;
            psi = 0.0;
        } else {
            c10h = 0.002;
            c11h = 0.007;
            psi = Math.PI;
        }
        double t0 = 28.0;
        if (this.latitude < 0.0) {
            t0 += 183.0;
        }
        double coef = ((double)(dofyear + 1) - t0) / 365.25 * 2.0 * Math.PI + psi;
        double ch = 0.062 + ((FastMath.cos((double)coef) + 1.0) * (c11h / 2.0) + c10h) * (1.0 - FastMath.cos((double)this.latitude));
        double bw = 0.00146;
        double cw = 0.04391;
        int degree = 9;
        int order = 9;
        LegendrePolynomials p = new LegendrePolynomials(9, 9);
        double a0Hydro = 0.0;
        double amplHydro = 0.0;
        double a0Wet = 0.0;
        double amplWet = 0.0;
        ABCoefficients abCoef = new ABCoefficients();
        int j = 0;
        for (int n = 0; n <= 9; ++n) {
            for (int m = 0; m <= n; ++m) {
                a0Hydro += (abCoef.getAHMean(j) * p.getPnm(n, m) * FastMath.cos((double)((double)m * this.longitude)) + abCoef.getBHMean(j) * p.getPnm(n, m) * FastMath.sin((double)((double)m * this.longitude))) * 1.0E-5;
                a0Wet += (abCoef.getAWMean(j) * p.getPnm(n, m) * FastMath.cos((double)((double)m * this.longitude)) + abCoef.getBWMean(j) * p.getPnm(n, m) * FastMath.sin((double)((double)m * this.longitude))) * 1.0E-5;
                amplHydro += (abCoef.getAHAmplitude(j) * p.getPnm(n, m) * FastMath.cos((double)((double)m * this.longitude)) + abCoef.getBHAmplitude(j) * p.getPnm(n, m) * FastMath.sin((double)((double)m * this.longitude))) * 1.0E-5;
                amplWet += (abCoef.getAWAmplitude(j) * p.getPnm(n, m) * FastMath.cos((double)((double)m * this.longitude)) + abCoef.getBWAmplitude(j) * p.getPnm(n, m) * FastMath.sin((double)((double)m * this.longitude))) * 1.0E-5;
                ++j;
            }
        }
        double ah = a0Hydro + amplHydro * FastMath.cos((double)(coef - psi));
        double aw = a0Wet + amplWet * FastMath.cos((double)(coef - psi));
        double[] function = new double[]{this.computeFunction(ah, 0.0029, ch, elevation), this.computeFunction(aw, 0.00146, 0.04391, elevation)};
        double correction = this.computeHeightCorrection(elevation, height);
        function[0] = function[0] + correction;
        return function;
    }

    @Override
    public <T extends RealFieldElement<T>> T[] mappingFactors(T elevation, T height, T[] parameters, FieldAbsoluteDate<T> date) {
        RealFieldElement psi;
        RealFieldElement c11h;
        RealFieldElement c10h;
        DateTimeComponents dtc = date.getComponents(this.utc);
        int dofyear = dtc.getDate().getDayOfYear();
        Field<T> field = date.getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement bh = (RealFieldElement)zero.add(0.0029);
        RealFieldElement c0h = (RealFieldElement)zero.add(0.062);
        if (FastMath.sin((double)this.latitude) > 0.0) {
            c10h = (RealFieldElement)zero.add(0.001);
            c11h = (RealFieldElement)zero.add(0.005);
            psi = zero;
        } else {
            c10h = (RealFieldElement)zero.add(0.002);
            c11h = (RealFieldElement)zero.add(0.007);
            psi = (RealFieldElement)zero.add(Math.PI);
        }
        double t0 = 28.0;
        if (this.latitude < 0.0) {
            t0 += 183.0;
        }
        RealFieldElement coef = (RealFieldElement)psi.add(((double)(dofyear + 1) - t0) / 365.25 * 2.0 * Math.PI);
        RealFieldElement ch = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c11h.divide(2.0)).multiply(FastMath.cos((RealFieldElement)coef).add(1.0))).add((Object)c10h)).multiply(1.0 - FastMath.cos((double)this.latitude))).add((Object)c0h);
        RealFieldElement bw = (RealFieldElement)zero.add(0.00146);
        RealFieldElement cw = (RealFieldElement)zero.add(0.04391);
        int degree = 9;
        int order = 9;
        LegendrePolynomials p = new LegendrePolynomials(9, 9);
        RealFieldElement a0Hydro = zero;
        RealFieldElement amplHydro = zero;
        RealFieldElement a0Wet = zero;
        RealFieldElement amplWet = zero;
        ABCoefficients abCoef = new ABCoefficients();
        int j = 0;
        for (int n = 0; n <= 9; ++n) {
            for (int m = 0; m <= n; ++m) {
                a0Hydro = (RealFieldElement)a0Hydro.add((abCoef.getAHMean(j) * p.getPnm(n, m) * FastMath.cos((double)((double)m * this.longitude)) + abCoef.getBHMean(j) * p.getPnm(n, m) * FastMath.sin((double)((double)m * this.longitude))) * 1.0E-5);
                a0Wet = (RealFieldElement)a0Wet.add((abCoef.getAWMean(j) * p.getPnm(n, m) * FastMath.cos((double)((double)m * this.longitude)) + abCoef.getBWMean(j) * p.getPnm(n, m) * FastMath.sin((double)((double)m * this.longitude))) * 1.0E-5);
                amplHydro = (RealFieldElement)amplHydro.add((abCoef.getAHAmplitude(j) * p.getPnm(n, m) * FastMath.cos((double)((double)m * this.longitude)) + abCoef.getBHAmplitude(j) * p.getPnm(n, m) * FastMath.sin((double)((double)m * this.longitude))) * 1.0E-5);
                amplWet = (RealFieldElement)amplWet.add((abCoef.getAWAmplitude(j) * p.getPnm(n, m) * FastMath.cos((double)((double)m * this.longitude)) + abCoef.getBWAmplitude(j) * p.getPnm(n, m) * FastMath.sin((double)((double)m * this.longitude))) * 1.0E-5);
                ++j;
            }
        }
        RealFieldElement ah = (RealFieldElement)a0Hydro.add(amplHydro.multiply((Object)FastMath.cos((RealFieldElement)((RealFieldElement)coef.subtract((Object)psi)))));
        RealFieldElement aw = (RealFieldElement)a0Wet.add(amplWet.multiply((Object)FastMath.cos((RealFieldElement)((RealFieldElement)coef.subtract((Object)psi)))));
        RealFieldElement[] function = (RealFieldElement[])MathArrays.buildArray(field, (int)2);
        function[0] = this.computeFunction(ah, bh, ch, elevation);
        function[1] = this.computeFunction(aw, bw, cw, elevation);
        T correction = this.computeHeightCorrection(elevation, height, field);
        function[0] = (RealFieldElement)function[0].add(correction);
        return function;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    private double computeFunction(double a, double b, double c, double elevation) {
        double sinE = FastMath.sin((double)elevation);
        double numMP = 1.0 + a / (1.0 + b / (1.0 + c));
        double denMP = sinE + a / (sinE + b / (sinE + c));
        double fElevation = numMP / denMP;
        return fElevation;
    }

    private <T extends RealFieldElement<T>> T computeFunction(T a, T b, T c, T elevation) {
        RealFieldElement sinE = FastMath.sin(elevation);
        RealFieldElement numMP = (RealFieldElement)((RealFieldElement)a.divide(((RealFieldElement)b.divide(c.add(1.0))).add(1.0))).add(1.0);
        RealFieldElement denMP = (RealFieldElement)((RealFieldElement)a.divide(((RealFieldElement)b.divide(c.add((Object)sinE))).add((Object)sinE))).add((Object)sinE);
        RealFieldElement fElevation = (RealFieldElement)numMP.divide((Object)denMP);
        return (T)fElevation;
    }

    private double computeHeightCorrection(double elevation, double height) {
        double fixedHeight = FastMath.max((double)0.0, (double)height);
        double sinE = FastMath.sin((double)elevation);
        double function = this.computeFunction(2.53E-5, 0.00549, 0.00114, elevation);
        double dmdh = 1.0 / sinE - function;
        double correction = dmdh * (fixedHeight / 1000.0);
        return correction;
    }

    private <T extends RealFieldElement<T>> T computeHeightCorrection(T elevation, T height, Field<T> field) {
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement fixedHeight = FastMath.max((RealFieldElement)zero, height);
        RealFieldElement sinE = FastMath.sin(elevation);
        RealFieldElement function = this.computeFunction((RealFieldElement)zero.add(2.53E-5), (RealFieldElement)zero.add(0.00549), (RealFieldElement)zero.add(0.00114), elevation);
        RealFieldElement dmdh = (RealFieldElement)((RealFieldElement)sinE.reciprocal()).subtract((Object)function);
        RealFieldElement correction = (RealFieldElement)dmdh.multiply(fixedHeight.divide(1000.0));
        return (T)correction;
    }

    private static class ABCoefficients {
        private static final double[] AH_MEAN = new double[]{125.17, 0.8503, 0.06936, -6.76, 0.1771, 0.0113, 0.5963, 0.01808, 0.002801, -0.001414, -1.212, 0.093, 0.003683, 0.001095, 4.671E-5, 0.3959, -0.03867, 0.005413, -5.289E-4, 3.229E-4, 2.067E-5, 0.3, 0.02031, 0.0059, 4.573E-4, -7.619E-5, 2.327E-6, 3.845E-6, 0.1182, 0.01158, 0.005445, 6.219E-5, 4.204E-6, -2.093E-6, 1.54E-7, -4.28E-8, -0.4751, -0.0349, 0.001758, 4.019E-4, -2.799E-6, -1.287E-6, 5.468E-7, 7.58E-8, -6.3E-9, -0.116, 0.008301, 8.771E-4, 9.955E-5, -1.718E-6, -2.012E-6, 1.17E-8, 1.79E-8, -1.3E-9, 1.0E-10};
        private static final double[] BH_MEAN = new double[]{0.0, 0.0, 0.03249, 0.0, 0.03324, 0.0185, 0.0, -0.1115, 0.02519, 0.004923, 0.0, 0.02737, 0.01595, -7.332E-4, 1.933E-4, 0.0, -0.04796, 0.006381, -1.599E-4, -3.685E-4, 1.815E-5, 0.0, 0.07033, 0.002426, -0.001111, -1.357E-4, -7.828E-6, 2.547E-6, 0.0, 0.005779, 0.003133, -5.312E-4, -2.028E-5, 2.323E-7, -9.1E-8, -1.65E-8, 0.0, 0.03688, -8.638E-4, -8.514E-5, -2.828E-5, 5.403E-7, 4.39E-7, 1.35E-8, 1.8E-9, 0.0, -0.02736, -2.977E-4, 8.113E-5, 2.329E-7, 8.451E-7, 4.49E-8, -8.1E-9, -1.5E-9, 2.0E-10};
        private static final double[] AH_AMPL = new double[]{-0.2738, -2.837, 0.01298, -0.3588, 0.02413, 0.03427, -0.7624, 0.07272, 0.0216, -0.003385, 0.4424, 0.03722, 0.02195, -0.001503, 2.426E-4, 0.3013, 0.05762, 0.01019, -4.476E-4, 6.79E-5, 3.227E-5, 0.3123, -0.03535, 0.00484, 3.025E-6, -4.363E-5, 2.854E-7, -1.286E-6, -0.6725, -0.0373, 8.964E-4, 1.399E-4, -3.99E-6, 7.431E-6, -2.796E-7, -1.601E-7, 0.04068, -0.01352, 7.282E-4, 9.594E-5, 2.07E-6, -9.62E-8, -2.742E-7, -6.37E-8, -6.3E-9, 0.08625, -0.005971, 4.705E-4, 2.335E-5, 4.226E-6, 2.475E-7, -8.85E-8, -3.6E-8, -2.9E-9, 0.0};
        private static final double[] BH_AMPL = new double[]{0.0, 0.0, -0.1136, 0.0, -0.1868, -0.01399, 0.0, -0.1043, 0.01175, -0.00224, 0.0, -0.03222, 0.01333, -0.002647, -2.316E-5, 0.0, 0.05339, 0.01107, -0.003116, -1.079E-4, -1.299E-5, 0.0, 0.004861, 0.008891, -6.448E-4, -1.279E-5, 6.358E-6, -1.417E-7, 0.0, 0.03041, 0.00115, -8.743E-4, -2.781E-5, 6.367E-7, -1.14E-8, -4.2E-8, 0.0, -0.02982, -0.003, 1.394E-5, -3.29E-5, -1.705E-7, 7.44E-8, 2.72E-8, -6.6E-9, 0.0, 0.01236, -9.981E-4, -3.792E-5, -1.355E-5, 1.162E-6, -1.789E-7, 1.47E-8, -2.4E-9, -4.0E-10};
        private static final double[] AW_MEAN = new double[]{56.4, 1.555, -1.011, -3.975, 0.03171, 0.1065, 0.6175, 0.1376, 0.04229, 0.003028, 1.688, -0.1692, 0.05478, 0.02473, 6.059E-4, 2.278, 0.006614, -3.505E-4, -0.006697, 8.402E-4, 7.033E-4, -3.236, 0.2184, -0.04611, -0.01613, -0.001604, 5.42E-5, 7.922E-5, -0.2711, -0.4406, -0.03376, -0.002801, -4.09E-4, -2.056E-5, 6.894E-6, 2.317E-6, 1.941, -0.2562, 0.01598, 0.005449, 3.544E-4, 1.148E-5, 7.503E-6, -5.667E-7, -3.66E-8, 0.8683, -0.05931, -0.001864, -1.277E-4, 2.029E-4, 1.269E-5, 1.629E-6, 9.66E-8, -1.015E-7, -5.0E-10};
        private static final double[] BW_MEAN = new double[]{0.0, 0.0, 0.2592, 0.0, 0.02974, -0.5471, 0.0, -0.5926, -0.103, -0.01567, 0.0, 0.171, 0.09025, 0.02689, 0.002243, 0.0, 0.3439, 0.02402, 0.00541, 0.001601, 9.669E-5, 0.0, 0.09502, -0.03063, -0.001055, -1.067E-4, -1.13E-4, 2.124E-5, 0.0, -0.3129, 0.008463, 2.253E-4, 7.413E-5, -9.376E-5, -1.606E-6, 2.06E-6, 0.0, 0.2739, 0.001167, -2.246E-5, -1.287E-4, -2.438E-5, -7.561E-7, 1.158E-6, 4.95E-8, 0.0, -0.1344, 0.005342, 3.775E-4, -6.756E-5, -1.686E-6, -1.184E-6, 2.768E-7, 2.73E-8, 5.7E-9};
        private static final double[] AW_AMPL = new double[]{0.1023, -2.695, 0.3417, -0.1405, 0.3175, 0.2116, 3.536, -0.1505, -0.0166, 0.02967, 0.3819, -0.1695, -0.07444, 0.007409, -0.006262, -1.836, -0.01759, -0.06256, -0.002371, 7.947E-4, 1.501E-4, -0.8603, -0.136, -0.03629, -0.003706, -2.976E-4, 1.857E-5, 3.021E-5, 2.248, -0.1178, 0.01255, 0.001134, -2.161E-4, -5.817E-6, 8.836E-7, -1.769E-7, 0.7313, -0.1188, 0.01145, 0.001011, 1.083E-4, 2.57E-6, -2.14E-6, -5.71E-8, 2.0E-8, -1.632, -0.006948, -0.003893, 8.592E-4, 7.577E-5, 4.539E-6, -3.852E-7, -2.213E-7, -1.37E-8, 5.8E-9};
        private static final double[] BW_AMPL = new double[]{0.0, 0.0, -0.08865, 0.0, -0.4309, 0.0634, 0.0, 0.1162, 0.06176, -0.004234, 0.0, 0.253, 0.04017, -0.006204, 0.004977, 0.0, -0.1737, -0.005638, 1.488E-4, 4.857E-4, -1.809E-4, 0.0, -0.1514, -0.01685, 0.005333, -7.611E-5, 2.394E-5, 8.195E-6, 0.0, 0.09326, -0.01275, -3.071E-4, 5.374E-5, -3.391E-5, -7.436E-6, 6.747E-7, 0.0, -0.08637, -0.003807, -6.833E-4, -3.861E-5, -2.268E-5, 1.454E-6, 3.86E-7, -1.068E-7, 0.0, -0.02658, -0.001947, 7.131E-4, -3.506E-5, 1.885E-7, 5.792E-7, 3.99E-8, 2.0E-8, -5.7E-9};

        ABCoefficients() {
        }

        public double getAHMean(int index) {
            return AH_MEAN[index];
        }

        public double getBHMean(int index) {
            return BH_MEAN[index];
        }

        public double getAWMean(int index) {
            return AW_MEAN[index];
        }

        public double getBWMean(int index) {
            return BW_MEAN[index];
        }

        public double getAHAmplitude(int index) {
            return AH_AMPL[index];
        }

        public double getBHAmplitude(int index) {
            return BH_AMPL[index];
        }

        public double getAWAmplitude(int index) {
            return AW_AMPL[index];
        }

        public double getBWAmplitude(int index) {
            return BW_AMPL[index];
        }
    }

    private class LegendrePolynomials {
        private double[][] pCoef;

        LegendrePolynomials(int degree, int order) {
            this.pCoef = new double[degree + 1][order + 1];
            double t = FastMath.sin((double)GlobalMappingFunctionModel.this.latitude);
            double t2 = t * t;
            for (int n = 0; n <= degree; ++n) {
                for (int m = 0; m <= FastMath.min((int)n, (int)order); ++m) {
                    int r = (n - m) / 2;
                    double sum = 0.0;
                    for (int k = 0; k <= r; ++k) {
                        double term = FastMath.pow((double)-1.0, (int)k) * CombinatoricsUtils.factorialDouble((int)(2 * n - 2 * k)) / (CombinatoricsUtils.factorialDouble((int)k) * CombinatoricsUtils.factorialDouble((int)(n - k)) * CombinatoricsUtils.factorialDouble((int)(n - m - 2 * k))) * FastMath.pow((double)t, (int)(n - m - 2 * k));
                        sum += term;
                    }
                    this.pCoef[n][m] = FastMath.pow((double)2.0, (int)(-n)) * FastMath.pow((double)(1.0 - t2), (double)(0.5 * (double)m)) * sum;
                }
            }
        }

        public double getPnm(int n, int m) {
            return this.pCoef[n][m];
        }
    }
}

