/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.AbstractEopLoader;
import org.orekit.frames.AbstractEopParser;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.EOPHistoryLoader;
import org.orekit.frames.EopParserLoader;
import org.orekit.frames.ITRFVersionLoader;
import org.orekit.frames.ItrfVersionProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeScale;
import org.orekit.utils.IERSConventions;

class EOPC04FilesLoader
extends AbstractEopLoader
implements EOPHistoryLoader {
    private static final Pattern COLUMNS_HEADER_PATTERN = Pattern.compile("^ *Date +MJD +x +y +UT1-UTC +LOD +((?:dPsi +dEps)|(?:dX +dY)) .*");
    private static final Pattern DATA_LINE_PATTERN = Pattern.compile("^\\d+ +\\d+ +\\d+ +\\d+(?: +-?\\d+\\.\\d+){12}$");
    private static final int YEAR_FIELD = 0;
    private static final int MONTH_FIELD = 1;
    private static final int DAY_FIELD = 2;
    private static final int MJD_FIELD = 3;
    private static final int POLE_X_FIELD = 4;
    private static final int POLE_Y_FIELD = 5;
    private static final int UT1_UTC_FIELD = 6;
    private static final int LOD_FIELD = 7;
    private static final int NUT_0_FIELD = 8;
    private static final int NUT_1_FIELD = 9;

    EOPC04FilesLoader(String supportedNames, DataProvidersManager manager, Supplier<TimeScale> utcSupplier) {
        super(supportedNames, manager, utcSupplier);
    }

    @Override
    public void fillHistory(IERSConventions.NutationCorrectionConverter converter, SortedSet<EOPEntry> history) {
        ITRFVersionLoader itrfVersionProvider = new ITRFVersionLoader("itrf-versions.conf", this.getDataProvidersManager());
        Parser parser = new Parser(converter, itrfVersionProvider, this.getUtc());
        EopParserLoader loader = new EopParserLoader(parser);
        this.feed(loader);
        history.addAll(loader.getEop());
    }

    static class Parser
    extends AbstractEopParser {
        Parser(IERSConventions.NutationCorrectionConverter converter, ItrfVersionProvider itrfVersionProvider, TimeScale utc) {
            super(converter, itrfVersionProvider, utc);
        }

        @Override
        public Collection<EOPEntry> parse(InputStream input, String name) throws IOException, OrekitException {
            ArrayList<EOPEntry> history = new ArrayList<EOPEntry>();
            ITRFVersionLoader.ITRFVersionConfiguration configuration = null;
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            int lineNumber = 0;
            boolean inHeader = true;
            boolean isNonRotatingOrigin = false;
            String line = reader.readLine();
            while (line != null) {
                Matcher matcher;
                ++lineNumber;
                boolean parsed = false;
                if (inHeader && (matcher = COLUMNS_HEADER_PATTERN.matcher(line)).matches() && matcher.group(1).startsWith("dX")) {
                    isNonRotatingOrigin = true;
                }
                if (DATA_LINE_PATTERN.matcher(line).matches()) {
                    double[] equinox;
                    double[] nro;
                    inHeader = false;
                    String[] fields = line.split(" +");
                    DateComponents dc = new DateComponents(Integer.parseInt(fields[YEAR_FIELD]), Integer.parseInt(fields[MONTH_FIELD]), Integer.parseInt(fields[DAY_FIELD]));
                    int mjd = Integer.parseInt(fields[MJD_FIELD]);
                    if (dc.getMJD() != mjd) {
                        throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_DATES_IN_IERS_FILE, name, dc.getYear(), dc.getMonth(), dc.getDay(), mjd);
                    }
                    AbsoluteDate date = new AbsoluteDate(dc, this.getUtc());
                    double x = Double.parseDouble(fields[POLE_X_FIELD]) * 4.84813681109536E-6;
                    double y = Double.parseDouble(fields[POLE_Y_FIELD]) * 4.84813681109536E-6;
                    double dtu1 = Double.parseDouble(fields[UT1_UTC_FIELD]);
                    double lod = Double.parseDouble(fields[LOD_FIELD]);
                    if (isNonRotatingOrigin) {
                        nro = new double[]{Double.parseDouble(fields[NUT_0_FIELD]) * 4.84813681109536E-6, Double.parseDouble(fields[NUT_1_FIELD]) * 4.84813681109536E-6};
                        equinox = this.getConverter().toEquinox(date, nro[0], nro[1]);
                    } else {
                        equinox = new double[]{Double.parseDouble(fields[NUT_0_FIELD]) * 4.84813681109536E-6, Double.parseDouble(fields[NUT_1_FIELD]) * 4.84813681109536E-6};
                        nro = this.getConverter().toNonRotating(date, equinox[0], equinox[1]);
                    }
                    if (configuration == null || !configuration.isValid(mjd)) {
                        configuration = this.getItrfVersionProvider().getConfiguration(name, mjd);
                    }
                    history.add(new EOPEntry(mjd, dtu1, lod, x, y, equinox[0], equinox[1], nro[0], nro[1], configuration.getVersion(), date));
                    parsed = true;
                }
                if (!inHeader && !parsed) {
                    throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                }
                line = reader.readLine();
            }
            if (inHeader) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_IERS_DATA_FILE, name);
            }
            return history;
        }
    }
}

