/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.EOPBasedTransformProvider;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeVectorFunction;

class CIRFProvider
implements EOPBasedTransformProvider {
    private static final long serialVersionUID = 20130806L;
    private final transient TimeVectorFunction xysPxy2Function;
    private final EOPHistory eopHistory;

    CIRFProvider(EOPHistory eopHistory) {
        this.xysPxy2Function = eopHistory.getConventions().getXYSpXY2Function(eopHistory.getTimeScales());
        this.eopHistory = eopHistory;
    }

    @Override
    public EOPHistory getEOPHistory() {
        return this.eopHistory;
    }

    @Override
    public CIRFProvider getNonInterpolatingProvider() {
        return new CIRFProvider(this.eopHistory.getNonInterpolatingEOPHistory());
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        double[] xys = this.xysPxy2Function.value(date);
        double[] dxdy = this.eopHistory.getNonRotatinOriginNutationCorrection(date);
        double xCurrent = xys[0] + dxdy[0];
        double yCurrent = xys[1] + dxdy[1];
        double sCurrent = xys[2] - xCurrent * yCurrent / 2.0;
        double x2Py2 = xCurrent * xCurrent + yCurrent * yCurrent;
        double zP1 = 1.0 + FastMath.sqrt((double)(1.0 - x2Py2));
        double r = FastMath.sqrt((double)x2Py2);
        double sPe2 = 0.5 * (sCurrent + FastMath.atan2((double)yCurrent, (double)xCurrent));
        double cos = FastMath.cos((double)sPe2);
        double sin = FastMath.sin((double)sPe2);
        double xPr = xCurrent + r;
        double xPrCos = xPr * cos;
        double xPrSin = xPr * sin;
        double yCos = yCurrent * cos;
        double ySin = yCurrent * sin;
        Rotation bpn = new Rotation(zP1 * (xPrCos + ySin), -r * (yCos + xPrSin), r * (xPrCos - ySin), zP1 * (yCos - xPrSin), true);
        return new Transform(date, bpn, Vector3D.ZERO);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        RealFieldElement[] xys = this.xysPxy2Function.value(date);
        RealFieldElement[] dxdy = this.eopHistory.getNonRotatinOriginNutationCorrection(date);
        RealFieldElement xCurrent = (RealFieldElement)xys[0].add((Object)dxdy[0]);
        RealFieldElement yCurrent = (RealFieldElement)xys[1].add((Object)dxdy[1]);
        RealFieldElement sCurrent = (RealFieldElement)xys[2].subtract(((RealFieldElement)xCurrent.multiply((Object)yCurrent)).multiply(0.5));
        RealFieldElement x2Py2 = (RealFieldElement)((RealFieldElement)xCurrent.multiply((Object)xCurrent)).add(yCurrent.multiply((Object)yCurrent));
        RealFieldElement zP1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)x2Py2.subtract(1.0)).negate()).sqrt()).add(1.0);
        RealFieldElement r = (RealFieldElement)x2Py2.sqrt();
        RealFieldElement sPe2 = (RealFieldElement)((RealFieldElement)sCurrent.add(yCurrent.atan2((Object)xCurrent))).multiply(0.5);
        RealFieldElement cos = (RealFieldElement)sPe2.cos();
        RealFieldElement sin = (RealFieldElement)sPe2.sin();
        RealFieldElement xPr = (RealFieldElement)xCurrent.add((Object)r);
        RealFieldElement xPrCos = (RealFieldElement)xPr.multiply((Object)cos);
        RealFieldElement xPrSin = (RealFieldElement)xPr.multiply((Object)sin);
        RealFieldElement yCos = (RealFieldElement)yCurrent.multiply((Object)cos);
        RealFieldElement ySin = (RealFieldElement)yCurrent.multiply((Object)sin);
        FieldRotation bpn = new FieldRotation((RealFieldElement)zP1.multiply(xPrCos.add((Object)ySin)), (RealFieldElement)((RealFieldElement)r.multiply(yCos.add((Object)xPrSin))).negate(), (RealFieldElement)r.multiply(xPrCos.subtract((Object)ySin)), (RealFieldElement)zP1.multiply(yCos.subtract((Object)xPrSin)), true);
        return new FieldTransform<T>(date, bpn, FieldVector3D.getZero(date.getField()));
    }

    private Object writeReplace() {
        return new DataTransferObject(this.eopHistory);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20131209L;
        private final EOPHistory eopHistory;

        DataTransferObject(EOPHistory eopHistory) {
            this.eopHistory = eopHistory;
        }

        private Object readResolve() {
            try {
                return new CIRFProvider(this.eopHistory);
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }
}

