/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.util.Date;
import java.util.TimeZone;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.FieldTimeStamped;
import org.orekit.time.Month;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;
import org.orekit.time.TimeShiftable;

public class FieldAbsoluteDate<T extends RealFieldElement<T>>
implements FieldTimeStamped<T>,
TimeShiftable<FieldAbsoluteDate<T>>,
Comparable<FieldAbsoluteDate<T>> {
    private final long epoch;
    private final T offset;
    private Field<T> field;

    public FieldAbsoluteDate(Field<T> field, AbsoluteDate date) {
        this.field = field;
        this.epoch = date.getEpoch();
        this.offset = (RealFieldElement)((RealFieldElement)field.getZero()).add(date.getOffset());
    }

    @DefaultDataContext
    public FieldAbsoluteDate(Field<T> field) {
        FieldAbsoluteDate<T> j2000 = FieldAbsoluteDate.getJ2000Epoch(field);
        this.field = j2000.field;
        this.epoch = j2000.epoch;
        this.offset = j2000.offset;
    }

    public FieldAbsoluteDate(FieldAbsoluteDate<T> since, T elapsedDuration) {
        this.field = since.field;
        RealFieldElement sum = (RealFieldElement)since.offset.add(elapsedDuration);
        if (Double.isInfinite(sum.getReal())) {
            this.offset = sum;
            this.epoch = sum.getReal() < 0.0 ? Long.MIN_VALUE : Long.MAX_VALUE;
        } else {
            double oPrime = sum.getReal() - elapsedDuration.getReal();
            double dPrime = sum.getReal() - oPrime;
            double deltaO = since.offset.getReal() - oPrime;
            double deltaD = elapsedDuration.getReal() - dPrime;
            double residual = deltaO + deltaD;
            long dl = (long)FastMath.floor((double)sum.getReal());
            this.offset = (RealFieldElement)((RealFieldElement)sum.subtract((double)dl)).add(residual);
            this.epoch = since.epoch + dl;
        }
    }

    public FieldAbsoluteDate(Field<T> field, String location, TimeScale timeScale) {
        this(field, DateTimeComponents.parseDateTime(location), timeScale);
    }

    public FieldAbsoluteDate(Field<T> field, DateTimeComponents location, TimeScale timeScale) {
        this(field, location.getDate(), location.getTime(), timeScale);
    }

    public FieldAbsoluteDate(Field<T> field, DateComponents date, TimeComponents time, TimeScale timeScale) {
        double seconds = time.getSecond();
        double tsOffset = timeScale.offsetToTAI(date, time);
        double sum = seconds + tsOffset;
        double sPrime = sum - tsOffset;
        double tPrime = sum - sPrime;
        double deltaS = seconds - sPrime;
        double deltaT = tsOffset - tPrime;
        double residual = deltaS + deltaT;
        long dl = (long)FastMath.floor((double)sum);
        this.offset = (RealFieldElement)((RealFieldElement)field.getZero()).add(sum - (double)dl + residual);
        this.epoch = 60L * (((long)date.getJ2000Day() * 24L + (long)time.getHour()) * 60L + (long)time.getMinute() - (long)time.getMinutesFromUTC() - 720L) + dl;
        this.field = field;
    }

    public FieldAbsoluteDate(Field<T> field, int year, int month, int day, int hour, int minute, double second, TimeScale timeScale) throws IllegalArgumentException {
        this(field, new DateComponents(year, month, day), new TimeComponents(hour, minute, second), timeScale);
    }

    public FieldAbsoluteDate(Field<T> field, int year, Month month, int day, int hour, int minute, double second, TimeScale timeScale) throws IllegalArgumentException {
        this(field, new DateComponents(year, month, day), new TimeComponents(hour, minute, second), timeScale);
    }

    public FieldAbsoluteDate(Field<T> field, DateComponents date, TimeScale timeScale) throws IllegalArgumentException {
        this(field, date, TimeComponents.H00, timeScale);
    }

    public FieldAbsoluteDate(Field<T> field, int year, int month, int day, TimeScale timeScale) throws IllegalArgumentException {
        this(field, new DateComponents(year, month, day), TimeComponents.H00, timeScale);
    }

    public FieldAbsoluteDate(Field<T> field, int year, Month month, int day, TimeScale timeScale) throws IllegalArgumentException {
        this(field, new DateComponents(year, month, day), TimeComponents.H00, timeScale);
    }

    public FieldAbsoluteDate(Field<T> field, Date location, TimeScale timeScale) {
        this(field, new DateComponents(DateComponents.JAVA_EPOCH, (int)(location.getTime() / 86400000L)), new TimeComponents(0.001 * (double)(location.getTime() % 86400000L)), timeScale);
    }

    public FieldAbsoluteDate(FieldAbsoluteDate<T> since, double elapsedDuration) {
        this(since.epoch, elapsedDuration, since.offset);
    }

    public FieldAbsoluteDate(AbsoluteDate since, T elapsedDuration) {
        this(since.getEpoch(), since.getOffset(), elapsedDuration);
    }

    public FieldAbsoluteDate(FieldAbsoluteDate<T> reference, double apparentOffset, TimeScale timeScale) {
        this(reference.field, new DateTimeComponents(reference.getComponents(timeScale), apparentOffset), timeScale);
    }

    private FieldAbsoluteDate(long epoch, double tA, T tB) {
        this.field = tB.getField();
        RealFieldElement sum = (RealFieldElement)tB.add(tA);
        if (Double.isInfinite(sum.getReal())) {
            this.offset = sum;
            this.epoch = sum.getReal() < 0.0 ? Long.MIN_VALUE : Long.MAX_VALUE;
        } else {
            double oPrime = sum.getReal() - tA;
            double dPrime = sum.getReal() - oPrime;
            double deltaO = tB.getReal() - oPrime;
            double deltaD = tA - dPrime;
            double residual = deltaO + deltaD;
            long dl = (long)FastMath.floor((double)sum.getReal());
            this.offset = (RealFieldElement)((RealFieldElement)sum.subtract((double)dl)).add(residual);
            this.epoch = epoch + dl;
        }
    }

    @DefaultDataContext
    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> parseCCSDSUnsegmentedTimeCode(Field<T> field, byte preambleField1, byte preambleField2, byte[] timeField, FieldAbsoluteDate<T> agencyDefinedEpoch) {
        return FieldAbsoluteDate.parseCCSDSUnsegmentedTimeCode(field, preambleField1, preambleField2, timeField, agencyDefinedEpoch, new FieldAbsoluteDate<T>(field, DataContext.getDefault().getTimeScales().getCcsdsEpoch()));
    }

    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> parseCCSDSUnsegmentedTimeCode(Field<T> field, byte preambleField1, byte preambleField2, byte[] timeField, FieldAbsoluteDate<T> agencyDefinedEpoch, FieldAbsoluteDate<T> ccsdsEpoch) {
        FieldAbsoluteDate<T> epochF;
        switch (preambleField1 & 0x70) {
            case 16: {
                epochF = ccsdsEpoch;
                break;
            }
            case 32: {
                if (agencyDefinedEpoch == null) {
                    throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_MISSING_AGENCY_EPOCH, new Object[0]);
                }
                epochF = agencyDefinedEpoch;
                break;
            }
            default: {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, FieldAbsoluteDate.formatByte(preambleField1));
            }
        }
        int coarseTimeLength = 1 + ((preambleField1 & 0xC) >>> 2);
        int fineTimeLength = preambleField1 & 3;
        if ((preambleField1 & 0x80) != 0) {
            coarseTimeLength += (preambleField2 & 0x60) >>> 5;
            fineTimeLength += (preambleField2 & 0x1C) >>> 2;
        }
        if (timeField.length != coarseTimeLength + fineTimeLength) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_LENGTH_TIME_FIELD, timeField.length, coarseTimeLength + fineTimeLength);
        }
        RealFieldElement seconds = (RealFieldElement)field.getZero();
        for (int i = 0; i < coarseTimeLength; ++i) {
            seconds = (RealFieldElement)((RealFieldElement)seconds.multiply(256)).add(((RealFieldElement)field.getZero()).add((double)FieldAbsoluteDate.toUnsigned(timeField[i])));
        }
        RealFieldElement subseconds = (RealFieldElement)field.getZero();
        for (int i = timeField.length - 1; i >= coarseTimeLength; --i) {
            subseconds = (RealFieldElement)((RealFieldElement)subseconds.add((double)FieldAbsoluteDate.toUnsigned(timeField[i]))).divide(256.0);
        }
        return new FieldAbsoluteDate<RealFieldElement>(epochF, seconds).shiftedBy(subseconds);
    }

    @DefaultDataContext
    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> parseCCSDSDaySegmentedTimeCode(Field<T> field, byte preambleField, byte[] timeField, DateComponents agencyDefinedEpoch) {
        return FieldAbsoluteDate.parseCCSDSDaySegmentedTimeCode(field, preambleField, timeField, agencyDefinedEpoch, DataContext.getDefault().getTimeScales().getUTC());
    }

    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> parseCCSDSDaySegmentedTimeCode(Field<T> field, byte preambleField, byte[] timeField, DateComponents agencyDefinedEpoch, TimeScale utc) {
        DateComponents epochDC;
        if ((preambleField & 0xF0) != 64) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, FieldAbsoluteDate.formatByte(preambleField));
        }
        if ((preambleField & 8) == 0) {
            epochDC = DateComponents.CCSDS_EPOCH;
        } else {
            if (agencyDefinedEpoch == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_MISSING_AGENCY_EPOCH, new Object[0]);
            }
            epochDC = agencyDefinedEpoch;
        }
        int daySegmentLength = (preambleField & 4) == 0 ? 2 : 3;
        int subMillisecondLength = (preambleField & 3) << 1;
        if (subMillisecondLength == 6) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, FieldAbsoluteDate.formatByte(preambleField));
        }
        if (timeField.length != daySegmentLength + 4 + subMillisecondLength) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_LENGTH_TIME_FIELD, timeField.length, daySegmentLength + 4 + subMillisecondLength);
        }
        int i = 0;
        int day = 0;
        while (i < daySegmentLength) {
            day = day * 256 + FieldAbsoluteDate.toUnsigned(timeField[i++]);
        }
        long milliInDay = 0L;
        while (i < daySegmentLength + 4) {
            milliInDay = milliInDay * 256L + (long)FieldAbsoluteDate.toUnsigned(timeField[i++]);
        }
        int milli = (int)(milliInDay % 1000L);
        int seconds = (int)((milliInDay - (long)milli) / 1000L);
        double subMilli = 0.0;
        double divisor = 1.0;
        while (i < timeField.length) {
            subMilli = subMilli * 256.0 + (double)FieldAbsoluteDate.toUnsigned(timeField[i++]);
            divisor *= 1000.0;
        }
        DateComponents date = new DateComponents(epochDC, day);
        TimeComponents time = new TimeComponents(seconds);
        return new FieldAbsoluteDate<T>(field, date, time, utc).shiftedBy((double)milli * 0.001 + subMilli / divisor);
    }

    @DefaultDataContext
    public FieldAbsoluteDate<T> parseCCSDSCalendarSegmentedTimeCode(byte preambleField, byte[] timeField) {
        return this.parseCCSDSCalendarSegmentedTimeCode(preambleField, timeField, DataContext.getDefault().getTimeScales().getUTC());
    }

    public FieldAbsoluteDate<T> parseCCSDSCalendarSegmentedTimeCode(byte preambleField, byte[] timeField, TimeScale utc) {
        if ((preambleField & 0xF0) != 80) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, FieldAbsoluteDate.formatByte(preambleField));
        }
        int length = 7 + (preambleField & 7);
        if (length == 14) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, FieldAbsoluteDate.formatByte(preambleField));
        }
        if (timeField.length != length) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_LENGTH_TIME_FIELD, timeField.length, length);
        }
        DateComponents date = (preambleField & 8) == 0 ? new DateComponents(FieldAbsoluteDate.toUnsigned(timeField[0]) * 256 + FieldAbsoluteDate.toUnsigned(timeField[1]), FieldAbsoluteDate.toUnsigned(timeField[2]), FieldAbsoluteDate.toUnsigned(timeField[3])) : new DateComponents(FieldAbsoluteDate.toUnsigned(timeField[0]) * 256 + FieldAbsoluteDate.toUnsigned(timeField[1]), FieldAbsoluteDate.toUnsigned(timeField[2]) * 256 + FieldAbsoluteDate.toUnsigned(timeField[3]));
        TimeComponents time = new TimeComponents(FieldAbsoluteDate.toUnsigned(timeField[4]), FieldAbsoluteDate.toUnsigned(timeField[5]), FieldAbsoluteDate.toUnsigned(timeField[6]));
        double subSecond = 0.0;
        double divisor = 1.0;
        for (int i = 7; i < length; ++i) {
            subSecond = subSecond * 100.0 + (double)FieldAbsoluteDate.toUnsigned(timeField[i]);
            divisor *= 100.0;
        }
        return new FieldAbsoluteDate<T>(this.field, date, time, utc).shiftedBy(subSecond / divisor);
    }

    private static int toUnsigned(byte b) {
        int i = b;
        return i < 0 ? 256 + i : i;
    }

    private static String formatByte(byte data) {
        return "0x" + Integer.toHexString(data).toUpperCase();
    }

    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> createJDDate(int jd, T secondsSinceNoon, TimeScale timeScale) {
        return new FieldAbsoluteDate<T>(secondsSinceNoon.getField(), new DateComponents(DateComponents.JULIAN_EPOCH, jd), TimeComponents.H12, timeScale).shiftedBy(secondsSinceNoon);
    }

    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> createMJDDate(int mjd, T secondsInDay, TimeScale timeScale) {
        return new FieldAbsoluteDate<T>(secondsInDay.getField(), new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, mjd), TimeComponents.H00, timeScale).shiftedBy(secondsInDay);
    }

    @DefaultDataContext
    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> createGPSDate(int weekNumber, T milliInWeek) {
        return FieldAbsoluteDate.createGPSDate(weekNumber, milliInWeek, DataContext.getDefault().getTimeScales().getGPS());
    }

    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> createGPSDate(int weekNumber, T milliInWeek, TimeScale gps) {
        int day = (int)FastMath.floor((double)(milliInWeek.getReal() / 8.64E7));
        RealFieldElement secondsInDay = (RealFieldElement)((RealFieldElement)milliInWeek.divide(1000.0)).subtract((double)day * 86400.0);
        return new FieldAbsoluteDate<RealFieldElement>(milliInWeek.getField(), new DateComponents(DateComponents.GPS_EPOCH, weekNumber * 7 + day), TimeComponents.H00, gps).shiftedBy(secondsInDay);
    }

    @DefaultDataContext
    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> createJulianEpoch(T julianEpoch) {
        return FieldAbsoluteDate.createJulianEpoch(julianEpoch, DataContext.getDefault().getTimeScales());
    }

    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> createJulianEpoch(T julianEpoch, TimeScales timeScales) {
        Field field = julianEpoch.getField();
        return new FieldAbsoluteDate<RealFieldElement>(new FieldAbsoluteDate<T>(field, timeScales.getJ2000Epoch()), (RealFieldElement)((RealFieldElement)julianEpoch.subtract(2000.0)).multiply(3.15576E7));
    }

    @DefaultDataContext
    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> createBesselianEpoch(T besselianEpoch) {
        return FieldAbsoluteDate.createBesselianEpoch(besselianEpoch, DataContext.getDefault().getTimeScales());
    }

    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> createBesselianEpoch(T besselianEpoch, TimeScales timeScales) {
        Field field = besselianEpoch.getField();
        return new FieldAbsoluteDate<RealFieldElement>(new FieldAbsoluteDate<T>(field, timeScales.getJ2000Epoch()), (RealFieldElement)((RealFieldElement)((RealFieldElement)besselianEpoch.subtract(1900.0)).multiply(3.15569259746784E7)).add(-3.155732911872E9));
    }

    @DefaultDataContext
    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> getJulianEpoch(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, DataContext.getDefault().getTimeScales().getJulianEpoch());
    }

    @DefaultDataContext
    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> getModifiedJulianEpoch(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, DataContext.getDefault().getTimeScales().getModifiedJulianEpoch());
    }

    @DefaultDataContext
    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> getFiftiesEpoch(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, DataContext.getDefault().getTimeScales().getFiftiesEpoch());
    }

    @DefaultDataContext
    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> getCCSDSEpoch(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, DataContext.getDefault().getTimeScales().getCcsdsEpoch());
    }

    @DefaultDataContext
    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> getGalileoEpoch(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, DataContext.getDefault().getTimeScales().getGalileoEpoch());
    }

    @DefaultDataContext
    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> getGPSEpoch(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, DataContext.getDefault().getTimeScales().getGpsEpoch());
    }

    @DefaultDataContext
    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> getJ2000Epoch(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, DataContext.getDefault().getTimeScales().getJ2000Epoch());
    }

    @DefaultDataContext
    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> getJavaEpoch(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, DataContext.getDefault().getTimeScales().getJavaEpoch());
    }

    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> getPastInfinity(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, AbsoluteDate.PAST_INFINITY);
    }

    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> getFutureInfinity(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, AbsoluteDate.FUTURE_INFINITY);
    }

    public static <T extends RealFieldElement<T>> FieldAbsoluteDate<T> getArbitraryEpoch(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, AbsoluteDate.ARBITRARY_EPOCH);
    }

    public FieldAbsoluteDate<T> shiftedBy(T dt) {
        return new FieldAbsoluteDate<T>(this, dt);
    }

    public T durationFrom(FieldAbsoluteDate<T> instant) {
        return (T)((RealFieldElement)((RealFieldElement)this.offset.subtract(instant.offset)).add((double)(this.epoch - instant.epoch)));
    }

    public T durationFrom(AbsoluteDate instant) {
        return (T)((RealFieldElement)((RealFieldElement)this.offset.subtract(instant.getOffset())).add((double)(this.epoch - instant.getEpoch())));
    }

    public T offsetFrom(FieldAbsoluteDate<T> instant, TimeScale timeScale) {
        long elapsedDurationA = this.epoch - instant.epoch;
        RealFieldElement elapsedDurationB = (RealFieldElement)((RealFieldElement)this.offset.add(timeScale.offsetFromTAI(this))).subtract(instant.offset.add(timeScale.offsetFromTAI(instant)));
        return (T)((RealFieldElement)elapsedDurationB.add((double)elapsedDurationA));
    }

    public T timeScalesOffset(TimeScale scale1, TimeScale scale2) {
        return (T)((RealFieldElement)scale1.offsetFromTAI(this).subtract(scale2.offsetFromTAI(this)));
    }

    public Date toDate(TimeScale timeScale) {
        double time = (double)this.epoch + (this.offset.getReal() + timeScale.offsetFromTAI(this).getReal());
        return new Date(FastMath.round((double)((time + 9.46728E8) * 1000.0)));
    }

    public DateTimeComponents getComponents(TimeScale timeScale) {
        long time;
        if (Double.isInfinite(this.offset.getReal())) {
            if (this.offset.getReal() < 0.0) {
                return new DateTimeComponents(DateComponents.MIN_EPOCH, TimeComponents.H00);
            }
            return new DateTimeComponents(DateComponents.MAX_EPOCH, new TimeComponents(23, 59, 59.999));
        }
        double taiOffset = timeScale.offsetFromTAI(this).getReal();
        double sum = this.offset.getReal() + taiOffset;
        double oPrime = sum - taiOffset;
        double dPrime = sum - oPrime;
        double deltaO = this.offset.getReal() - oPrime;
        double deltaD = taiOffset - dPrime;
        double residual = deltaO + deltaD;
        long carry = (long)FastMath.floor((double)sum);
        double offset2000B = sum - (double)carry + residual;
        long offset2000A = this.epoch + carry + 43200L;
        if (offset2000B < 0.0) {
            --offset2000A;
            offset2000B += 1.0;
        }
        if ((time = offset2000A % 86400L) < 0L) {
            time += 86400L;
        }
        int date = (int)((offset2000A - time) / 86400L);
        DateComponents dateComponents = new DateComponents(DateComponents.J2000_EPOCH, date);
        TimeComponents timeComponents = new TimeComponents((int)time, offset2000B);
        if (timeScale.insideLeap(this)) {
            timeComponents = new TimeComponents(timeComponents.getHour(), timeComponents.getMinute(), timeComponents.getSecond() + timeScale.getLeap(this).getReal());
        }
        return new DateTimeComponents(dateComponents, timeComponents);
    }

    @DefaultDataContext
    public DateTimeComponents getComponents(int minutesFromUTC) {
        return this.getComponents(minutesFromUTC, (TimeScale)DataContext.getDefault().getTimeScales().getUTC());
    }

    public DateTimeComponents getComponents(int minutesFromUTC, TimeScale utc) {
        DateTimeComponents utcComponents = this.getComponents(utc);
        double seconds = utcComponents.getTime().getSecond();
        int minute = utcComponents.getTime().getMinute() + minutesFromUTC;
        int hourShift = minute < 0 ? (minute - 59) / 60 : (minute > 59 ? minute / 60 : 0);
        int hour = utcComponents.getTime().getHour() + hourShift;
        int dayShift = hour < 0 ? (hour - 23) / 24 : (hour > 23 ? hour / 24 : 0);
        return new DateTimeComponents(new DateComponents(utcComponents.getDate(), dayShift), new TimeComponents(hour -= 24 * dayShift, minute -= 60 * hourShift, seconds, minutesFromUTC));
    }

    @Override
    public FieldAbsoluteDate<T> getDate() {
        return this;
    }

    public Field<T> getField() {
        return this.field;
    }

    @DefaultDataContext
    public DateTimeComponents getComponents(TimeZone timeZone) {
        return this.getComponents(timeZone, (TimeScale)DataContext.getDefault().getTimeScales().getUTC());
    }

    public DateTimeComponents getComponents(TimeZone timeZone, TimeScale utc) {
        FieldAbsoluteDate<T> javaEpoch = new FieldAbsoluteDate<T>(this.field, DateComponents.JAVA_EPOCH, utc);
        long milliseconds = FastMath.round((double)(this.offsetFrom(javaEpoch, utc).getReal() * 1000.0));
        return this.getComponents(timeZone.getOffset(milliseconds) / 60000, utc);
    }

    @Override
    public int compareTo(FieldAbsoluteDate<T> date) {
        return Double.compare(this.durationFrom(date).getReal(), 0.0);
    }

    public boolean equals(Object date) {
        if (date == this) {
            return true;
        }
        if (date != null && date instanceof FieldAbsoluteDate) {
            return this.durationFrom((FieldAbsoluteDate)date).getReal() == 0.0;
        }
        return false;
    }

    public boolean isEqualTo(FieldTimeStamped<T> other) {
        return this.equals(other.getDate());
    }

    public boolean isCloseTo(FieldTimeStamped<T> other, double tolerance) {
        return FastMath.abs((double)this.durationFrom(other.getDate()).getReal()) < tolerance;
    }

    public boolean isBefore(FieldTimeStamped<T> other) {
        return this.compareTo(other.getDate()) < 0;
    }

    public boolean isAfter(FieldTimeStamped<T> other) {
        return this.compareTo(other.getDate()) > 0;
    }

    public boolean isBeforeOrEqualTo(FieldTimeStamped<T> other) {
        return this.isEqualTo(other) || this.isBefore(other);
    }

    public boolean isAfterOrEqualTo(FieldTimeStamped<T> other) {
        return this.isEqualTo(other) || this.isAfter(other);
    }

    public boolean isBetween(FieldTimeStamped<T> boundary, FieldTimeStamped<T> otherBoundary) {
        FieldTimeStamped<T> end;
        FieldTimeStamped<T> beginning;
        if (boundary.getDate().isBefore(otherBoundary)) {
            beginning = boundary;
            end = otherBoundary;
        } else {
            beginning = otherBoundary;
            end = boundary;
        }
        return this.isAfter(beginning) && this.isBefore(end);
    }

    public boolean isBetweenOrEqualTo(FieldTimeStamped<T> boundary, FieldTimeStamped<T> otherBoundary) {
        return this.isEqualTo(boundary) || this.isEqualTo(otherBoundary) || this.isBetween(boundary, otherBoundary);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.durationFrom(AbsoluteDate.ARBITRARY_EPOCH).getReal());
        return (int)(l ^ l >>> 32);
    }

    @DefaultDataContext
    public String toString() {
        return this.toString(DataContext.getDefault().getTimeScales().getUTC());
    }

    public String toString(TimeScale timeScale) {
        return this.getComponents(timeScale).toString(timeScale.minuteDuration(this));
    }

    @DefaultDataContext
    public String toString(int minutesFromUTC) {
        return this.toString(minutesFromUTC, (TimeScale)DataContext.getDefault().getTimeScales().getUTC());
    }

    public String toString(int minutesFromUTC, TimeScale utc) {
        int minuteDuration = utc.minuteDuration(this);
        return this.getComponents(minutesFromUTC, utc).toString(minuteDuration);
    }

    @DefaultDataContext
    public String toString(TimeZone timeZone) {
        return this.toString(timeZone, (TimeScale)DataContext.getDefault().getTimeScales().getUTC());
    }

    public String toString(TimeZone timeZone, TimeScale utc) {
        int minuteDuration = utc.minuteDuration(this);
        return this.getComponents(timeZone, utc).toString(minuteDuration);
    }

    @Override
    public FieldAbsoluteDate<T> shiftedBy(double dt) {
        return new FieldAbsoluteDate<T>(this, dt);
    }

    public AbsoluteDate toAbsoluteDate() {
        return new AbsoluteDate(this.epoch, this.offset.getReal());
    }
}

