/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.propagation.analytical.gnss.GalileoOrbitalElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.GNSSDate;

public class GalileoAlmanac
implements GalileoOrbitalElements {
    private static final double I0 = FastMath.toRadians((double)56.0);
    private static final double A0 = 2.96E7;
    private final int prn;
    private final int healthE5a;
    private final int healthE5b;
    private final int healthE1;
    private final int week;
    private final double toa;
    private final double sma;
    private final double ecc;
    private final double inc;
    private final double om0;
    private final double dom;
    private final double aop;
    private final double anom;
    private final double af0;
    private final double af1;
    private final int iod;
    private final AbsoluteDate date;

    @DefaultDataContext
    public GalileoAlmanac(int prn, int week, double toa, double dsqa, double ecc, double dinc, int iod, double om0, double dom, double aop, double anom, double af0, double af1, int healthE5a, int healthE5b, int healthE1) {
        this(prn, week, toa, dsqa, ecc, dinc, iod, om0, dom, aop, anom, af0, af1, healthE5a, healthE5b, healthE1, new GNSSDate(week, toa * 1000.0, SatelliteSystem.GALILEO, DataContext.getDefault().getTimeScales()).getDate());
    }

    public GalileoAlmanac(int prn, int week, double toa, double dsqa, double ecc, double dinc, int iod, double om0, double dom, double aop, double anom, double af0, double af1, int healthE5a, int healthE5b, int healthE1, AbsoluteDate date) {
        this.prn = prn;
        this.week = week;
        this.toa = toa;
        this.ecc = ecc;
        this.inc = I0 + dinc;
        this.iod = iod;
        this.om0 = om0;
        this.dom = dom;
        this.aop = aop;
        this.anom = anom;
        this.af0 = af0;
        this.af1 = af1;
        this.healthE1 = healthE1;
        this.healthE5a = healthE5a;
        this.healthE5b = healthE5b;
        this.date = date;
        double sqa = dsqa + FastMath.sqrt((double)2.96E7);
        this.sma = sqa * sqa;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    @Override
    public int getPRN() {
        return this.prn;
    }

    @Override
    public int getWeek() {
        return this.week;
    }

    @Override
    public double getTime() {
        return this.toa;
    }

    @Override
    public double getSma() {
        return this.sma;
    }

    @Override
    public double getMeanMotion() {
        double absA = FastMath.abs((double)this.sma);
        return FastMath.sqrt((double)(3.986004418E14 / absA)) / absA;
    }

    @Override
    public double getE() {
        return this.ecc;
    }

    @Override
    public double getI0() {
        return this.inc;
    }

    @Override
    public double getIDot() {
        return 0.0;
    }

    @Override
    public double getOmega0() {
        return this.om0;
    }

    @Override
    public double getOmegaDot() {
        return this.dom;
    }

    @Override
    public double getPa() {
        return this.aop;
    }

    @Override
    public double getM0() {
        return this.anom;
    }

    @Override
    public double getCuc() {
        return 0.0;
    }

    @Override
    public double getCus() {
        return 0.0;
    }

    @Override
    public double getCrc() {
        return 0.0;
    }

    @Override
    public double getCrs() {
        return 0.0;
    }

    @Override
    public double getCic() {
        return 0.0;
    }

    @Override
    public double getCis() {
        return 0.0;
    }

    @Override
    public double getAf0() {
        return this.af0;
    }

    @Override
    public double getAf1() {
        return this.af1;
    }

    public int getIOD() {
        return this.iod;
    }

    public int getHealthE1() {
        return this.healthE1;
    }

    public int getHealthE5a() {
        return this.healthE5a;
    }

    public int getHealthE5b() {
        return this.healthE5b;
    }
}

