/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.drag;

import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.forces.AbstractForceModel;
import org.orekit.forces.drag.DragSensitive;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.models.earth.atmosphere.Atmosphere;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class DragForce
extends AbstractForceModel {
    private final Atmosphere atmosphere;
    private final DragSensitive spacecraft;

    public DragForce(Atmosphere atmosphere, DragSensitive spacecraft) {
        this.atmosphere = atmosphere;
        this.spacecraft = spacecraft;
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return false;
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        AbsoluteDate date = s.getDate();
        Frame frame = s.getFrame();
        Vector3D position = s.getPVCoordinates().getPosition();
        double rho = this.atmosphere.getDensity(date, position, frame);
        Vector3D vAtm = this.atmosphere.getVelocity(date, position, frame);
        Vector3D relativeVelocity = vAtm.subtract((Vector)s.getPVCoordinates().getVelocity());
        return this.spacecraft.dragAcceleration(date, frame, position, s.getAttitude().getRotation(), s.getMass(), rho, relativeVelocity, parameters);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        FieldAbsoluteDate<T> date = s.getDate();
        Frame frame = s.getFrame();
        FieldVector3D position = s.getPVCoordinates().getPosition();
        Object rho = this.isStateDerivative(s) ? this.getDensityWrtStateUsingFiniteDifferences(date.toAbsoluteDate(), frame, position) : this.atmosphere.getDensity(date, position, frame);
        FieldVector3D<T> vAtm = this.atmosphere.getVelocity(date, position, frame);
        FieldVector3D relativeVelocity = vAtm.subtract(s.getPVCoordinates().getVelocity());
        return this.spacecraft.dragAcceleration(date, frame, position, (FieldRotation)s.getAttitude().getRotation(), (RealFieldElement)s.getMass(), (RealFieldElement)rho, relativeVelocity, (RealFieldElement[])parameters);
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.empty();
    }

    @Override
    public <T extends RealFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return Stream.empty();
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return this.spacecraft.getDragParametersDrivers();
    }

    private <T extends RealFieldElement<T>> boolean isStateDerivative(FieldSpacecraftState<T> state) {
        try {
            DerivativeStructure dsMass = (DerivativeStructure)state.getMass();
            int o = dsMass.getOrder();
            int p = dsMass.getFreeParameters();
            if (o != 1 || p != 6 && p != 7 && p != 8) {
                return false;
            }
            TimeStampedFieldPVCoordinates<T> pv = state.getPVCoordinates();
            return this.isVariable((DerivativeStructure)pv.getPosition().getX(), 0) && this.isVariable((DerivativeStructure)pv.getPosition().getY(), 1) && this.isVariable((DerivativeStructure)pv.getPosition().getZ(), 2) && this.isVariable((DerivativeStructure)pv.getVelocity().getX(), 3) && this.isVariable((DerivativeStructure)pv.getVelocity().getY(), 4) && this.isVariable((DerivativeStructure)pv.getVelocity().getZ(), 5);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    private boolean isVariable(DerivativeStructure ds, int index) {
        double[] derivatives = ds.getAllDerivatives();
        boolean check = true;
        for (int i = 1; i < derivatives.length; ++i) {
            check &= derivatives[i] == (index + 1 == i ? 1.0 : 0.0);
        }
        return check;
    }

    private <T extends RealFieldElement<T>> T getDensityWrtStateUsingFiniteDifferences(AbsoluteDate date, Frame frame, FieldVector3D<T> position) {
        DSFactory factory = ((DerivativeStructure)position.getX()).getFactory();
        DSFactory factory3 = new DSFactory(3, 1);
        FieldVector3D position3 = new FieldVector3D((RealFieldElement)factory3.variable(0, position.getX().getReal()), (RealFieldElement)factory3.variable(1, position.getY().getReal()), (RealFieldElement)factory3.variable(2, position.getZ().getReal()));
        Frame atmFrame = this.atmosphere.getFrame();
        Transform toBody = frame.getTransformTo(atmFrame, date);
        FieldVector3D posBodyDS = toBody.transformPosition(position3);
        Vector3D posBody = posBodyDS.toVector3D();
        double delta = 1.0;
        double x = posBody.getX();
        double y = posBody.getY();
        double z = posBody.getZ();
        double rho0 = this.atmosphere.getDensity(date, posBody, atmFrame);
        double dRhodX = (this.atmosphere.getDensity(date, new Vector3D(x + 1.0, y, z), atmFrame) - rho0) / 1.0;
        double dRhodY = (this.atmosphere.getDensity(date, new Vector3D(x, y + 1.0, z), atmFrame) - rho0) / 1.0;
        double dRhodZ = (this.atmosphere.getDensity(date, new Vector3D(x, y, z + 1.0), atmFrame) - rho0) / 1.0;
        double[] dXdQ = ((DerivativeStructure)posBodyDS.getX()).getAllDerivatives();
        double[] dYdQ = ((DerivativeStructure)posBodyDS.getY()).getAllDerivatives();
        double[] dZdQ = ((DerivativeStructure)posBodyDS.getZ()).getAllDerivatives();
        int p = factory.getCompiler().getFreeParameters();
        double[] rhoAll = new double[p + 1];
        rhoAll[0] = rho0;
        for (int i = 1; i < 4; ++i) {
            rhoAll[i] = dRhodX * dXdQ[i] + dRhodY * dYdQ[i] + dRhodZ * dZdQ[i];
        }
        DerivativeStructure rho = factory.build(rhoAll);
        return (T)rho;
    }

    public Atmosphere getAtmosphere() {
        return this.atmosphere;
    }

    public DragSensitive getSpacecraft() {
        return this.spacecraft;
    }
}

