/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.AbstractSelfFeedingLoader;
import org.orekit.data.DataContext;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.DateComponents;
import org.orekit.time.Month;
import org.orekit.time.OffsetModel;
import org.orekit.time.UTCTAIOffsetsLoader;
import org.orekit.time.UtcTaiOffsetLoader;

public class UTCTAIHistoryFilesLoader
extends AbstractSelfFeedingLoader
implements UTCTAIOffsetsLoader {
    private static final String SUPPORTED_NAMES = "^UTC-TAI\\.history$";

    @DefaultDataContext
    public UTCTAIHistoryFilesLoader() {
        this(DataContext.getDefault().getDataProvidersManager());
    }

    public UTCTAIHistoryFilesLoader(DataProvidersManager manager) {
        super(SUPPORTED_NAMES, manager);
    }

    @Override
    public List<OffsetModel> loadOffsets() {
        UtcTaiOffsetLoader parser = new UtcTaiOffsetLoader(new Parser());
        this.feed(parser);
        return parser.getOffsets();
    }

    public static class Parser
    implements UTCTAIOffsetsLoader.Parser {
        private Pattern regularPattern;
        private Pattern lastPattern;

        public Parser() {
            String start = "^";
            String yearField = "\\p{Blank}*((?:\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})|(?:    ))";
            StringBuilder builder = new StringBuilder("\\p{Blank}+(");
            for (Month month : Month.values()) {
                builder.append(month.getCapitalizedAbbreviation());
                builder.append('|');
            }
            builder.delete(builder.length() - 1, builder.length());
            builder.append(")\\.?");
            String monthField = builder.toString();
            String dayField = "\\p{Blank}+([ 0-9]+)\\.?";
            String offsetField = "\\p{Blank}+(\\p{Digit}+)s";
            String separator = "\\p{Blank}*-\\p{Blank}+";
            String finalBlanks = "\\p{Blank}*$";
            this.regularPattern = Pattern.compile("^\\p{Blank}*((?:\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})|(?:    ))" + monthField + "\\p{Blank}+([ 0-9]+)\\.?" + "\\p{Blank}*-\\p{Blank}+" + "\\p{Blank}*((?:\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})|(?:    ))" + monthField + "\\p{Blank}+([ 0-9]+)\\.?" + "\\p{Blank}+(\\p{Digit}+)s" + "\\p{Blank}*$");
            this.lastPattern = Pattern.compile("^\\p{Blank}*((?:\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})|(?:    ))" + monthField + "\\p{Blank}+([ 0-9]+)\\.?" + "\\p{Blank}*-\\p{Blank}+" + "\\p{Blank}+(\\p{Digit}+)s" + "\\p{Blank}*$");
        }

        @Override
        public List<OffsetModel> parse(InputStream input, String name) throws IOException {
            ArrayList<OffsetModel> offsets = new ArrayList<OffsetModel>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            String emptyYear = "    ";
            int lineNumber = 0;
            DateComponents lastDate = null;
            int lastLine = 0;
            String previousYear = "    ";
            String line = reader.readLine();
            while (line != null) {
                ++lineNumber;
                Matcher matcher = this.regularPattern.matcher(line);
                if (matcher.matches()) {
                    if (lastLine > 0) {
                        throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_DATA_AFTER_LINE_IN_FILE, lastLine, name, line);
                    }
                } else {
                    matcher = this.lastPattern.matcher(line);
                    if (matcher.matches()) {
                        lastLine = lineNumber;
                    }
                }
                if (matcher.matches()) {
                    try {
                        String year = matcher.group(1);
                        if ("    ".equals(year)) {
                            year = previousYear;
                        }
                        if (lineNumber != lastLine) {
                            previousYear = "    ".equals(matcher.group(4)) ? year : matcher.group(4);
                        }
                        DateComponents leapDay = new DateComponents(Integer.parseInt(year.trim()), Month.parseMonth(matcher.group(2)), Integer.parseInt(matcher.group(3).trim()));
                        int offset = Integer.parseInt(matcher.group(matcher.groupCount()));
                        if (lastDate != null && leapDay.compareTo(lastDate) <= 0) {
                            throw new OrekitException((Localizable)OrekitMessages.NON_CHRONOLOGICAL_DATES_IN_FILE, name, lineNumber);
                        }
                        lastDate = leapDay;
                        offsets.add(new OffsetModel(leapDay, offset));
                    }
                    catch (NumberFormatException nfe) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                    }
                }
                line = reader.readLine();
            }
            if (offsets.isEmpty()) {
                throw new OrekitException((Localizable)OrekitMessages.NO_ENTRIES_IN_IERS_UTC_TAI_HISTORY_FILE, name);
            }
            return offsets;
        }
    }
}

