/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.data.DataContext;
import org.orekit.frames.Frame;
import org.orekit.frames.Frames;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.analytical.gnss.AbstractGNSSPropagator;
import org.orekit.propagation.analytical.gnss.QZSSOrbitalElements;
import org.orekit.utils.IERSConventions;

public class QZSSPropagator
extends AbstractGNSSPropagator {
    private static final double QZSS_AV = 7.2921151467E-5;
    private static final double QZSS_CYCLE_DURATION = 6.193152E8;
    private final QZSSOrbitalElements qzssOrbit;

    private QZSSPropagator(Builder builder) {
        super(builder.orbit, builder.attitudeProvider, builder.eci, builder.ecef, builder.mass, 7.2921151467E-5, 6.193152E8, 3.986005E14);
        this.qzssOrbit = builder.orbit;
    }

    public QZSSOrbitalElements getQZSSOrbitalElements() {
        return this.qzssOrbit;
    }

    public static class Builder {
        private final QZSSOrbitalElements orbit;
        private AttitudeProvider attitudeProvider;
        private double mass = 1000.0;
        private Frame eci = null;
        private Frame ecef = null;

        @DefaultDataContext
        public Builder(QZSSOrbitalElements qzssOrbElt) {
            this(qzssOrbElt, DataContext.getDefault().getFrames());
        }

        public Builder(QZSSOrbitalElements qzssOrbElt, Frames frames) {
            this.orbit = qzssOrbElt;
            this.eci = frames.getEME2000();
            this.ecef = frames.getITRF(IERSConventions.IERS_2010, true);
            this.attitudeProvider = Propagator.getDefaultLaw(frames);
        }

        public Builder attitudeProvider(AttitudeProvider userProvider) {
            this.attitudeProvider = userProvider;
            return this;
        }

        public Builder mass(double userMass) {
            this.mass = userMass;
            return this;
        }

        public Builder eci(Frame inertial) {
            this.eci = inertial;
            return this;
        }

        public Builder ecef(Frame bodyFixed) {
            this.ecef = bodyFixed;
            return this;
        }

        public QZSSPropagator build() {
            return new QZSSPropagator(this);
        }
    }
}

