/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.AbstractSelfFeedingLoader;
import org.orekit.data.DataContext;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.gnss.GPSAlmanac;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.GNSSDate;
import org.orekit.time.TimeScales;

public class SEMParser
extends AbstractSelfFeedingLoader
implements DataLoader {
    private static final String SOURCE = "SEM";
    private static final double INC_REF = 0.3;
    private static final String DEFAULT_SUPPORTED_NAMES = ".*\\.al3$";
    private static final String SEPARATOR = "\\s+";
    private final List<GPSAlmanac> almanacs = new ArrayList<GPSAlmanac>();
    private final List<Integer> prnList = new ArrayList<Integer>();
    private final TimeScales timeScales;

    @DefaultDataContext
    public SEMParser(String supportedNames) {
        this(supportedNames, DataContext.getDefault().getDataProvidersManager(), DataContext.getDefault().getTimeScales());
    }

    public SEMParser(String supportedNames, DataProvidersManager dataProvidersManager, TimeScales timeScales) {
        super(supportedNames == null ? DEFAULT_SUPPORTED_NAMES : supportedNames, dataProvidersManager);
        this.timeScales = timeScales;
    }

    public void loadData() {
        this.feed(this);
        if (this.almanacs.isEmpty()) {
            throw new OrekitException((Localizable)OrekitMessages.NO_SEM_ALMANAC_AVAILABLE, new Object[0]);
        }
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        this.almanacs.clear();
        this.prnList.clear();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        try {
            String[] token = this.getTokens(reader);
            int almanacNb = Integer.parseInt(token[0].trim());
            token = this.getTokens(reader);
            int week = Integer.parseInt(token[0].trim());
            double toa = Double.parseDouble(token[1].trim());
            for (int i = 0; i < almanacNb; ++i) {
                this.readAlmanac(reader, week, toa);
            }
        }
        catch (IOException | IndexOutOfBoundsException e) {
            throw new OrekitException(e, OrekitMessages.NOT_A_SUPPORTED_SEM_ALMANAC_FILE, name);
        }
    }

    @Override
    public boolean stillAcceptsData() {
        return this.almanacs.isEmpty();
    }

    public List<GPSAlmanac> getAlmanacs() {
        return this.almanacs;
    }

    public List<Integer> getPRNNumbers() {
        return this.prnList;
    }

    @Override
    public String getSupportedNames() {
        return super.getSupportedNames();
    }

    private void readAlmanac(BufferedReader reader, int week, double toa) throws IOException {
        reader.readLine();
        try {
            String[] token = this.getTokens(reader);
            int prn = Integer.parseInt(token[0].trim());
            token = this.getTokens(reader);
            int svn = Integer.parseInt(token[0].trim());
            token = this.getTokens(reader);
            int ura = Integer.parseInt(token[0].trim());
            token = this.getTokens(reader);
            double ecc = Double.parseDouble(token[0].trim());
            double inc = this.getInclination(Double.parseDouble(token[1].trim()));
            double dom = this.toRadians(Double.parseDouble(token[2].trim()));
            token = this.getTokens(reader);
            double sqa = Double.parseDouble(token[0].trim());
            double om0 = this.toRadians(Double.parseDouble(token[1].trim()));
            double aop = this.toRadians(Double.parseDouble(token[2].trim()));
            token = this.getTokens(reader);
            double anom = this.toRadians(Double.parseDouble(token[0].trim()));
            double af0 = Double.parseDouble(token[1].trim());
            double af1 = Double.parseDouble(token[2].trim());
            token = this.getTokens(reader);
            int health = Integer.parseInt(token[0].trim());
            token = this.getTokens(reader);
            int conf = Integer.parseInt(token[0].trim());
            AbsoluteDate date = new GNSSDate(week, toa * 1000.0, SatelliteSystem.GPS, this.timeScales).getDate();
            this.almanacs.add(new GPSAlmanac(SOURCE, prn, svn, week, toa, sqa, ecc, inc, om0, dom, aop, anom, af0, af1, health, ura, conf, date));
            this.prnList.add(prn);
        }
        catch (IndexOutOfBoundsException aioobe) {
            throw new IOException(aioobe);
        }
    }

    private String[] getTokens(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            return line.trim().split(SEPARATOR);
        }
        throw new IOException();
    }

    private double getInclination(double incOffset) {
        return this.toRadians(0.3 + incOffset);
    }

    private double toRadians(double semicircles) {
        return 3.1415926535898 * semicircles;
    }
}

