/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.util.FastMath;
import org.orekit.files.ccsds.ODMMetaData;
import org.orekit.files.ccsds.OGMFile;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.tle.TLE;

public class OMMFile
extends OGMFile {
    private final OMMMetaData metaData = new OMMMetaData(this);
    private double meanMotion;
    private int ephemerisType;
    private char classificationType;
    private Integer noradID;
    private String elementSetNo;
    private int revAtEpoch;
    private Double bStar;
    private Double meanMotionDot;
    private Double meanMotionDotDot;
    private List<String> dataTleRelatedParametersComment;

    OMMFile() {
    }

    @Override
    public OMMMetaData getMetaData() {
        return this.metaData;
    }

    public double getMeanMotion() {
        return this.meanMotion;
    }

    void setMeanMotion(double motion) {
        this.meanMotion = motion;
    }

    public int getEphemerisType() {
        return this.ephemerisType;
    }

    void setEphemerisType(int ephemerisType) {
        this.ephemerisType = ephemerisType;
    }

    public char getClassificationType() {
        return this.classificationType;
    }

    void setClassificationType(char classificationType) {
        this.classificationType = classificationType;
    }

    public Integer getNoradID() {
        return this.noradID;
    }

    void setNoradID(Integer noradID) {
        this.noradID = noradID;
    }

    public String getElementSetNumber() {
        return this.elementSetNo;
    }

    void setElementSetNo(String elementSetNo) {
        this.elementSetNo = elementSetNo;
    }

    public int getRevAtEpoch() {
        return this.revAtEpoch;
    }

    void setRevAtEpoch(int revAtEpoch) {
        this.revAtEpoch = revAtEpoch;
    }

    public double getBStar() {
        return this.bStar;
    }

    void setbStar(double bStar) {
        this.bStar = bStar;
    }

    public double getMeanMotionDot() {
        return this.meanMotionDot;
    }

    void setMeanMotionDot(double meanMotionDot) {
        this.meanMotionDot = meanMotionDot;
    }

    public double getMeanMotionDotDot() {
        return this.meanMotionDotDot;
    }

    void setMeanMotionDotDot(double meanMotionDotDot) {
        this.meanMotionDotDot = meanMotionDotDot;
    }

    public List<String> getTLERelatedParametersComment() {
        return Collections.unmodifiableList(this.dataTleRelatedParametersComment);
    }

    void setTLERelatedParametersComment(List<String> comment) {
        this.dataTleRelatedParametersComment = new ArrayList<String>(comment);
    }

    public KeplerianOrbit generateKeplerianOrbit() {
        this.setMuUsed();
        double a = Double.isNaN(this.getA()) ? FastMath.cbrt((double)(this.getMuUsed() / (this.meanMotion * this.meanMotion))) : this.getA();
        return new KeplerianOrbit(a, this.getE(), this.getI(), this.getPa(), this.getRaan(), this.getAnomaly(), PositionAngle.MEAN, this.metaData.getFrame(), this.getEpoch(), this.getMuUsed());
    }

    public CartesianOrbit generateCartesianOrbit() {
        return new CartesianOrbit(this.generateKeplerianOrbit());
    }

    public SpacecraftState generateSpacecraftState() {
        return new SpacecraftState((Orbit)this.generateKeplerianOrbit(), this.getMass());
    }

    public TLE generateTLE() {
        return new TLE(this.noradID, this.classificationType, this.metaData.getLaunchYear(), this.metaData.getLaunchNumber(), this.metaData.getLaunchPiece(), this.ephemerisType, Integer.parseInt(this.elementSetNo), this.getEpoch(), this.meanMotion, this.meanMotionDot, this.meanMotionDotDot, this.getE(), this.getI(), this.getPa(), this.getRaan(), this.getAnomaly(), this.revAtEpoch, this.bStar);
    }

    public static class OMMMetaData
    extends ODMMetaData {
        private String meanElementTheory;

        OMMMetaData(OMMFile ommFile) {
            super(ommFile);
        }

        public String getMeanElementTheory() {
            return this.meanElementTheory;
        }

        void setMeanElementTheory(String meanElementTheory) {
            this.meanElementTheory = meanElementTheory;
        }
    }
}

