/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.RungeKuttaStateInterpolator;

class DormandPrince54StateInterpolator
extends RungeKuttaStateInterpolator {
    private static final double A70 = 0.09114583333333333;
    private static final double A72 = 0.44923629829290207;
    private static final double A73 = 0.6510416666666666;
    private static final double A74 = -0.322376179245283;
    private static final double A75 = 0.13095238095238096;
    private static final double D0 = -1.1270175653862835;
    private static final double D2 = 2.675424484351598;
    private static final double D3 = -5.685526961588504;
    private static final double D4 = 3.5219323679207912;
    private static final double D5 = -1.7672812570757455;
    private static final double D6 = 2.382468931778144;
    private static final long serialVersionUID = 20160328L;

    DormandPrince54StateInterpolator(boolean forward, double[][] yDotK, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, ODEStateAndDerivative softPreviousState, ODEStateAndDerivative softCurrentState, EquationsMapper mapper) {
        super(forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected DormandPrince54StateInterpolator create(boolean newForward, double[][] newYDotK, ODEStateAndDerivative newGlobalPreviousState, ODEStateAndDerivative newGlobalCurrentState, ODEStateAndDerivative newSoftPreviousState, ODEStateAndDerivative newSoftCurrentState, EquationsMapper newMapper) {
        return new DormandPrince54StateInterpolator(newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected ODEStateAndDerivative computeInterpolatedStateAndDerivatives(EquationsMapper mapper, double time, double theta, double thetaH, double oneMinusThetaH) {
        double[] interpolatedDerivatives;
        double[] interpolatedState;
        double eta = 1.0 - theta;
        double twoTheta = 2.0 * theta;
        double dot2 = 1.0 - twoTheta;
        double dot3 = theta * (2.0 - 3.0 * theta);
        double dot4 = twoTheta * (1.0 + theta * (twoTheta - 3.0));
        if (this.getGlobalPreviousState() != null && theta <= 0.5) {
            double f1 = thetaH;
            double f2 = f1 * eta;
            double f3 = f2 * theta;
            double f4 = f3 * eta;
            double coeff0 = f1 * 0.09114583333333333 - f2 * -0.9088541666666666 + f3 * -0.8177083333333334 + f4 * -1.1270175653862835;
            double coeff1 = 0.0;
            double coeff2 = f1 * 0.44923629829290207 - f2 * 0.44923629829290207 + f3 * 0.8984725965858041 + f4 * 2.675424484351598;
            double coeff3 = f1 * 0.6510416666666666 - f2 * 0.6510416666666666 + f3 * 1.3020833333333333 + f4 * -5.685526961588504;
            double coeff4 = f1 * -0.322376179245283 - f2 * -0.322376179245283 + f3 * -0.644752358490566 + f4 * 3.5219323679207912;
            double coeff5 = f1 * 0.13095238095238096 - f2 * 0.13095238095238096 + f3 * 0.2619047619047619 + f4 * -1.7672812570757455;
            double coeff6 = f4 * 2.382468931778144 - f3;
            double coeffDot0 = 0.09114583333333333 - dot2 * -0.9088541666666666 + dot3 * -0.8177083333333334 + dot4 * -1.1270175653862835;
            double coeffDot1 = 0.0;
            double coeffDot2 = 0.44923629829290207 - dot2 * 0.44923629829290207 + dot3 * 0.8984725965858041 + dot4 * 2.675424484351598;
            double coeffDot3 = 0.6510416666666666 - dot2 * 0.6510416666666666 + dot3 * 1.3020833333333333 + dot4 * -5.685526961588504;
            double coeffDot4 = -0.322376179245283 - dot2 * -0.322376179245283 + dot3 * -0.644752358490566 + dot4 * 3.5219323679207912;
            double coeffDot5 = 0.13095238095238096 - dot2 * 0.13095238095238096 + dot3 * 0.2619047619047619 + dot4 * -1.7672812570757455;
            double coeffDot6 = dot4 * 2.382468931778144 - dot3;
            interpolatedState = this.previousStateLinearCombination(coeff0, 0.0, coeff2, coeff3, coeff4, coeff5, coeff6);
            interpolatedDerivatives = this.derivativeLinearCombination(coeffDot0, 0.0, coeffDot2, coeffDot3, coeffDot4, coeffDot5, coeffDot6);
        } else {
            double f1 = -oneMinusThetaH;
            double f2 = oneMinusThetaH * theta;
            double f3 = f2 * theta;
            double f4 = f3 * eta;
            double coeff0 = f1 * 0.09114583333333333 - f2 * -0.9088541666666666 + f3 * -0.8177083333333334 + f4 * -1.1270175653862835;
            double coeff1 = 0.0;
            double coeff2 = f1 * 0.44923629829290207 - f2 * 0.44923629829290207 + f3 * 0.8984725965858041 + f4 * 2.675424484351598;
            double coeff3 = f1 * 0.6510416666666666 - f2 * 0.6510416666666666 + f3 * 1.3020833333333333 + f4 * -5.685526961588504;
            double coeff4 = f1 * -0.322376179245283 - f2 * -0.322376179245283 + f3 * -0.644752358490566 + f4 * 3.5219323679207912;
            double coeff5 = f1 * 0.13095238095238096 - f2 * 0.13095238095238096 + f3 * 0.2619047619047619 + f4 * -1.7672812570757455;
            double coeff6 = f4 * 2.382468931778144 - f3;
            double coeffDot0 = 0.09114583333333333 - dot2 * -0.9088541666666666 + dot3 * -0.8177083333333334 + dot4 * -1.1270175653862835;
            double coeffDot1 = 0.0;
            double coeffDot2 = 0.44923629829290207 - dot2 * 0.44923629829290207 + dot3 * 0.8984725965858041 + dot4 * 2.675424484351598;
            double coeffDot3 = 0.6510416666666666 - dot2 * 0.6510416666666666 + dot3 * 1.3020833333333333 + dot4 * -5.685526961588504;
            double coeffDot4 = -0.322376179245283 - dot2 * -0.322376179245283 + dot3 * -0.644752358490566 + dot4 * 3.5219323679207912;
            double coeffDot5 = 0.13095238095238096 - dot2 * 0.13095238095238096 + dot3 * 0.2619047619047619 + dot4 * -1.7672812570757455;
            double coeffDot6 = dot4 * 2.382468931778144 - dot3;
            interpolatedState = this.currentStateLinearCombination(coeff0, 0.0, coeff2, coeff3, coeff4, coeff5, coeff6);
            interpolatedDerivatives = this.derivativeLinearCombination(coeffDot0, 0.0, coeffDot2, coeffDot3, coeffDot4, coeffDot5, coeffDot6);
        }
        return mapper.mapStateAndDerivative(time, interpolatedState, interpolatedDerivatives);
    }
}

