/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.discrete;

import java.io.Serializable;
import org.hipparchus.distribution.IntegerDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public abstract class AbstractIntegerDistribution
implements IntegerDistribution,
Serializable {
    private static final long serialVersionUID = 20160320L;

    @Override
    public double probability(int x0, int x1) throws MathIllegalArgumentException {
        if (x1 < x0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, x0, x1, true);
        }
        return this.cumulativeProbability(x1) - this.cumulativeProbability(x0);
    }

    @Override
    public int inverseCumulativeProbability(double p) throws MathIllegalArgumentException {
        boolean chebyshevApplies;
        MathUtils.checkRangeInclusive(p, 0.0, 1.0);
        int lower = this.getSupportLowerBound();
        if (p == 0.0) {
            return lower;
        }
        if (lower == Integer.MIN_VALUE) {
            if (this.checkedCumulativeProbability(lower) >= p) {
                return lower;
            }
        } else {
            --lower;
        }
        int upper = this.getSupportUpperBound();
        if (p == 1.0) {
            return upper;
        }
        double mu = this.getNumericalMean();
        double sigma = FastMath.sqrt(this.getNumericalVariance());
        boolean bl = chebyshevApplies = !Double.isInfinite(mu) && !Double.isNaN(mu) && !Double.isInfinite(sigma) && !Double.isNaN(sigma) && sigma != 0.0;
        if (chebyshevApplies) {
            double k = FastMath.sqrt((1.0 - p) / p);
            double tmp = mu - k * sigma;
            if (tmp > (double)lower) {
                lower = (int)FastMath.ceil(tmp) - 1;
            }
            if ((tmp = mu + (k = 1.0 / k) * sigma) < (double)upper) {
                upper = (int)FastMath.ceil(tmp) - 1;
            }
        }
        return this.solveInverseCumulativeProbability(p, lower, upper);
    }

    protected int solveInverseCumulativeProbability(double p, int lower, int upper) {
        while (lower + 1 < upper) {
            double pm;
            int xm = (lower + upper) / 2;
            if (xm < lower || xm > upper) {
                xm = lower + (upper - lower) / 2;
            }
            if ((pm = this.checkedCumulativeProbability(xm)) >= p) {
                upper = xm;
                continue;
            }
            lower = xm;
        }
        return upper;
    }

    private double checkedCumulativeProbability(int argument) throws MathRuntimeException {
        double result = this.cumulativeProbability(argument);
        if (Double.isNaN(result)) {
            throw new MathRuntimeException(LocalizedCoreFormats.DISCRETE_CUMULATIVE_PROBABILITY_RETURNED_NAN, argument);
        }
        return result;
    }

    @Override
    public double logProbability(int x) {
        return FastMath.log(this.probability(x));
    }
}

